/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import de.justsoftware.drive.rest.monitoring.StorageServerHealthIndicator;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.system.DiskSpaceHealthIndicator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="just.drive.upload")
@RefreshScope
@ParametersAreNonnullByDefault
public class FileUploadConfigProperties {
    private static final DataSize DEFAULT_UPLOAD_MAX_FILE_SIZE = DataSize.ofMegabytes((long)250L);
    @Autowired
    private DiskSpaceHealthIndicator _diskSpaceHealthIndicator;
    @Autowired
    private StorageServerHealthIndicator _storageServerHealthIndicator;
    private Set<MimeType> _allowedMimeTypes = Set.of();
    private DataSize _uploadMaxFileSize = DEFAULT_UPLOAD_MAX_FILE_SIZE;

    @Nonnull
    public DataSize getUploadMaxFileSize() {
        boolean isDiskSpaceOk = this._diskSpaceHealthIndicator.getHealth(false).getStatus().equals((Object)Status.UP);
        boolean isStorageServerOk = this._storageServerHealthIndicator.getHealth(false).getStatus().equals((Object)Status.UP);
        if (!isDiskSpaceOk || !isStorageServerOk) {
            return DataSize.ofBytes((long)0L);
        }
        return this._uploadMaxFileSize;
    }

    public void setUploadMaxFileSize(DataSize uploadMaxFileSize) {
        this._uploadMaxFileSize = uploadMaxFileSize;
    }

    @Nonnull
    public Set<MimeType> getAllowedMimeTypes() {
        return this._allowedMimeTypes;
    }

    public void setAllowedMimeTypes(String[] allowedMimeTypes) {
        this._allowedMimeTypes = Arrays.stream(allowedMimeTypes).map(MimeTypeUtils::parseMimeType).collect(Collectors.toSet());
    }
}

