/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class CachingMapLoader<K, V>
implements Function<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CachingMapLoader.class);
    private final HashMap<K, V> _cache = new HashMap();
    private HashSet<K> _missing = new HashSet();
    private final HashSet<K> _loadedKeys = new HashSet();
    private final Function<? super Set<K>, ? extends Map<? extends K, ? extends V>> _loadFunction;
    private Logger _log;

    @VisibleForTesting
    CachingMapLoader(Function<? super Set<K>, ? extends Map<? extends K, ? extends V>> loadFunction, Logger log) {
        this._loadFunction = loadFunction;
        this._log = log;
    }

    public CachingMapLoader(Function<? super Set<K>, ? extends Map<? extends K, ? extends V>> loadFunction) {
        this(loadFunction, LOG);
    }

    @Nonnull
    public Map<K, V> get(Set<? extends K> keys) {
        this.checkMissingAndUpdate(keys);
        return Collections.unmodifiableMap(Maps.filterKeys((Map)this._cache, (Predicate)Predicates.in(keys)));
    }

    @CheckForNull
    public V get(K key) {
        this.checkMissingAndUpdate((Set)ImmutableSet.of(key));
        return this._cache.get(key);
    }

    private void checkMissingAndUpdate(Set<? extends K> keys) {
        this._loadedKeys.addAll(this._missing);
        Sets.SetView difference = Sets.difference(keys, (Set)this._loadedKeys);
        if (!difference.isEmpty()) {
            this._log.error("keys were not added to the loader before calling get: " + String.valueOf(keys), (Throwable)new IllegalStateException());
            this._missing.addAll(difference);
            this._loadedKeys.addAll(keys);
        }
        if (!this._missing.isEmpty()) {
            this._cache.putAll((Map)this._loadFunction.apply((Object)this._missing));
            this._missing = new HashSet();
        }
    }

    public void addMissing(K key) {
        if (!this._loadedKeys.contains(key)) {
            this._missing.add(key);
        }
    }

    public void addMissing(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.addMissing(key);
        }
    }

    public V apply(K input) {
        return (V)(input != null ? this.get(input) : null);
    }
}

