/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class DrivePermissionConfig {
    @VisibleForTesting
    static final String TOPIC = "just.permission.config";
    private static final Logger LOG = LoggerFactory.getLogger(DrivePermissionConfig.class);
    private static final long MAX_RETRY_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private final Producer<String, String> _producer;
    private long _retryTimeout = TimeUnit.SECONDS.toMillis(1L);

    @Autowired
    public DrivePermissionConfig(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer) {
        this._producer = producer;
    }

    @PostConstruct
    public void init() {
        if (this._producer != null) {
            Thread t = new Thread(() -> this.sendConfig());
            t.setName("DrivePermissionConfig");
            t.start();
        }
    }

    @VisibleForTesting
    void sendConfig() {
        try {
            while (true) {
                try {
                    LinkedList<Future> futures = new LinkedList<Future>();
                    futures.add(this.send("SHARE", "share-config.json"));
                    for (Future f : futures) {
                        f.get();
                    }
                    LOG.info("drive permission config successfully sent");
                    return;
                }
                catch (ExecutionException e) {
                    LOG.warn("unable to send config to kafka, retrying in " + this._retryTimeout + "ms ", (Throwable)e);
                    Thread.sleep(this._retryTimeout);
                    this._retryTimeout = Math.min(this._retryTimeout * 2L, MAX_RETRY_TIMEOUT);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            LOG.error("unable to read resource", (Throwable)e);
        }
    }

    @Nonnull
    private Future<RecordMetadata> send(String itemType, String filename) throws IOException {
        return this._producer.send(new ProducerRecord(TOPIC, (Object)itemType, (Object)Resources.toString((URL)Resources.getResource(this.getClass(), (String)filename), (Charset)Charsets.UTF_8)));
    }
}

