/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AbstractAuthorizationContextImpl;
import de.justsoftware.drive.business.authorization.AuthorizationKey;
import de.justsoftware.drive.business.authorization.AuthorizationResolver;
import de.justsoftware.drive.business.authorization.AuthorizationResult;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DefaultAuthorizationContext
extends AbstractAuthorizationContextImpl {
    @VisibleForTesting
    final PermissionRequestConnector _permissionRequestConnector;
    private final AuthorizationResolver _authorizationResolver;

    public DefaultAuthorizationContext(PersonId personId, @Nullable TenantId tenantId, AuthorizationResolver authorizationResolver, PermissionRequestConnector permissionRequestConnector) {
        super(personId, tenantId);
        this._authorizationResolver = authorizationResolver;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public <I extends AbstractId<?>> ImmutableMap<AuthorizationKey<I>, AuthorizationResult> allowed(Set<AuthorizationKey<I>> actions) {
        return this._authorizationResolver.resolveAllowedActions(actions);
    }

    public void check(Set<Role> rolesToCheck) {
        ImmutableSet notAllowed;
        ImmutableMap result = this._permissionRequestConnector.hasRoles(rolesToCheck, (Iterable)ImmutableSet.of((Object)this._personId.asPermissionRole()));
        ImmutableSet notFound = (ImmutableSet)rolesToCheck.stream().filter(role -> de.justsoftware.permission.client.model.AuthorizationResult.NOT_FOUND.equals(result.getOrDefault(role, (Object)de.justsoftware.permission.client.model.AuthorizationResult.NOT_FOUND))).collect(ImmutableSet.toImmutableSet());
        if (!notFound.isEmpty()) {
            this.throwPermissionDenied(rolesToCheck);
        }
        if (!(notAllowed = (ImmutableSet)rolesToCheck.stream().filter(role -> de.justsoftware.permission.client.model.AuthorizationResult.NOT_ALLOWED.equals(result.get(role))).collect(ImmutableSet.toImmutableSet())).isEmpty()) {
            this.throwPermissionDenied(rolesToCheck);
        }
    }

    public boolean may(Role roleToCheck) {
        ImmutableMap result = this._permissionRequestConnector.hasRoles((Iterable)ImmutableSet.of((Object)roleToCheck), (Iterable)ImmutableSet.of((Object)this._personId.asPermissionRole()));
        return de.justsoftware.permission.client.model.AuthorizationResult.OK == result.get((Object)roleToCheck);
    }

    public void checkRead(Role itemId, Set<Role> rolesToCheck) {
        if (!this._permissionRequestConnector.allHaveRole(itemId, rolesToCheck)) {
            this.throwPermissionDenied(rolesToCheck);
        }
    }

    private void throwPermissionDenied(Set<Role> rolesToCheck) {
        throw new PermissionDeniedException("One or more of the provided member IDs " + String.valueOf(rolesToCheck) + " are invalid");
    }

    public ImmutableSet<Role> getSearchRoles() {
        return this._permissionRequestConnector.searchRoles(this._personId.asPermissionRole());
    }
}

