/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.business.authorization.AuthorizationItem;
import de.justsoftware.drive.business.authorization.AuthorizationKey;
import de.justsoftware.drive.business.authorization.AuthorizationResolver;
import de.justsoftware.drive.business.authorization.AuthorizationResult;
import de.justsoftware.drive.business.authorization.ItemService;
import de.justsoftware.drive.business.authorization.impl.AuthorizationResolverImpl;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class AuthorizationResolverImpl
implements AuthorizationResolver {
    private final ItemService _itemService;
    private final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public AuthorizationResolverImpl(ItemService itemService, PermissionRequestConnector permissionRequestConnector) {
        this._itemService = itemService;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public <I extends AbstractId<?>> ImmutableMap<AuthorizationKey<I>, AuthorizationResult> resolveAllowedActions(Set<AuthorizationKey<I>> authorizationKeys) {
        ImmutableSet ids = FluentIterable.from(authorizationKeys).transformAndConcat(input -> input.getId().asSet()).toSet();
        ImmutableListMultimap items = this._itemService.loadItems((Set)ids);
        ImmutableSetMultimap.Builder shareActions = ImmutableSetMultimap.builder();
        for (AuthorizationKey authorizationKey : authorizationKeys) {
            ImmutableList path = items.get((Object)((AbstractId)authorizationKey.getId().orNull()));
            path.stream().map(AuthorizationItem::getId).filter(ItemId.class::isInstance).map(ItemId.class::cast).forEach(itemId -> shareActions.put((Object)authorizationKey.getPersonId().asPermissionRole(), (Object)AuthorizationResolverImpl.roleForPermission((AuthorizationKey)authorizationKey, (ItemId)itemId)));
        }
        ImmutableSetMultimap sharePermissions = this._permissionRequestConnector.filterRoles((SetMultimap)shareActions.build());
        return (ImmutableMap)authorizationKeys.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), authKey -> AuthorizationResolverImpl.getAuthorizationResult((ImmutableListMultimap)items, (ImmutableSetMultimap)sharePermissions, (AuthorizationKey)authKey)));
    }

    @Nonnull
    private static <I extends AbstractId<?>> AuthorizationResult getAuthorizationResult(ImmutableListMultimap<AbstractId<?>, AuthorizationItem<?>> items, ImmutableSetMultimap<Role, Role> sharePermissions, AuthorizationKey<I> authKey) {
        AbstractId id = (AbstractId)authKey.getId().orNull();
        ImmutableList path = items.get((Object)id);
        if (path.isEmpty() || Iterables.tryFind((Iterable)path, AuthorizationItem::isDeleted).isPresent()) {
            return AuthorizationResult.RESOURCE_NOT_FOUND;
        }
        boolean allowed = path.stream().anyMatch(pathItem -> (Boolean)pathItem.accept((AuthorizationItem.Visitor)new /* Unavailable Anonymous Inner Class!! */));
        return allowed ? AuthorizationResult.OK : AuthorizationResult.NOT_ALLOWED;
    }

    @Nonnull
    private static Role roleForPermission(AuthorizationKey<?> authorizationKey, ItemId itemId) {
        String actionName = AuthorizationResolverImpl.permissionActionName(authorizationKey);
        return Role.itemRole((String)actionName, (String)((String)itemId.getId()));
    }

    @Nonnull
    private static String permissionActionName(AuthorizationKey<?> authorizationKey) {
        return switch (2.$SwitchMap$de$justsoftware$drive$common$authorization$model$StaticAction[authorizationKey.getAction().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "READ";
            case 2 -> "WRITE";
            case 3 -> "DOCUMENT_DELETE";
            case 4 -> "DOCUMENT_DELETE_BY_OWNER";
            case 5 -> "MANAGE";
            case 6 -> "DOCUMENT_DOWNLOAD";
        };
    }
}

