/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.accessrequest;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.accessrequest.AccessRequestService;
import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.accessrequest.AccessRequestDAO;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class AccessRequestServiceImpl
implements AccessRequestService {
    private final AccessRequestDAO _accessRequestDAO;

    @Autowired
    public AccessRequestServiceImpl(AccessRequestDAO accessRequestDAO) {
        this._accessRequestDAO = accessRequestDAO;
    }

    public void updatePendingRequests(Set<PersonId> newlyPermittedUsers, ItemId targetShare) {
        this._accessRequestDAO.deletePendingRequestsForPermittedUsers(newlyPermittedUsers, targetShare);
    }

    public void createAccessRequest(PersonId requestingUser, ItemId requestedShare) {
        boolean userAlreadyRequestedAccess = this._accessRequestDAO.getPendingRequestsForUser(requestingUser).stream().anyMatch(existingRequest -> existingRequest.getShareId().equals((Object)requestedShare));
        if (!userAlreadyRequestedAccess) {
            this._accessRequestDAO.createNewAccessRequest(requestingUser, requestedShare);
        }
    }

    @Nonnull
    public ImmutableSet<AccessRequestBO> getPendingRequestsForShare(ItemId shareId) {
        return this._accessRequestDAO.getPendingRequestsForShare(shareId);
    }

    public void cancelAllRequestsForUser(PersonId userId) {
        this._accessRequestDAO.deletePendingRequestsForUser(userId);
    }

    public void cancelAllRequestsForShare(ItemId shareId) {
        this._accessRequestDAO.deletePendingRequestsForShare(shareId);
    }

    public void cancelRequestForUsersAndShare(Set<PersonId> userIds, ItemId shareId) {
        this._accessRequestDAO.deletePendingRequestsForUsersAndShare(userIds, shareId);
    }
}

