/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.util.CommandExecutionException;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import de.justsoftware.justdocumentz.virusscan.VirusScanException;
import de.justsoftware.justdocumentz.virusscan.VirusScanResult;
import de.justsoftware.justdocumentz.virusscan.VirusScanService;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/justdocumentz/virusscan/VirusScanService;", "", "()V", "logger", "Lorg/slf4j/Logger;", "findVirus", "Lde/justsoftware/justdocumentz/virusscan/VirusScanResult;", "path", "Ljava/nio/file/Path;", "parseVirusSignatureCode", "", "output", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nVirusScanService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirusScanService.kt\nde/justsoftware/justdocumentz/virusscan/VirusScanService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,86:1\n9#2:87\n*S KotlinDebug\n*F\n+ 1 VirusScanService.kt\nde/justsoftware/justdocumentz/virusscan/VirusScanService\n*L\n20#1:87\n*E\n"})
public class VirusScanService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private static final int EXIT_CODE_OK = 0;
    private static final int EXIT_CODE_VIRUS = 1;
    private static final Pattern VIRUS_SIGNATURE_CODE_PATTERN = Pattern.compile(".*: (.*) FOUND");

    public VirusScanService() {
        VirusScanService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(VirusScanService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public VirusScanResult findVirus(@NotNull Path path) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            objectArray = new String[]{"podman", "exec", "-it", "judo-clamd", "clamdscan", "-i", "--no-summary", "/scandir/" + path.getFileName()};
            List list = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new Integer[]{0, 1};
            objectArray = CommandLineUtilsKt.executeCommandLine-hhJSO8g((List)list, (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, (Collection)SetsKt.setOf((Object[])objectArray));
        }
        catch (CommandExecutionException e) {
            throw new VirusScanException("Virus scan failed: " + e.getMessage(), (Throwable)e);
        }
        String[] stringArray = objectArray;
        String output = stringArray.component1();
        int exitCode = stringArray.component2();
        return switch (exitCode) {
            case 0 -> new VirusScanResult(false, null, 2, null);
            case 1 -> new VirusScanResult(true, this.parseVirusSignatureCode(output));
            default -> throw new IllegalStateException(("Unexpected exit code " + exitCode).toString());
        };
    }

    private String parseVirusSignatureCode(String output) {
        String string;
        Matcher matcher = VIRUS_SIGNATURE_CODE_PATTERN.matcher(output);
        if (matcher.find()) {
            string = matcher.group(1);
        } else {
            this.logger.warn("Parsing virus signature code failed. output: {}", (Object)((Object)StringsKt.trim((CharSequence)output)).toString());
            string = null;
        }
        return string;
    }
}

