/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.monitoring;

import de.justsoftware.justdocumentz.events.ConversionServicesInitializedEvent;
import de.justsoftware.justdocumentz.monitoring.ConversionAvailabilityTracker;
import de.justsoftware.justdocumentz.monitoring.ConversionType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0012J\b\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "Lorg/springframework/boot/actuate/health/HealthIndicator;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/springframework/context/ApplicationEventPublisher;)V", "documentAvailable", "", "Ljava/lang/Boolean;", "logger", "Lorg/slf4j/Logger;", "videoAvailable", "canProcess", "type", "Lde/justsoftware/justdocumentz/monitoring/ConversionType;", "health", "Lorg/springframework/boot/actuate/health/Health;", "isFullyInitialized", "publishInitializationComplete", "", "setDocumentAvailable", "available", "setVideoAvailable", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nConversionAvailabilityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionAvailabilityTracker.kt\nde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,77:1\n9#2:78\n*S KotlinDebug\n*F\n+ 1 ConversionAvailabilityTracker.kt\nde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker\n*L\n20#1:78\n*E\n"})
public class ConversionAvailabilityTracker
implements HealthIndicator {
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Logger logger;
    @Nullable
    private volatile Boolean videoAvailable;
    @Nullable
    private volatile Boolean documentAvailable;

    public ConversionAvailabilityTracker(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.applicationEventPublisher = applicationEventPublisher;
        ConversionAvailabilityTracker $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(ConversionAvailabilityTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public Health health() {
        Health health;
        boolean allAvailable;
        boolean bl = allAvailable = Intrinsics.areEqual((Object)this.videoAvailable, (Object)true) && Intrinsics.areEqual((Object)this.documentAvailable, (Object)true);
        if (allAvailable) {
            Health health2 = Health.up().withDetail("Video conversion", (Object)"UP").withDetail("Document conversion", (Object)"UP").build();
            Intrinsics.checkNotNull((Object)health2);
            health = health2;
        } else {
            Health health3 = Health.down().withDetail("Video conversion", (Object)(Intrinsics.areEqual((Object)this.videoAvailable, (Object)true) ? "UP" : "DOWN")).withDetail("Document conversion", (Object)(Intrinsics.areEqual((Object)this.documentAvailable, (Object)true) ? "UP" : "DOWN")).build();
            Intrinsics.checkNotNull((Object)health3);
            health = health3;
        }
        return health;
    }

    public void setVideoAvailable(boolean available) {
        this.videoAvailable = available;
        this.logger.info("Video conversion availability set to: " + available);
        if (this.isFullyInitialized()) {
            this.publishInitializationComplete();
        }
    }

    public void setDocumentAvailable(boolean available) {
        this.documentAvailable = available;
        this.logger.info("Document conversion availability set to: " + available);
        if (this.isFullyInitialized()) {
            this.publishInitializationComplete();
        }
    }

    public boolean canProcess(@NotNull ConversionType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> Intrinsics.areEqual((Object)this.documentAvailable, (Object)true);
            case 2 -> Intrinsics.areEqual((Object)this.videoAvailable, (Object)true);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private boolean isFullyInitialized() {
        return this.videoAvailable != null && this.documentAvailable != null;
    }

    private void publishInitializationComplete() {
        this.logger.info("Both conversion services initialized (video: " + this.videoAvailable + ", document: " + this.documentAvailable + ")");
        Boolean bl = this.videoAvailable;
        Boolean bl2 = this.documentAvailable;
        this.applicationEventPublisher.publishEvent((Object)new ConversionServicesInitializedEvent(bl != null ? bl : false, bl2 != null ? bl2 : false, (Object)this));
    }
}

