/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.document;

import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.conversions.document.Pdf2IFrameConversionService;
import de.justsoftware.justdocumentz.conversions.document.PdfMetaData;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0012J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000fH\u0012J\u001e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0012J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u0012H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "environment", "Lorg/springframework/core/env/Environment;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lorg/springframework/core/env/Environment;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "justContainerVersion", "", "justPdfToPpmImage", "logger", "Lorg/slf4j/Logger;", "pageLimit", "", "buildIframe", "", "Ljava/nio/file/Path;", "imageFiles", "tempDir", "originalPageCount", "title", "convert", "pdfFile", "convertToImages", "inputFile", "pageCount", "generateIframeHtml", "fileNames", "getPdfMetaData", "Lde/justsoftware/justdocumentz/conversions/document/PdfMetaData;", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n9#2:367\n1#3:368\n1045#4:369\n1549#4:370\n1620#4,3:371\n*S KotlinDebug\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService\n*L\n160#1:367\n262#1:369\n285#1:370\n285#1:371,3\n*E\n"})
public class Pdf2IFrameConversionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final Logger logger;
    private final int pageLimit;
    @Nullable
    private final String justContainerVersion;
    @NotNull
    private final String justPdfToPpmImage;
    @NotNull
    private static final Pattern pdfInfoTitlePattern;
    @NotNull
    private static final Pattern pdfInfoPageCountPattern;
    @NotNull
    private static final Path endOfPreviewResource;

    /*
     * WARNING - void declaration
     */
    public Pdf2IFrameConversionService(@NotNull JudoConfig config, @NotNull Environment environment) {
        void it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.config = config;
        Pdf2IFrameConversionService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Pdf2IFrameConversionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        Integer n = this.getConfig().getConverter().getPageLimit();
        int n2 = ((Number)n).intValue();
        Pdf2IFrameConversionService pdf2IFrameConversionService = this;
        boolean bl = false;
        boolean bl2 = it > 0;
        Integer n3 = bl2 ? n : null;
        pdf2IFrameConversionService.pageLimit = n3 != null ? n3 : Integer.MAX_VALUE;
        this.justContainerVersion = environment.getProperty("just.containerVersion");
        this.justPdfToPpmImage = "docker.io/justsocial/just-pdftoppm:" + this.justContainerVersion;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public List<Path> convert(@NotNull Path pdfFile, @NotNull Path tempDir) {
        List list;
        PdfMetaData pdfMetaData;
        Intrinsics.checkNotNullParameter((Object)pdfFile, (String)"pdfFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        PdfMetaData it = pdfMetaData = this.getPdfMetaData(pdfFile);
        boolean bl = false;
        this.logger.debug("pdfPageCount: {}, title: {}", (Object)it.getPageCount(), (Object)it.getTitle());
        PdfMetaData pdfMetaData2 = pdfMetaData;
        int pdfPageCount = pdfMetaData2.component1();
        String title = pdfMetaData2.component2();
        List it2 = list = this.convertToImages(pdfFile, tempDir, pdfPageCount);
        boolean bl2 = false;
        this.logger.debug("imageFiles {}", (Object)it2);
        List imageFiles = list;
        it2 = list = this.buildIframe(imageFiles, tempDir, pdfPageCount, title);
        boolean bl3 = false;
        this.logger.debug("iFrame: {}", (Object)it2);
        return list;
    }

    private PdfMetaData getPdfMetaData(Path inputFile) {
        List $i$a$-require-Pdf2IFrameConversionService$getPdfMetaData$222;
        if (!Files.exists(inputFile, new LinkOption[0])) {
            boolean $i$a$-require-Pdf2IFrameConversionService$getPdfMetaData$222 = false;
            String $i$a$-require-Pdf2IFrameConversionService$getPdfMetaData$222 = "File " + inputFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-Pdf2IFrameConversionService$getPdfMetaData$222.toString());
        }
        List $this$getPdfMetaData_u24lambda_u245 = $i$a$-require-Pdf2IFrameConversionService$getPdfMetaData$222 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object[] objectArray = new String[]{"--name", "pdfinfo-" + PathsKt.getNameWithoutExtension((Path)inputFile), "-u", "justsoftware", "-v", inputFile + ":" + inputFile + ":ro", this.justPdfToPpmImage, "pdfinfo", String.valueOf(inputFile)};
        $this$getPdfMetaData_u24lambda_u245.addAll(CollectionsKt.listOf((Object[])objectArray));
        String output = CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.build((List)$i$a$-require-Pdf2IFrameConversionService$getPdfMetaData$222), (PodmanConfig)this.getConfig().getPodman().getPdftoppm(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)), (boolean)false, null, (int)16, null).component1();
        Matcher it = pdfInfoTitlePattern.matcher(output);
        boolean bl2 = false;
        String title = it.find() ? it.group(1) : null;
        Matcher it2 = pdfInfoPageCountPattern.matcher(output);
        boolean bl3 = false;
        if (!it2.find()) {
            boolean bl4 = false;
            String string = "can't read pdf: " + output;
            throw new IllegalStateException(string.toString());
        }
        String string = it2.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        int pageCount = Integer.parseInt(string);
        return new PdfMetaData(pageCount, title);
    }

    /*
     * WARNING - void declaration
     */
    private List<Path> convertToImages(Path inputFile, Path tempDir, int pageCount) {
        void $this$sortedBy$iv;
        Iterable iterable;
        if (!Files.exists(inputFile, new LinkOption[0])) {
            boolean $i$a$-require-Pdf2IFrameConversionService$convertToImages$22 = false;
            String $i$a$-require-Pdf2IFrameConversionService$convertToImages$22 = "File " + inputFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-Pdf2IFrameConversionService$convertToImages$22.toString());
        }
        Path inputDir = inputFile.getParent();
        String containerOutputDir = "/home/justsoftware/workspace";
        List $this$convertToImages_u24lambda_u2410 = iterable = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object[] objectArray = new String[]{"--name", "pdf2jpeghtml-" + PathsKt.getNameWithoutExtension((Path)inputFile), "-u", "justsoftware", "-v", inputDir + ":" + inputDir + ":Z", "-v", tempDir + ":" + containerOutputDir + ":Z", this.justPdfToPpmImage, "pdftoppm", "-png", String.valueOf(inputFile), "-r", "100", "-sz", "904800"};
        $this$convertToImages_u24lambda_u2410.addAll(CollectionsKt.listOf((Object[])objectArray));
        if (this.pageLimit >= 1 && pageCount >= this.pageLimit) {
            objectArray = new String[]{"-l", String.valueOf(this.pageLimit)};
            $this$convertToImages_u24lambda_u2410.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        $this$convertToImages_u24lambda_u2410.add(containerOutputDir + "/bg");
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.build((List)iterable), (PodmanConfig)this.getConfig().getPodman().getPdftoppm(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)24, null);
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(tempDir, "bg-*.png");
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"newDirectoryStream(...)");
        iterable = directoryStream;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    private List<Path> buildIframe(List<? extends Path> imageFiles, Path tempDir, int originalPageCount, String title) {
        List list;
        block5: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$buildIframe_u24lambda_u2414;
            String string;
            Path endOfPreviewPath;
            Iterable<Path> it;
            if (originalPageCount > this.pageLimit) {
                Path path;
                it = path = tempDir.resolve("end_of_preview.png");
                boolean bl = false;
                Files.copy(endOfPreviewResource, it, new CopyOption[0]);
                v0 = path;
            } else {
                v0 = endOfPreviewPath = null;
            }
            if ((string = title) == null) {
                string = "";
            }
            Iterable<Path> bl = it = CollectionsKt.createListBuilder();
            String string2 = string;
            Pdf2IFrameConversionService pdf2IFrameConversionService = this;
            boolean $i$a$-buildList-Pdf2IFrameConversionService$buildIframe$previewHtml$22 = false;
            $this$buildIframe_u24lambda_u2414.addAll((Collection)imageFiles);
            Path path = endOfPreviewPath;
            if (path != null) {
                Path it2 = path;
                boolean bl2 = false;
                $this$buildIframe_u24lambda_u2414.add(it2);
            }
            Object object = Unit.INSTANCE;
            it = CollectionsKt.build((List)it);
            boolean $i$f$map = false;
            void $i$a$-buildList-Pdf2IFrameConversionService$buildIframe$previewHtml$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Path path2 = (Path)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(((Object)it3.getFileName()).toString());
            }
            object = (List)destination$iv$iv;
            String previewHtml = pdf2IFrameConversionService.generateIframeHtml(string2, (List)object);
            Path htmlPath = tempDir.resolve("index.html");
            Intrinsics.checkNotNull((Object)htmlPath);
            PathsKt.writeText((Path)htmlPath, (CharSequence)previewHtml, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
            List $this$buildIframe_u24lambda_u2417 = list = CollectionsKt.createListBuilder();
            boolean bl4 = false;
            $this$buildIframe_u24lambda_u2417.add(htmlPath);
            $this$buildIframe_u24lambda_u2417.addAll((Collection)imageFiles);
            Path path3 = endOfPreviewPath;
            if (path3 == null) break block5;
            Path it4 = path3;
            boolean bl5 = false;
            $this$buildIframe_u24lambda_u2417.add(it4);
        }
        return CollectionsKt.build((List)list);
    }

    private String generateIframeHtml(String title, List<String> fileNames) {
        return StringsKt.trimIndent((String)("\n            <!DOCTYPE html>\n            <html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"\" xml:lang=\"\">\n                <head>\n                    <title>" + title + "</title>\n                    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n                    <style type=\"text/css\">\n                        html, body {\n                            height: 100%;\n                            width: 100%;\n                        }\n\n                        .siteStyle {\n                            background-color: transparent;\n                            margin: 0;\n                        }\n\n                        .judo-wrapper {\n                            height: 100%;\n                            width: 100%;\n                            overflow: auto;\n                        }\n\n                        .pageStyle {\n                            margin: auto;\n                            padding: 5px 5px 5px 5px;\n                            text-align: center;\n                        }\n\n                        .imageStyle {\n                            margin: 0 auto;\n                            max-width: 100%;\n                            display: block;\n                        }\n                    </style>\n                    <script>\n                        function init() {\n                            const wrapperElement = document.querySelector(\".judo-wrapper\");\n                            wrapperElement.addEventListener(\"click\", evt => {\n                                if (evt.target === wrapperElement) {\n                                    parent.postMessage(\"outerContentClicked\", parent.location.origin);\n                                }\n                            });\n                        }\n                    </script>\n                </head>\n                <body onload=\"init();\" class=\"siteStyle\">\n                    <div class=\"judo-wrapper\">\n                        " + CollectionsKt.joinToString$default((Iterable)fileNames, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)generateIframeHtml.1.INSTANCE), (int)30, null) + "\n                    </div>\n                </body>\n            </html>\n        "));
    }

    public static final /* synthetic */ Pattern access$getPdfInfoTitlePattern$cp() {
        return pdfInfoTitlePattern;
    }

    public static final /* synthetic */ Pattern access$getPdfInfoPageCountPattern$cp() {
        return pdfInfoPageCountPattern;
    }

    public static final /* synthetic */ Path access$getEndOfPreviewResource$cp() {
        return endOfPreviewResource;
    }

    static {
        Pattern pattern = Pattern.compile("Title:\\s*(.*)\\n");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        pdfInfoTitlePattern = pattern;
        Pattern pattern2 = Pattern.compile("Pages:\\s*(.*)\\n");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        pdfInfoPageCountPattern = pattern2;
        URL uRL = Companion.getClass().getClassLoader().getResource("assets/end_of_preview.png");
        if (uRL == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        URI uRI = uRL.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Path path = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        endOfPreviewResource = path;
    }
}

