/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions;

import de.justsoftware.justdocumentz.conversions.ConversionJobService;
import de.justsoftware.justdocumentz.conversions.ConversionTask;
import de.justsoftware.justdocumentz.conversions.KafkaConversionTaskListener;
import de.justsoftware.justdocumentz.events.ConversionServicesInitializedEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/justdocumentz/conversions/KafkaConversionTaskListener;", "", "conversionJobService", "Lde/justsoftware/justdocumentz/conversions/ConversionJobService;", "kafkaListenerEndpointRegistry", "Lorg/springframework/kafka/config/KafkaListenerEndpointRegistry;", "(Lde/justsoftware/justdocumentz/conversions/ConversionJobService;Lorg/springframework/kafka/config/KafkaListenerEndpointRegistry;)V", "logger", "Lorg/slf4j/Logger;", "listen", "", "task", "Lde/justsoftware/justdocumentz/conversions/ConversionTask;", "onServicesInitialized", "event", "Lde/justsoftware/justdocumentz/events/ConversionServicesInitializedEvent;", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentConversionKafka.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConversionKafka.kt\nde/justsoftware/justdocumentz/conversions/KafkaConversionTaskListener\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,136:1\n9#2:137\n*S KotlinDebug\n*F\n+ 1 DocumentConversionKafka.kt\nde/justsoftware/justdocumentz/conversions/KafkaConversionTaskListener\n*L\n53#1:137\n*E\n"})
public class KafkaConversionTaskListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConversionJobService conversionJobService;
    @NotNull
    private final KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry;
    @NotNull
    private final Logger logger;
    @NotNull
    public static final String LISTENER_ID = "conversion_task_listener";

    public KafkaConversionTaskListener(@NotNull ConversionJobService conversionJobService, @NotNull KafkaListenerEndpointRegistry kafkaListenerEndpointRegistry) {
        Intrinsics.checkNotNullParameter((Object)conversionJobService, (String)"conversionJobService");
        Intrinsics.checkNotNullParameter((Object)kafkaListenerEndpointRegistry, (String)"kafkaListenerEndpointRegistry");
        this.conversionJobService = conversionJobService;
        this.kafkaListenerEndpointRegistry = kafkaListenerEndpointRegistry;
        KafkaConversionTaskListener $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(KafkaConversionTaskListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @KafkaListener(id="conversion_task_listener", containerFactory="kafkaConversionTaskListenerContainerFactory", topics={"just.documents.conversion.taskv2"}, autoStartup="false")
    public void listen(@Payload @NotNull ConversionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.logger.info("Received conversion task for task: " + task.getId());
        this.conversionJobService.convertDocument(task);
    }

    @EventListener
    public void onServicesInitialized(@NotNull ConversionServicesInitializedEvent event) {
        MessageListenerContainer listener;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MessageListenerContainer messageListenerContainer = listener = this.kafkaListenerEndpointRegistry.getListenerContainer(LISTENER_ID);
        boolean bl = messageListenerContainer != null ? !messageListenerContainer.isRunning() : false;
        if (bl) {
            listener.start();
            this.logger.info("Started conversion Kafka listener (video: " + event.getVideoAvailable() + ", document: " + event.getDocumentAvailable() + ")");
        }
    }
}

