/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions;

import de.justsoftware.justdocumentz.common.FileCacheService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.conversions.ConversionTask;
import de.justsoftware.justdocumentz.conversions.TaskStatus;
import de.justsoftware.justdocumentz.conversions.UnsupportedConversionException;
import de.justsoftware.justdocumentz.conversions.document.DocumentConversionService;
import de.justsoftware.justdocumentz.conversions.video.VideoConversionResult;
import de.justsoftware.justdocumentz.conversions.video.VideoConversionService;
import de.justsoftware.justdocumentz.events.ConversionStatusChangeEvent;
import de.justsoftware.justdocumentz.monitoring.ConversionAvailabilityTracker;
import de.justsoftware.justdocumentz.monitoring.ConversionType;
import de.justsoftware.justdocumentz.util.FileUtilsKt;
import de.justsoftware.justdocumentz.util.StoragePaths;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0012J(\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0012J\u0010\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0012R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lde/justsoftware/justdocumentz/conversions/ConversionJobService;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "videoConversionService", "Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;", "documentConversionService", "Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "fileCacheService", "Lde/justsoftware/justdocumentz/common/FileCacheService;", "storagePaths", "Lde/justsoftware/justdocumentz/util/StoragePaths;", "availabilityTracker", "Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/justdocumentz/common/FileCacheService;Lde/justsoftware/justdocumentz/util/StoragePaths;Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;)V", "getAvailabilityTracker", "()Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getDocumentConversionService", "()Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;", "getEventPublisher", "()Lorg/springframework/context/ApplicationEventPublisher;", "getFileCacheService", "()Lde/justsoftware/justdocumentz/common/FileCacheService;", "logger", "Lorg/slf4j/Logger;", "getStoragePaths", "()Lde/justsoftware/justdocumentz/util/StoragePaths;", "getVideoConversionService", "()Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;", "convertAndPublishDocument", "", "task", "Lde/justsoftware/justdocumentz/conversions/ConversionTask;", "mimeType", "Lorg/springframework/util/MimeType;", "downloadedFile", "Ljava/nio/file/Path;", "jobTempDir", "convertAndPublishVideo", "convertDocument", "publishConversionStatusChange", "status", "Lde/justsoftware/justdocumentz/conversions/TaskStatus;", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nConversionJobRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionJobRunner.kt\nde/justsoftware/justdocumentz/conversions/ConversionJobService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n9#2:166\n1#3:167\n1855#4,2:168\n*S KotlinDebug\n*F\n+ 1 ConversionJobRunner.kt\nde/justsoftware/justdocumentz/conversions/ConversionJobService\n*L\n40#1:166\n145#1:168,2\n*E\n"})
public class ConversionJobService {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final VideoConversionService videoConversionService;
    @NotNull
    private final DocumentConversionService documentConversionService;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final FileCacheService fileCacheService;
    @NotNull
    private final StoragePaths storagePaths;
    @NotNull
    private final ConversionAvailabilityTracker availabilityTracker;
    @NotNull
    private final Logger logger;

    public ConversionJobService(@NotNull JudoConfig config, @NotNull VideoConversionService videoConversionService, @NotNull DocumentConversionService documentConversionService, @NotNull ApplicationEventPublisher eventPublisher, @NotNull FileCacheService fileCacheService, @NotNull StoragePaths storagePaths, @NotNull ConversionAvailabilityTracker availabilityTracker) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)videoConversionService, (String)"videoConversionService");
        Intrinsics.checkNotNullParameter((Object)documentConversionService, (String)"documentConversionService");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)fileCacheService, (String)"fileCacheService");
        Intrinsics.checkNotNullParameter((Object)storagePaths, (String)"storagePaths");
        Intrinsics.checkNotNullParameter((Object)availabilityTracker, (String)"availabilityTracker");
        this.config = config;
        this.videoConversionService = videoConversionService;
        this.documentConversionService = documentConversionService;
        this.eventPublisher = eventPublisher;
        this.fileCacheService = fileCacheService;
        this.storagePaths = storagePaths;
        this.availabilityTracker = availabilityTracker;
        ConversionJobService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(ConversionJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public VideoConversionService getVideoConversionService() {
        return this.videoConversionService;
    }

    @NotNull
    public DocumentConversionService getDocumentConversionService() {
        return this.documentConversionService;
    }

    @NotNull
    public ApplicationEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @NotNull
    public FileCacheService getFileCacheService() {
        return this.fileCacheService;
    }

    @NotNull
    public StoragePaths getStoragePaths() {
        return this.storagePaths;
    }

    @NotNull
    public ConversionAvailabilityTracker getAvailabilityTracker() {
        return this.availabilityTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDocument(@NotNull ConversionTask task) {
        Object object;
        Object object2;
        Object it;
        ConversionJobService conversionJobService;
        Object $this$convertDocument_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.logger.info("Starting conversion for task: " + task.getId());
        this.publishConversionStatusChange(task, TaskStatus.PROCESSING);
        Object object3 = this;
        try {
            $this$convertDocument_u24lambda_u240 = object3;
            boolean bl = false;
            $this$convertDocument_u24lambda_u240 = Result.constructor-impl((Object)MimeTypeUtils.parseMimeType((String)task.getMimeType()));
        }
        catch (Throwable bl) {
            $this$convertDocument_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = $this$convertDocument_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Object it2 = $this$convertDocument_u24lambda_u240 = throwable;
            boolean bl = false;
            this.logger.warn("Failed to parse mime type " + task + ".mimeType. message: " + ((Throwable)it2).getMessage());
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
        if (throwable2 == null) {
            conversionJobService = object3;
        } else {
            it = throwable2;
            boolean bl = false;
            conversionJobService = (MimeType)MediaType.APPLICATION_OCTET_STREAM;
        }
        Intrinsics.checkNotNullExpressionValue((Object)conversionJobService, (String)"getOrElse(...)");
        MimeType mimeType = (MimeType)conversionJobService;
        if (!this.getDocumentConversionService().isSupported(mimeType) && !this.getVideoConversionService().isSupported(mimeType)) {
            this.logger.info("Unsupported conversion for task: " + task.getId() + ". storageId: " + task.getStorageId() + ". mimeType is not supported: " + task.getMimeType());
            this.publishConversionStatusChange(task, TaskStatus.UNSUPPORTED);
            return;
        }
        FileCacheService fileCacheService = this.getFileCacheService();
        String string = task.getStorageId();
        if (string == null) {
            string = task.getId();
        }
        if (Result.isSuccess-impl((Object)(object2 = fileCacheService.downloadToFileCache-0E7RQCE(string, task.getRemoteUrl(), false)))) {
            object3 = object2;
            try {
                Path path;
                it = object3;
                Path downloadedFile = (Path)it;
                boolean bl = false;
                Path it3 = path = this.getConfig().getTempDirPath().resolve(task.getId());
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it3);
                FileUtilsKt.ensureDirectoryExists((Path)it3);
                Path jobTempDir = path;
                try {
                    if (this.getVideoConversionService().isSupported(mimeType)) {
                        Intrinsics.checkNotNull((Object)jobTempDir);
                        this.convertAndPublishVideo(task, mimeType, downloadedFile, jobTempDir);
                    } else {
                        Intrinsics.checkNotNull((Object)jobTempDir);
                        this.convertAndPublishDocument(task, mimeType, downloadedFile, jobTempDir);
                    }
                    this.logger.info("Finished conversion for task: " + task.getId());
                    this.publishConversionStatusChange(task, TaskStatus.PRESENT);
                    FileUtilsKt.deleteDirectory((Path)jobTempDir, (boolean)true);
                }
                catch (UnsupportedConversionException e) {
                    this.logger.info("Unsupported conversion for task: " + task.getId() + ". storageId: " + task.getStorageId() + ". message: " + e.getMessage());
                    this.publishConversionStatusChange(task, TaskStatus.UNSUPPORTED);
                }
                finally {
                    Intrinsics.checkNotNull((Object)jobTempDir);
                    FileUtilsKt.deleteDirectory((Path)jobTempDir, (boolean)true);
                }
                it = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable downloadedFile) {
                it = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)downloadedFile));
            }
            object = it;
        } else {
            object = Result.constructor-impl((Object)object2);
        }
        object2 = object;
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable3 != null) {
            object3 = throwable3;
            it = object3;
            boolean bl = false;
            this.logger.error("Error during conversion for task: " + task.getId() + ". storageId: " + task.getStorageId(), (Throwable)it);
            this.publishConversionStatusChange(task, TaskStatus.ERROR);
        }
        Object it4 = object2;
        boolean bl = false;
        this.getFileCacheService().removeFromFileCache(task.getId());
    }

    private void convertAndPublishVideo(ConversionTask task, MimeType mimeType, Path downloadedFile, Path jobTempDir) {
        Object it;
        if (!this.getAvailabilityTracker().canProcess(ConversionType.VIDEO)) {
            boolean $i$a$-check-ConversionJobService$convertAndPublishVideo$22 = false;
            String $i$a$-check-ConversionJobService$convertAndPublishVideo$22 = "Video conversion currently not available";
            throw new IllegalStateException($i$a$-check-ConversionJobService$convertAndPublishVideo$22.toString());
        }
        VideoConversionResult videoConversionResult = this.getVideoConversionService().convert(downloadedFile, mimeType, jobTempDir);
        Path convertedVideoTempPath = videoConversionResult.component1();
        Path coverImageTempPath = videoConversionResult.component2();
        Object object = this.getStoragePaths().convertedVideo(task.getId());
        CopyOption[] copyOptionArray = object;
        Path path = convertedVideoTempPath;
        boolean bl = false;
        Path path2 = it.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        FileUtilsKt.ensureDirectoryExists((Path)path2);
        CopyOption[] copyOptionArray2 = object;
        object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(path, (Path)copyOptionArray2, (CopyOption[])object);
        if (coverImageTempPath != null) {
            it = object = this.getStoragePaths().coverImage(task.getId());
            path = coverImageTempPath;
            boolean bl2 = false;
            Path path3 = it.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            FileUtilsKt.ensureDirectoryExists((Path)path3);
            Object object2 = object;
            object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(path, (Path)object2, (CopyOption[])object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void convertAndPublishDocument(ConversionTask task, MimeType mimeType, Path downloadedFile, Path jobTempDir) {
        if (!this.getAvailabilityTracker().canProcess(ConversionType.DOCUMENT)) {
            boolean $i$a$-check-ConversionJobService$convertAndPublishDocument$22 = false;
            String $i$a$-check-ConversionJobService$convertAndPublishDocument$22 = "Document conversion currently not available";
            throw new IllegalStateException($i$a$-check-ConversionJobService$convertAndPublishDocument$22.toString());
        }
        List previewTempFiles = this.getDocumentConversionService().convert(downloadedFile, mimeType, jobTempDir);
        Iterable $this$forEach$iv = previewTempFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void it;
            CopyOption[] copyOptionArray;
            Path previewTempFile = (Path)element$iv;
            boolean bl = false;
            CopyOption[] copyOptionArray2 = copyOptionArray = this.getStoragePaths().documentPreviewFile(task.getId(), ((Object)previewTempFile.getFileName()).toString());
            Path path = previewTempFile;
            boolean bl2 = false;
            Path path2 = it.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            FileUtilsKt.ensureDirectoryExists((Path)path2);
            CopyOption[] copyOptionArray3 = copyOptionArray;
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(path, (Path)copyOptionArray3, copyOptionArray);
        }
    }

    private void publishConversionStatusChange(ConversionTask task, TaskStatus status) {
        this.getEventPublisher().publishEvent((Object)new ConversionStatusChangeEvent((Object)this, task, status));
    }
}

