/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.persistence.impl;

import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.exceptions.DirectoryCreateFailedException;
import de.justsoftware.jdoc.services.exceptions.DocumentNotFoundException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.services.exceptions.DocumentResourceNotFoundException;
import de.justsoftware.jdoc.services.persistence.DocumentRepository;
import de.justsoftware.jdoc.services.persistence.impl.FilesystemDAO;
import de.justsoftware.jdoc.services.persistence.impl.FilesystemDocumentDAO;
import de.justsoftware.jdoc.util.JustDocUtil;
import de.justsoftware.jdoc.util.ZipUtil;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FilesystemDocumentDAO
implements DocumentRepository {
    private final FilesystemDAO _fs;

    @Autowired
    public FilesystemDocumentDAO(FilesystemDAO fs) {
        this._fs = fs;
    }

    public boolean hasDocument(DocumentId documentId) {
        return this._fs.getDocumentFolder(documentId).exists();
    }

    public void createDocument(DocumentId documentId) throws DocumentReadWriteException {
        try {
            this._fs.createFolder(this._fs.getDocumentFolder(documentId));
        }
        catch (DirectoryCreateFailedException e) {
            throw new DocumentReadWriteException("can't create document:", (Throwable)e);
        }
    }

    public void deleteDocument(DocumentId documentId) throws DocumentNotFoundException, DocumentReadWriteException {
        this._fs.deleteDocument(documentId);
    }

    public boolean hasDocument(DocumentType type, DocumentId documentId) {
        return this._fs.getFile(documentId, type).exists();
    }

    public void writeDocument(DocumentType type, DocumentId documentId, DocumentInputStream documentStream) throws DocumentReadWriteException {
        try {
            this.checkDocumentExists(documentId);
            switch (1.$SwitchMap$de$justsoftware$jdoc$model$DocumentType[type.ordinal()]) {
                case 1: 
                case 2: {
                    this.writeFile(documentId, type, documentStream);
                    break;
                }
                case 3: {
                    this.writeArchiveFile(documentId, type, documentStream);
                    break;
                }
                default: {
                    throw new DocumentReadWriteException("unsupported document type: " + String.valueOf(type));
                }
            }
            if (!this.hasDocument(type, documentId)) {
                throw new DocumentNotFoundException("no document by type " + String.valueOf(type) + " and id " + String.valueOf(documentId));
            }
        }
        catch (DocumentNotFoundException e) {
            this._fs.deleteDocument(type, documentId);
            throw new DocumentReadWriteException("Can't add additional document type " + String.valueOf(type) + "! The documentId is unknown to this repository...", (Throwable)e);
        }
    }

    private void writeFile(DocumentId documentId, DocumentType type, DocumentInputStream documentStream) throws DocumentReadWriteException {
        File targetFolder = this._fs.getFolder(documentId, type);
        try {
            this._fs.createFolder(targetFolder);
        }
        catch (DirectoryCreateFailedException e) {
            throw new DocumentReadWriteException("Can't create output folder " + targetFolder.getAbsolutePath(), (Throwable)e);
        }
        File targetFile = this._fs.getFile(documentId, type);
        JustDocUtil.copyStream((InputStream)documentStream, (File)targetFile);
        if (documentStream.getSize() != targetFile.length()) {
            throw new DocumentReadWriteException("Expected a file of length " + documentStream.getSize() + " but only " + targetFile.length() + " were written!");
        }
    }

    private void writeArchiveFile(DocumentId documentId, DocumentType type, DocumentInputStream documentStream) throws DocumentReadWriteException {
        try {
            ZipUtil.unzipFolder((ZipInputStream)new ZipInputStream((InputStream)documentStream), (File)this._fs.getFolder(documentId, type));
        }
        catch (IOException e) {
            throw new DocumentReadWriteException("Can't extract Zip-Input for document " + String.valueOf(documentId), (Throwable)e);
        }
    }

    public DocumentInputStream readDocument(DocumentType type, DocumentId documentId) throws DocumentNotFoundException, DocumentResourceNotFoundException, DocumentReadException {
        return JustDocUtil.createStream((File)this._fs.withFileExists(this._fs.getFile(this.checkDocumentExists(documentId), type)));
    }

    @Nonnull
    private DocumentId checkDocumentExists(DocumentId documentId) throws DocumentNotFoundException {
        if (!this.hasDocument(documentId)) {
            throw new DocumentNotFoundException("No document by id " + String.valueOf(documentId) + " found!");
        }
        return documentId;
    }

    public DocumentInputStream readDocumentResource(DocumentType type, DocumentId documentId, String relativeResourceName) throws DocumentNotFoundException, DocumentResourceNotFoundException, DocumentReadException {
        return JustDocUtil.createStream((File)this._fs.withFileExists(this._fs.getFile(this._fs.getFolder(this.checkDocumentExists(documentId), type), relativeResourceName)));
    }

    public long getDocumentCount() {
        return StreamSupport.stream(this._fs.getAllDocumentIds().spliterator(), false).count();
    }

    public long getDocumentSize(DocumentType type, DocumentId documentId) {
        try {
            return this._fs.withFileExists(this._fs.getFile(documentId, type)).length();
        }
        catch (DocumentResourceNotFoundException e) {
            return 0L;
        }
    }

    public Iterable<DocumentId> getAllDocumentIds() {
        return this._fs.getAllDocumentIds();
    }
}

