/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.business;

import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentInfo;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.exceptions.DocumentNotFoundException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.services.exceptions.DocumentResourceNotFoundException;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import java.net.URL;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface DocumentService {
    @Nonnull
    public DocumentInputStream getDocumentStream(DocumentId var1, DocumentType var2) throws DocumentNotFoundException, DocumentReadException, DocumentResourceNotFoundException;

    @Nonnull
    public DocumentInputStream getDocumentResourceStream(DocumentId var1, DocumentType var2, String var3) throws DocumentNotFoundException, DocumentResourceNotFoundException, DocumentReadException;

    public void createDocument(DocumentId var1) throws DocumentReadWriteException;

    public void createDocumentFromUpload(DocumentId var1, DocumentType var2, DocumentInputStream var3) throws DocumentReadWriteException;

    public void createDocumentFromDownload(DocumentId var1, DocumentType var2, URL var3) throws DocumentReadWriteException;

    public boolean hasDocument(DocumentType var1, DocumentId var2);

    public long getDocumentSize(DocumentType var1, DocumentId var2);

    @Nonnull
    public DocumentInfo getDocumentInfo(DocumentId var1);

    @Nonnull
    public DocumentId deleteDocument(DocumentId var1) throws DocumentNotFoundException, DocumentReadWriteException;

    @Nonnull
    public Iterable<DocumentInfo> getAllDocumentInfos();

    @Nonnegative
    public long getDocumentCount();
}

