/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.trusteddevice;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.trusteddevice.TrustedDeviceTokenService;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.verifier.JwtVerificationConstraintBuilder;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/authorization/trusteddevice/TrustedDeviceTokenService;", "", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "jwtGenerator", "Lde/justsoftware/jwtfilter/generator/JwtGenerator;", "<init>", "(Lde/justsoftware/jwtfilter/verifier/JwtVerifier;Lde/justsoftware/jwtfilter/generator/JwtGenerator;)V", "isTokenValidForUser", "", "trustedDeviceToken", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "issueToken", "lifetime", "Ljava/time/Duration;", "Companion", "just-authorization-server"})
public class TrustedDeviceTokenService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JwtVerifier jwtVerifier;
    @NotNull
    private final JwtGenerator jwtGenerator;
    @NotNull
    private static final Logger LOG;

    public TrustedDeviceTokenService(@NotNull JwtVerifier jwtVerifier, @NotNull JwtGenerator jwtGenerator) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)jwtGenerator, (String)"jwtGenerator");
        this.jwtVerifier = jwtVerifier;
        this.jwtGenerator = jwtGenerator;
    }

    public boolean isTokenValidForUser(@NotNull String trustedDeviceToken, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)trustedDeviceToken, (String)"trustedDeviceToken");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        JwtVerificationConstraintBuilder constraintBuilder = new JwtVerificationConstraintBuilder().withRequireSubject();
        try {
            JwtClaims claims = this.jwtVerifier.verify(constraintBuilder, trustedDeviceToken);
            String string = claims.getSubject();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
            ProfileId tokenOwner = ProfileId.Companion.fromString(string);
            if (Intrinsics.areEqual((Object)profileId, (Object)tokenOwner)) {
                return true;
            }
        }
        catch (JwtKeyLoadingException e) {
            LOG.error("Could not load keys to verify trusted-device tokens. This should never happen...", (Throwable)e);
            return true;
        }
        catch (InvalidJwtException invalidJwtException) {
            return false;
        }
        catch (MalformedClaimException malformedClaimException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return false;
    }

    @Nullable
    public String issueToken(@NotNull ProfileId profileId, @NotNull Duration lifetime) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        try {
            JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder().withSubject(profileId.toString()).withLifetime(lifetime.toMinutes());
            return this.jwtGenerator.generateJWT(claimsBuilder);
        }
        catch (JwtKeyLoadingException e) {
            LOG.error("Failed to create JWT for device cookie:", (Throwable)e);
        }
        catch (JoseException e) {
            LOG.error("Failed to create JWT for device cookie:", (Throwable)e);
        }
        return null;
    }

    static {
        Logger logger = LoggerFactory.getLogger(TrustedDeviceTokenService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

