/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationManager;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import de.justsoftware.authorization.trusteddevice.TrustedDeviceService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/authorization/totp/TOTPAuthenticationManager;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "totpAuthenticationService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "trustedDeviceService", "Lde/justsoftware/authorization/trusteddevice/TrustedDeviceService;", "<init>", "(Lde/justsoftware/authorization/totp/TOTPAuthenticationService;Lde/justsoftware/authorization/trusteddevice/TrustedDeviceService;)V", "getTotpAuthenticationService", "()Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "getTrustedDeviceService", "()Lde/justsoftware/authorization/trusteddevice/TrustedDeviceService;", "authenticate", "Lorg/springframework/security/core/Authentication;", "authentication", "supports", "", "Ljava/lang/Class;", "Companion", "just-authorization-server"})
public class TOTPAuthenticationManager
implements AuthenticationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TOTPAuthenticationService totpAuthenticationService;
    @NotNull
    private final TrustedDeviceService trustedDeviceService;
    private static final Logger LOG = LoggerFactory.getLogger(TOTPAuthenticationManager.class);

    public TOTPAuthenticationManager(@NotNull TOTPAuthenticationService totpAuthenticationService, @NotNull TrustedDeviceService trustedDeviceService) {
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationService, (String)"totpAuthenticationService");
        Intrinsics.checkNotNullParameter((Object)trustedDeviceService, (String)"trustedDeviceService");
        this.totpAuthenticationService = totpAuthenticationService;
        this.trustedDeviceService = trustedDeviceService;
    }

    @NotNull
    public TOTPAuthenticationService getTotpAuthenticationService() {
        return this.totpAuthenticationService;
    }

    @NotNull
    public TrustedDeviceService getTrustedDeviceService() {
        return this.trustedDeviceService;
    }

    @Nullable
    public Authentication authenticate(@NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        Assert.isInstanceOf(TOTPAuthentication.class, (Object)authentication, (String)"Only TOTPAuthentication is supported");
        TOTPAuthentication auth = (TOTPAuthentication)authentication;
        this.getTotpAuthenticationService().checkTOTPCodeAndConfirmDevice(auth);
        TrustedDeviceService trustedDeviceService = this.getTrustedDeviceService();
        String string = auth.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!trustedDeviceService.accountMayLogIn(string)) {
            LOG.debug("Failed to authenticate since user account is locked due to too many failed logins");
            throw new LockedException("Account is locked and has no valid trusted device cookie: " + auth.getName());
        }
        return (Authentication)new TOTPAuthentication(auth.getInitial(), true, auth.getRemember(), null, 8, null);
    }

    public boolean supports(@NotNull Class<?> authentication) {
        Intrinsics.checkNotNullParameter(authentication, (String)"authentication");
        return TOTPAuthentication.class.isAssignableFrom(authentication);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }
}

