/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings.model;

import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ExternalAppId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.model.HexColor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\b\u0018\u0000 D2\u00020\u0001:\u0003DEFB_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0006\u0010/\u001a\u00020\u0005J\b\u00100\u001a\u00020\u0005H\u0002J\b\u00101\u001a\u00020\u0005H\u0002J\b\u00102\u001a\u00020\u000eH\u0002J\b\u00103\u001a\u00020\tH\u0002J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0005H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u00107\u001a\u00020\tH\u00c6\u0003J\t\u00108\u001a\u00020\u000bH\u00c6\u0003J\t\u00109\u001a\u00020\tH\u00c6\u0003J\t\u0010:\u001a\u00020\u000eH\u00c6\u0003J\t\u0010;\u001a\u00020\u0010H\u00c6\u0003J\t\u0010<\u001a\u00020\u0012H\u00c6\u0003J\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u00c6\u0003Ju\u0010>\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u00c6\u0001J\u0013\u0010?\u001a\u00020\u00052\b\u0010@\u001a\u0004\u0018\u00010AH\u00d6\u0003J\t\u0010B\u001a\u00020\u0010H\u00d6\u0001J\t\u0010C\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001fR\u0014\u0010-\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$\u00a8\u0006G"}, d2={"Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "id", "Lde/justsoftware/admin/id/ExternalAppId;", "active", "", "iconId", "Lde/justsoftware/admin/id/DocumentId;", "name", "", "openUrlIn", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$OpenUrlIn;", "url", "homeScreenAppColor", "Lde/justsoftware/admin/model/HexColor;", "position", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "clients", "", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$Client;", "<init>", "(Lde/justsoftware/admin/id/ExternalAppId;ZLde/justsoftware/admin/id/DocumentId;Ljava/lang/String;Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$OpenUrlIn;Ljava/lang/String;Lde/justsoftware/admin/model/HexColor;ILde/justsoftware/admin/id/TenantId;Ljava/util/Set;)V", "getId", "()Lde/justsoftware/admin/id/ExternalAppId;", "getActive", "()Z", "getIconId", "()Lde/justsoftware/admin/id/DocumentId;", "getName", "()Ljava/lang/String;", "getOpenUrlIn", "()Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$OpenUrlIn;", "getUrl", "getHomeScreenAppColor", "()Lde/justsoftware/admin/model/HexColor;", "getPosition", "()I", "getTenantId", "()Lde/justsoftware/admin/id/TenantId;", "getClients", "()Ljava/util/Set;", "iconDefaultUrl", "getIconDefaultUrl", "colorDefault", "getColorDefault", "isMeetApp", "isSupportApp", "isWebsiteApp", "pickColorDefault", "pickIconDefaultUrl", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "", "hashCode", "toString", "Companion", "Client", "OpenUrlIn", "admin-service"})
public final class ExternalAppSettings
implements AppSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExternalAppId id;
    private final boolean active;
    @Nullable
    private final DocumentId iconId;
    @NotNull
    private final String name;
    @NotNull
    private final OpenUrlIn openUrlIn;
    @NotNull
    private final String url;
    @NotNull
    private final HexColor homeScreenAppColor;
    private final int position;
    @NotNull
    private final TenantId tenantId;
    @NotNull
    private final Set<Client> clients;
    @NotNull
    private final String iconDefaultUrl;
    @NotNull
    private final HexColor colorDefault;
    @NotNull
    private static final List<String> urlAllowList;

    public ExternalAppSettings(@NotNull ExternalAppId id, boolean active, @Nullable DocumentId iconId, @NotNull String name, @NotNull OpenUrlIn openUrlIn, @NotNull String url, @NotNull HexColor homeScreenAppColor, int position, @NotNull TenantId tenantId, @NotNull Set<? extends Client> clients) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)openUrlIn, (String)"openUrlIn");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)homeScreenAppColor, (String)"homeScreenAppColor");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(clients, (String)"clients");
        this.id = id;
        this.active = active;
        this.iconId = iconId;
        this.name = name;
        this.openUrlIn = openUrlIn;
        this.url = url;
        this.homeScreenAppColor = homeScreenAppColor;
        this.position = position;
        this.tenantId = tenantId;
        this.clients = clients;
        this.iconDefaultUrl = this.pickIconDefaultUrl();
        this.colorDefault = this.pickColorDefault();
        if (!(!((Collection)this.clients).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public ExternalAppId getId() {
        return this.id;
    }

    public boolean getActive() {
        return this.active;
    }

    @Nullable
    public DocumentId getIconId() {
        return this.iconId;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final OpenUrlIn getOpenUrlIn() {
        return this.openUrlIn;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public HexColor getHomeScreenAppColor() {
        return this.homeScreenAppColor;
    }

    public int getPosition() {
        return this.position;
    }

    @NotNull
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public final Set<Client> getClients() {
        return this.clients;
    }

    @NotNull
    public String getIconDefaultUrl() {
        return this.iconDefaultUrl;
    }

    @NotNull
    public HexColor getColorDefault() {
        return this.colorDefault;
    }

    public final boolean isMeetApp() {
        return StringsKt.startsWith$default((String)this.url, (String)"https://meet.just.social/just-", (boolean)false, (int)2, null);
    }

    private final boolean isSupportApp() {
        return Intrinsics.areEqual((Object)this.getName(), (Object)"Support");
    }

    private final boolean isWebsiteApp() {
        return Intrinsics.areEqual((Object)this.getName(), (Object)"Website");
    }

    private final HexColor pickColorDefault() {
        if (this.isMeetApp()) {
            return Companion.MeetAppDefaults.INSTANCE.getHomeScreenAppColor();
        }
        if (this.isSupportApp()) {
            return Companion.SupportAppDefaults.INSTANCE.getHomeScreenAppColor();
        }
        if (this.isWebsiteApp()) {
            return Companion.WebsiteAppDefaults.INSTANCE.getHomeScreenAppColor();
        }
        return Companion.Defaults.INSTANCE.getHomeScreenAppColor();
    }

    private final String pickIconDefaultUrl() {
        if (this.isMeetApp()) {
            return "/storageserver/images/iconlarge/appSwitcherLogo/meet.svg";
        }
        if (this.isSupportApp()) {
            return "/storageserver/images/iconlarge/customAppSwitcherLogo/support.svg";
        }
        if (this.isWebsiteApp()) {
            return "/storageserver/images/iconlarge/customAppSwitcherLogo/homepage.svg";
        }
        return "/storageserver/images/iconlarge/appSwitcherLogo/external.svg";
    }

    @NotNull
    public final ExternalAppId component1() {
        return this.id;
    }

    public final boolean component2() {
        return this.active;
    }

    @Nullable
    public final DocumentId component3() {
        return this.iconId;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    @NotNull
    public final OpenUrlIn component5() {
        return this.openUrlIn;
    }

    @NotNull
    public final String component6() {
        return this.url;
    }

    @NotNull
    public final HexColor component7() {
        return this.homeScreenAppColor;
    }

    public final int component8() {
        return this.position;
    }

    @NotNull
    public final TenantId component9() {
        return this.tenantId;
    }

    @NotNull
    public final Set<Client> component10() {
        return this.clients;
    }

    @NotNull
    public final ExternalAppSettings copy(@NotNull ExternalAppId id, boolean active, @Nullable DocumentId iconId, @NotNull String name, @NotNull OpenUrlIn openUrlIn, @NotNull String url, @NotNull HexColor homeScreenAppColor, int position, @NotNull TenantId tenantId, @NotNull Set<? extends Client> clients) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)openUrlIn, (String)"openUrlIn");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)homeScreenAppColor, (String)"homeScreenAppColor");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(clients, (String)"clients");
        return new ExternalAppSettings(id, active, iconId, name, openUrlIn, url, homeScreenAppColor, position, tenantId, clients);
    }

    public static /* synthetic */ ExternalAppSettings copy$default(ExternalAppSettings externalAppSettings, ExternalAppId externalAppId, boolean bl, DocumentId documentId, String string, OpenUrlIn openUrlIn, String string2, HexColor hexColor, int n, TenantId tenantId, Set set, int n2, Object object) {
        if ((n2 & 1) != 0) {
            externalAppId = externalAppSettings.id;
        }
        if ((n2 & 2) != 0) {
            bl = externalAppSettings.active;
        }
        if ((n2 & 4) != 0) {
            documentId = externalAppSettings.iconId;
        }
        if ((n2 & 8) != 0) {
            string = externalAppSettings.name;
        }
        if ((n2 & 0x10) != 0) {
            openUrlIn = externalAppSettings.openUrlIn;
        }
        if ((n2 & 0x20) != 0) {
            string2 = externalAppSettings.url;
        }
        if ((n2 & 0x40) != 0) {
            hexColor = externalAppSettings.homeScreenAppColor;
        }
        if ((n2 & 0x80) != 0) {
            n = externalAppSettings.position;
        }
        if ((n2 & 0x100) != 0) {
            tenantId = externalAppSettings.tenantId;
        }
        if ((n2 & 0x200) != 0) {
            set = externalAppSettings.clients;
        }
        return externalAppSettings.copy(externalAppId, bl, documentId, string, openUrlIn, string2, hexColor, n, tenantId, set);
    }

    @NotNull
    public String toString() {
        return "ExternalAppSettings(id=" + this.id + ", active=" + this.active + ", iconId=" + this.iconId + ", name=" + this.name + ", openUrlIn=" + this.openUrlIn + ", url=" + this.url + ", homeScreenAppColor=" + this.homeScreenAppColor + ", position=" + this.position + ", tenantId=" + this.tenantId + ", clients=" + this.clients + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Boolean.hashCode(this.active);
        result = result * 31 + (this.iconId == null ? 0 : this.iconId.hashCode());
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.openUrlIn.hashCode();
        result = result * 31 + this.url.hashCode();
        result = result * 31 + this.homeScreenAppColor.hashCode();
        result = result * 31 + Integer.hashCode(this.position);
        result = result * 31 + this.tenantId.hashCode();
        result = result * 31 + ((Object)this.clients).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExternalAppSettings)) {
            return false;
        }
        ExternalAppSettings externalAppSettings = (ExternalAppSettings)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)externalAppSettings.id)) {
            return false;
        }
        if (this.active != externalAppSettings.active) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.iconId, (Object)externalAppSettings.iconId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)externalAppSettings.name)) {
            return false;
        }
        if (this.openUrlIn != externalAppSettings.openUrlIn) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)externalAppSettings.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.homeScreenAppColor, (Object)externalAppSettings.homeScreenAppColor)) {
            return false;
        }
        if (this.position != externalAppSettings.position) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tenantId, (Object)externalAppSettings.tenantId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clients, (Object)externalAppSettings.clients);
    }

    public static final /* synthetic */ List access$getUrlAllowList$cp() {
        return urlAllowList;
    }

    static {
        Object[] objectArray = new String[]{"app:", "mailto:", "tel:", "http:", "https:", "/", "#", "consense:", "notes:", "msteams:", "microsoft-edge:"};
        urlAllowList = CollectionsKt.listOf((Object[])objectArray);
    }
}

