/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.toro;

import de.justsoftware.admin.connector.toro.ThemeAttributeType;
import de.justsoftware.admin.connector.toro.Themes;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\r2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0010H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/admin/connector/toro/ToroApiConnector;", "", "toroApiUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "authInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;Lorg/springframework/http/client/ClientHttpRequestInterceptor;)V", "authorizedRestClient", "Lorg/springframework/web/client/RestClient;", "getThemes", "Lde/justsoftware/admin/connector/toro/Themes;", "updateDefaultTheme", "typeToValue", "", "Lde/justsoftware/admin/connector/toro/ThemeAttributeType;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nToroApiConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToroApiConnector.kt\nde/justsoftware/admin/connector/toro/ToroApiConnector\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,74:1\n52#2:75\n52#2:76\n*S KotlinDebug\n*F\n+ 1 ToroApiConnector.kt\nde/justsoftware/admin/connector/toro/ToroApiConnector\n*L\n26#1:75\n34#1:76\n*E\n"})
public class ToroApiConnector {
    @NotNull
    private final RestClient authorizedRestClient;

    public ToroApiConnector(@Value(value="${just.toro.api.host.url}") @NotNull String toroApiUrl, @NotNull RestClient.Builder restClientBuilder, @NotNull ClientHttpRequestInterceptor authInterceptor) {
        Intrinsics.checkNotNullParameter((Object)toroApiUrl, (String)"toroApiUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)authInterceptor, (String)"authInterceptor");
        RestClient restClient = restClientBuilder.baseUrl(toroApiUrl).requestInterceptor(authInterceptor).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.authorizedRestClient = restClient;
    }

    @NotNull
    public Themes getThemes() {
        RestClient.ResponseSpec responseSpec = this.authorizedRestClient.get().uri("/v1/theme/ada", new Object[0]).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$requiredBody$iv = responseSpec;
        boolean $i$f$requiredBody = false;
        Object object = $this$requiredBody$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (object == null) {
            throw new NoSuchElementException("Response body is required");
        }
        return (Themes)object;
    }

    @NotNull
    public Themes updateDefaultTheme(@NotNull Map<ThemeAttributeType, String> typeToValue) {
        Intrinsics.checkNotNullParameter(typeToValue, (String)"typeToValue");
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)this.authorizedRestClient.put().uri("/v1/theme/updateGlobal", new Object[0])).body(typeToValue).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$requiredBody$iv = responseSpec;
        boolean $i$f$requiredBody = false;
        Object object = $this$requiredBody$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (object == null) {
            throw new NoSuchElementException("Response body is required");
        }
        return (Themes)object;
    }
}

