/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.exceptions.EmptyTitleOrDescriptionException;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.business.model.WikiMoveTarget;
import de.justsoftware.wikiservice.business.model.WikiPreview;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.DbDeletion;
import de.justsoftware.wikiservice.persistence.model.DbWiki;
import de.justsoftware.wikiservice.persistence.model.DbWikiOverview;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.SortUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BQ\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0017J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00170#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J4\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0%2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016JH\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\u0006\u00105\u001a\u00020/2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010:\u001a\u0004\u0018\u00010\u0019H\u0016J&\u0010;\u001a\b\u0012\u0004\u0012\u00020<0'2\u0006\u00104\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J<\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0%2\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00170%2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J.\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00170'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J,\u0010C\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\b\u0010D\u001a\u0004\u0018\u00010\u00192\b\u0010E\u001a\u0004\u0018\u00010\u00192\u0006\u0010F\u001a\u00020\u001cH\u0017J\u0012\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010\u0019H\u0012J\u0018\u0010J\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010K\u001a\u00020LH\u0017J\u0016\u0010M\u001a\u00020N2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P0%H\u0017J\"\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00170#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lde/justsoftware/wikiservice/business/WikiService;", "", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "translationService", "Lde/justsoftware/wikiservice/translation/TranslationService;", "<init>", "(Lde/justsoftware/wikiservice/persistence/WikiRepository;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/translation/TranslationService;)V", "create", "Lde/justsoftware/wikiservice/business/model/Wiki;", "title", "", "description", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "read", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "readByIds", "", "wikiIds", "", "readAll", "", "streamAllIds", "Ljava/util/stream/Stream;", "Ljava/util/UUID;", "readByRoles", "roles", "Lde/justsoftware/permission/client/model/Role;", "page", "", "limit", "getPreviewPage", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/business/model/WikiPreview;", "profileId", "pageSize", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Direction;", "translationLanguage", "getWikiMoveTargets", "Lde/justsoftware/wikiservice/business/model/WikiMoveTarget;", "query", "readByRolesAndSubscriber", "subscriber", "findWikisByTenant", "readByTenant", "readByTenantAndSubscriber", "update", "newTitle", "newDescription", "updater", "isNotNullButEmpty", "", "str", "delete", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "removeDeletedWikis", "", "deletions", "Lde/justsoftware/wikiservice/persistence/model/DbDeletion;", "getWikisByIds", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n+ 2 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,311:1\n7#2:312\n7#2:328\n7#2:340\n7#2:348\n7#2:352\n7#2:369\n7#2:373\n1628#3,3:313\n1557#3:320\n1628#3,3:321\n1557#3:324\n1628#3,3:325\n1628#3,3:329\n1557#3:332\n1628#3,3:333\n1557#3:336\n1628#3,3:337\n1628#3,3:341\n1557#3:344\n1628#3,3:345\n1628#3,3:349\n1628#3,3:353\n1611#3,9:356\n1863#3:365\n1864#3:367\n1620#3:368\n1628#3,3:370\n1628#3,3:374\n1246#3,4:379\n1246#3,4:385\n126#4:316\n153#4,3:317\n1#5:366\n462#6:377\n412#6:378\n477#6:383\n423#6:384\n*S KotlinDebug\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n*L\n96#1:312\n114#1:328\n187#1:340\n208#1:348\n220#1:352\n300#1:369\n307#1:373\n96#1:313,3\n100#1:320\n100#1:321,3\n110#1:324\n110#1:325,3\n114#1:329,3\n148#1:332\n148#1:333,3\n186#1:336\n186#1:337,3\n187#1:341,3\n204#1:344\n204#1:345,3\n208#1:349,3\n220#1:353,3\n292#1:356,9\n292#1:365\n292#1:367\n292#1:368\n300#1:370,3\n307#1:374,3\n308#1:379,4\n309#1:385,4\n97#1:316\n97#1:317,3\n292#1:366\n308#1:377\n308#1:378\n309#1:383\n309#1:384\n*E\n"})
public class WikiService {
    @NotNull
    private final WikiRepository wikiRepository;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final TranslationService translationService;

    @Autowired
    public WikiService(@NotNull WikiRepository wikiRepository, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionService permissionService, @NotNull SubscriptionService subscriptionService, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull AuthorizationService authorizationService, @NotNull TranslationService translationService) {
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)translationService, (String)"translationService");
        this.wikiRepository = wikiRepository;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionService = permissionService;
        this.subscriptionService = subscriptionService;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.authorizationService = authorizationService;
        this.translationService = translationService;
    }

    @Transactional
    @NotNull
    public Wiki create(@NotNull String title, @NotNull String description, @NotNull ProfileId creator, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (StringsKt.isBlank((CharSequence)title) || StringsKt.isBlank((CharSequence)description)) {
            throw new EmptyTitleOrDescriptionException();
        }
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Object object = this.wikiRepository.saveAndFlush((Object)new DbWiki(uUID, ((Object)StringsKt.trim((CharSequence)title)).toString(), description, tenantId.getId(), creator.getId(), null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"saveAndFlush(...)");
        Object it = object = DbWiki.Companion.toWiki((DbWiki)object);
        boolean bl = false;
        WikiId wikiId = it.getId();
        this.permissionService.addPermissionItemForNewWiki(wikiId, tenantId);
        this.subscriptionService.setSubscription((ItemId)wikiId, creator, true);
        it = object;
        boolean bl2 = false;
        this.transactionUtils.afterCommit(() -> WikiService.create$lambda$2$lambda$1(this, (Wiki)it));
        return object;
    }

    @Transactional
    @NotNull
    public Wiki read(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Object object = this.wikiRepository.getReferenceById((Object)wikiId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return DbWiki.Companion.toWiki((DbWiki)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Wiki> readByIds(@NotNull Set<WikiId> wikiIds) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            Object it;
            Object item$iv$iv;
            Map $this$mapTo$iv$iv;
            void $this$mapToSet$iv;
            Iterable iterable = wikiIds;
            Object object = this.wikiRepository;
            boolean $i$f$mapToSet = false;
            void var4_5 = $this$mapToSet$iv;
            Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                WikiId wikiId = (WikiId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            Map $this$map$iv = object.findByIds((Set)destination$iv$iv);
            boolean $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = item$iv$iv = (Map.Entry)iterator.next();
                object = destination$iv$iv;
                boolean bl = false;
                object.add(TuplesKt.to((Object)new WikiId((UUID)it.getKey()), (Object)DbWiki.Companion.toWiki((DbWiki)it.getValue())));
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readAll() {
        void $this$mapTo$iv$iv;
        List list = this.wikiRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbWiki dbWiki = (DbWiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(DbWiki.Companion.toWiki((DbWiki)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Stream<UUID> streamAllIds() {
        return this.wikiRepository.streamAllIds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readByRoles(@NotNull Set<Role> roles, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void r;
            Role role = (Role)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = it;
        WikiRepository wikiRepository = this.wikiRepository;
        boolean $i$f$mapToSet = false;
        item$iv$iv2 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void grantee;
            GranteeId granteeId = (GranteeId)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(grantee.getGranteeId());
        }
        UUID uUID = tenantId.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Wiki> list = wikiRepository.findAllByPermissionRoles((Set)destination$iv$iv2, uUID, (Pageable)pageRequest).get().map(arg_0 -> WikiService.readByRoles$lambda$10(WikiService::readByRoles$lambda$9, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<WikiPreview> getPreviewPage(@NotNull ProfileId profileId, int page, int pageSize, @NotNull DbWikiOverview.Companion.Sort sortKey, @NotNull DbWikiOverview.Companion.Direction sortDirection, @NotNull TenantId tenantId, @Nullable String translationLanguage) {
        Page page2;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        boolean isTenantManager = (Boolean)MapsKt.getValue((Map)this.authorizationService.mayTenantManageWikis(SetsKt.setOf((Object)tenantId), profileId), (Object)tenantId);
        PageRequest pageRequest = PageRequest.of((int)page, (int)pageSize, (Sort)SortUtilsKt.getSort((DbWikiOverview.Companion.Sort)sortKey, (DbWikiOverview.Companion.Direction)sortDirection));
        if (isTenantManager) {
            long l = profileId.getId();
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            page2 = this.wikiRepository.findWikiPreviewsByProfileAndTenant(l, uUID, (Pageable)pageRequest);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.authorizationService.getUserRoles(profileId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Role role = (Role)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(GranteeId.Companion.toGranteeId((Role)it).getGranteeId());
            }
            Set granteeIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            long l = profileId.getId();
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            page2 = this.wikiRepository.findWikiPreviewsByRolesAndTenantAndProfile(granteeIds, l, uUID, (Pageable)pageRequest);
        }
        Page result = page2;
        List list = result.toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return (Page)new PageImpl(this.translationService.translate(list, translationLanguage, tenantId), result.getPageable(), result.getTotalElements());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WikiMoveTarget> getWikiMoveTargets(@NotNull ProfileId profileId, @NotNull String query, @NotNull TenantId tenantId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        boolean isTenantManager = (Boolean)MapsKt.getValue((Map)this.authorizationService.mayTenantManageWikis(SetsKt.setOf((Object)tenantId), profileId), (Object)tenantId);
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"title")};
        PageRequest pageRequest = PageRequest.of((int)0, (int)30, (Sort)Sort.by((Sort.Order[])orderArray));
        if (isTenantManager) {
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            list = this.wikiRepository.findWikiMoveTargetsByTenant(uUID, query, (Pageable)pageRequest);
        } else {
            void $this$mapToSet$iv;
            GranteeId it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.authorizationService.getUserRoles(profileId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Role role = (Role)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(GranteeId.Companion.toGranteeId((Role)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$mapToSet = false;
            $this$mapTo$iv$iv = $this$mapToSet$iv;
            destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (GranteeId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getGranteeId());
            }
            Set granteeIds = (Set)destination$iv$iv;
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            list = this.wikiRepository.findWikiMoveTargetsByRolesAndTenant(granteeIds, query, uUID, (Pageable)pageRequest);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readByRolesAndSubscriber(@NotNull Set<Role> roles, @NotNull ProfileId subscriber, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void r;
            Role role = (Role)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = it;
        WikiRepository wikiRepository = this.wikiRepository;
        boolean $i$f$mapToSet = false;
        item$iv$iv2 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void grantee;
            GranteeId granteeId = (GranteeId)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(grantee.getGranteeId());
        }
        UUID uUID = tenantId.getId();
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Wiki> list = wikiRepository.findAllByPermissionRolesAndSubscriber((Set)destination$iv$iv2, uUID, l, (Pageable)pageRequest).get().map(arg_0 -> WikiService.readByRolesAndSubscriber$lambda$18(WikiService::readByRolesAndSubscriber$lambda$17, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Wiki> findWikisByTenant(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$mapToSet$iv = this.wikiRepository.findAllByTenantId(tenantId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbWiki dbWiki = (DbWiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbWiki.Companion.toWiki((DbWiki)it));
        }
        return (Set)destination$iv$iv;
    }

    @NotNull
    public List<Wiki> readByTenant(@NotNull TenantId tenantId, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        UUID uUID = tenantId.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List list = this.wikiRepository.findAllByTenantId(uUID, (Pageable)pageRequest).map(arg_0 -> WikiService.readByTenant$lambda$21(WikiService::readByTenant$lambda$20, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public List<Wiki> readByTenantAndSubscriber(@NotNull TenantId tenantId, @NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        UUID uUID = tenantId.getId();
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List list = this.wikiRepository.findAllByTenantIdAndSubscriber(uUID, l, (Pageable)pageRequest).map(arg_0 -> WikiService.readByTenantAndSubscriber$lambda$23(WikiService::readByTenantAndSubscriber$lambda$22, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public Wiki update(@NotNull WikiId wikiId, @Nullable String newTitle, @Nullable String newDescription, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (this.isNotNullButEmpty(newTitle) || this.isNotNullButEmpty(newDescription)) {
            throw new EmptyTitleOrDescriptionException();
        }
        DbWiki it = (DbWiki)this.wikiRepository.getReferenceById((Object)wikiId.getId());
        boolean bl = false;
        if (newTitle != null) {
            it.setTitle(((Object)StringsKt.trim((CharSequence)newTitle)).toString());
        }
        if (newDescription != null) {
            it.setDescription(newDescription);
        }
        it.setModifiedBy(updater.getId());
        Object object = this.wikiRepository.saveAndFlush((Object)it);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"saveAndFlush(...)");
        Wiki wiki = DbWiki.Companion.toWiki((DbWiki)object);
        it = wiki;
        boolean bl2 = false;
        this.transactionUtils.afterCommit(() -> WikiService.update$lambda$26$lambda$25(this, (Wiki)it));
        return wiki;
    }

    private boolean isNotNullButEmpty(String str) {
        return str != null && StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)str)).toString());
    }

    @Transactional
    @NotNull
    public Wiki delete(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Wiki wiki = this.read(wikiId);
        this.articleService.deleteWikiArticles(wikiId, deletionId);
        this.chapterService.deleteWikiChapters(wikiId, deletionId);
        this.permissionService.removePermissionsForDeletedWiki(wikiId);
        this.wikiRepository.deleteById((Object)wikiId.getId(), deletionId.getId());
        this.transactionUtils.afterCommit(() -> WikiService.delete$lambda$27(this, wikiId));
        return wiki;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedWikis(@NotNull Set<DbDeletion> deletions) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletions, (String)"deletions");
        Iterable $this$mapNotNull$iv = deletions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<WikiId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WikiId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbDeletion it = (DbDeletion)element$iv$iv;
            boolean bl2 = false;
            if ((it.getItemType() == IdType.WIKI_WIKI ? new WikiId(it.getItemId()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set wikiIdsToRemovePermissionsFrom = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapToSet$iv = deletions;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (DbDeletion)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            UUID uUID = it.getId();
            if (uUID == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(uUID);
        }
        Set deletionIds = (Set)destination$iv$iv2;
        this.permissionService.removePermissionsForWikis(wikiIdsToRemovePermissionsFrom);
        this.wikiRepository.deleteAllByDeletionIds(deletionIds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Wiki> getWikisByIds(@NotNull Set<WikiId> wikiIds) {
        void $this$mapKeysTo$iv$iv;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        Map.Entry entry2;
        Object $this$mapValuesTo$iv$iv;
        Collection<Object> collection;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable iterable = wikiIds;
        Object object = this.wikiRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            WikiId wikiId = (WikiId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map $this$mapValues$iv = object.findByIds((Set)destination$iv$iv);
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            entry2 = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl3 = false;
            entry = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = object2;
            boolean bl2 = false;
            Wiki wiki = DbWiki.Companion.toWiki((DbWiki)it.getValue());
            object.put(collection, wiki);
        }
        Object $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$mapKeys = false;
        $this$mapValuesTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv2;
            void it;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            entry = new WikiId((UUID)it.getKey());
            Object object3 = object;
            boolean bl4 = false;
            entry2 = it$iv$iv2.getValue();
            object3.put(entry, entry2);
        }
        return destination$iv$iv;
    }

    private static final Unit create$lambda$2$lambda$1(WikiService this$0, Wiki $it) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Wiki readByRoles$lambda$9(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByRoles$lambda$10(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Wiki readByRolesAndSubscriber$lambda$17(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByRolesAndSubscriber$lambda$18(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Wiki readByTenant$lambda$20(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByTenant$lambda$21(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Wiki readByTenantAndSubscriber$lambda$22(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByTenantAndSubscriber$lambda$23(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Unit update$lambda$26$lambda$25(WikiService this$0, Wiki $it) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$27(WikiService this$0, WikiId $wikiId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($wikiId));
        return Unit.INSTANCE;
    }
}

