/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ChapterNestingException;
import de.justsoftware.wikiservice.business.exceptions.ChapterNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.CircularyAncestryException;
import de.justsoftware.wikiservice.business.exceptions.ParentNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.WikiNotFoundException;
import de.justsoftware.wikiservice.business.model.Ancestor;
import de.justsoftware.wikiservice.business.model.Article;
import de.justsoftware.wikiservice.business.model.Chapter;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleUpdatedEvent;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ChapterModifiedEvent;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.DbArticle;
import de.justsoftware.wikiservice.persistence.model.DbChapter;
import de.justsoftware.wikiservice.persistence.model.DbWiki;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0015H\u0016J(\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0016J\u000e\u0010!\u001a\u0004\u0018\u00010\u0015*\u00020\u001fH\u0012J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001f0\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0012J*\u0010$\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00190%*\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0012J \u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0017J&\u0010'\u001a\u00020(2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0017J\"\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020&2\b\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u00101\u001a\u00020,H\u0017J\"\u00102\u001a\u00020.2\u0006\u00103\u001a\u0002042\b\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u00101\u001a\u00020,H\u0017J\u001d\u00105\u001a\u00020(2\u0006\u00100\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u001bH\u0012J\u0010\u0010:\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000bH\u0012J\u001e\u0010>\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u00106\u001a\u00020\u001bH\u0012J\u0010\u0010@\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010A\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00192\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lde/justsoftware/wikiservice/business/AncestorService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "maxChapterDepth", "", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/WikiRepository;ILde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "getAncestorWikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "getAncestorWikiIds", "", "parentIds", "", "getDescendants", "Lde/justsoftware/wikiservice/model/AbstractId;", "wikiId", "getAncestors", "", "Lde/justsoftware/wikiservice/business/model/Ancestor;", "firstAncestor", "getParentId", "loadAncestors", "firstAncestors", "groupByType", "Lkotlin/Pair;", "Lde/justsoftware/wikiservice/model/ChapterId;", "updateEditedStatusForAncestors", "", "updatedAt", "Ljava/time/Instant;", "updatedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "moveChapter", "", "chapterId", "toParent", "updater", "moveArticle", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "checkValidMove", "movedElement", "checkValidMove$wiki_service", "getMaxChildrenChaptersNestingDepth", "childrenId", "checkMaxNestingDepthOfNewChapter", "checkMaxNestingDepth", "parentChaptersNestingDepth", "childrenChaptersNestingDepth", "checkCircularAncestry", "parentAncestors", "getNextPositionForParent", "getPreviousPositionForParent", "getDescendantChapters", "Lde/justsoftware/wikiservice/business/model/Chapter;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAncestorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AncestorService.kt\nde/justsoftware/wikiservice/business/AncestorService\n+ 2 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,433:1\n7#2:434\n7#2:452\n7#2:456\n7#2:466\n7#2:470\n7#2:488\n7#2:510\n7#2:522\n7#2:540\n7#2:544\n7#2:630\n1628#3,3:435\n1187#3,2:438\n1261#3,4:440\n1863#3,2:444\n1202#3,2:446\n1230#3,4:448\n1628#3,3:453\n1628#3,3:457\n1279#3,2:460\n1293#3,4:462\n1628#3,3:467\n1628#3,3:471\n1202#3,2:474\n1230#3,4:476\n774#3:485\n865#3,2:486\n1628#3,3:489\n1246#3,4:494\n1246#3,4:500\n1863#3,2:504\n1557#3:506\n1628#3,3:507\n1628#3,3:511\n1557#3:514\n1628#3,3:515\n1557#3:518\n1628#3,3:519\n1628#3,3:523\n1557#3:526\n1628#3,3:527\n1557#3:530\n1628#3,3:531\n1557#3:534\n1628#3,3:535\n1863#3,2:538\n1628#3,3:541\n1628#3,3:545\n1755#3,3:548\n1611#3,9:557\n1863#3:566\n1864#3:568\n1620#3:569\n1611#3,9:576\n1863#3:585\n1864#3:587\n1620#3:588\n1611#3,9:595\n1863#3:604\n1864#3:606\n1620#3:607\n1611#3,9:614\n1863#3:623\n1864#3:625\n1620#3:626\n774#3:627\n865#3,2:628\n1628#3,3:631\n1557#3:634\n1628#3,3:635\n1863#3,2:638\n1863#3,2:640\n1863#3,2:642\n1#4:480\n1#4:567\n1#4:586\n1#4:605\n1#4:624\n126#5:481\n153#5,3:482\n77#5:551\n97#5,5:552\n77#5:570\n97#5,5:571\n77#5:589\n97#5,5:590\n77#5:608\n97#5,5:609\n477#6:492\n423#6:493\n462#6:498\n412#6:499\n*S KotlinDebug\n*F\n+ 1 AncestorService.kt\nde/justsoftware/wikiservice/business/AncestorService\n*L\n57#1:434\n75#1:452\n77#1:456\n118#1:466\n119#1:470\n130#1:488\n172#1:510\n212#1:522\n247#1:540\n353#1:544\n425#1:630\n57#1:435,3\n57#1:438,2\n57#1:440,4\n62#1:444,2\n68#1:446,2\n68#1:448,4\n75#1:453,3\n77#1:457,3\n87#1:460,2\n87#1:462,4\n118#1:467,3\n119#1:471,3\n120#1:474,2\n120#1:476,4\n123#1:485\n123#1:486,2\n130#1:489,3\n131#1:494,4\n132#1:500,4\n140#1:504,2\n166#1:506\n166#1:507,3\n172#1:511,3\n204#1:514\n204#1:515,3\n209#1:518\n209#1:519,3\n212#1:523,3\n212#1:526\n212#1:527,3\n214#1:530\n214#1:531,3\n217#1:534\n217#1:535,3\n219#1:538,2\n247#1:541,3\n353#1:545,3\n382#1:548,3\n392#1:557,9\n392#1:566\n392#1:568\n392#1:569\n397#1:576,9\n397#1:585\n397#1:587\n397#1:588\n407#1:595,9\n407#1:604\n407#1:606\n407#1:607\n412#1:614,9\n412#1:623\n412#1:625\n412#1:626\n425#1:627\n425#1:628,2\n425#1:631,3\n427#1:634\n427#1:635,3\n177#1:638,2\n231#1:640,2\n254#1:642,2\n392#1:567\n397#1:586\n407#1:605\n412#1:624\n122#1:481\n122#1:482,3\n391#1:551\n391#1:552,5\n396#1:570\n396#1:571,5\n406#1:589\n406#1:590,5\n411#1:608\n411#1:609,5\n131#1:492\n131#1:493\n132#1:498\n132#1:499\n*E\n"})
public class AncestorService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final WikiRepository wikiRepository;
    private final int maxChapterDepth;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public AncestorService(@NotNull PermissionService permissionService, @NotNull ChapterRepository chapterRepository, @NotNull ArticleRepository articleRepository, @NotNull WikiRepository wikiRepository, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.permissionService = permissionService;
        this.chapterRepository = chapterRepository;
        this.articleRepository = articleRepository;
        this.wikiRepository = wikiRepository;
        this.maxChapterDepth = maxChapterDepth;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public WikiId getAncestorWikiId(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        WikiId wikiId = (WikiId)this.getAncestorWikiIds(SetsKt.setOf((Object)parentId)).get(parentId);
        if (wikiId == null) {
            throw new WikiNotFoundException((WikiId)parentId);
        }
        return wikiId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, WikiId> getAncestorWikiIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$associateByTo$iv$iv;
        Object it;
        DbChapter it2;
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Pair pair = this.groupByType(parentIds);
        Set chapterIds = (Set)pair.component1();
        Set wikiIds = (Set)pair.component2();
        Iterable iterable = chapterIds;
        Object object = this.chapterRepository;
        boolean $i$f$mapToSet = false;
        void var8_9 = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            ChapterId chapterId = (ChapterId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it3.getId());
        }
        Iterable $this$associate$iv = ChapterRepository.findByIds$default((ChapterRepository)object, (Set)((Set)destination$iv$iv), null, (int)2, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            it2 = (DbChapter)element$iv$iv;
            boolean bl2 = false;
            it2 = TuplesKt.to((Object)new ChapterId(it2.getId()), (Object)new WikiId(it2.getWikiId()));
            bl.put(it2.getFirst(), it2.getSecond());
        }
        Map chapterAncestor = destination$iv$iv2;
        Iterable $this$forEach$iv = chapterIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChapterId)element$iv;
            boolean bl = false;
            boolean item$iv$iv = chapterAncestor.containsKey(it);
            if (!_Assertions.ENABLED || item$iv$iv) continue;
            boolean bl3 = false;
            throw new ChapterNotFoundException(it);
        }
        Iterable $this$associateBy$iv = wikiIds;
        boolean $i$f$associateBy = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        it = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void wikiId;
            it2 = (WikiId)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            object.put(wikiId, element$iv$iv);
        }
        Map wikiAncestor = destination$iv$iv3;
        return MapsKt.plus((Map)wikiAncestor, (Map)chapterAncestor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<AbstractId> getDescendants(@NotNull WikiId wikiId) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Iterable $this$mapToSet$iv = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DbChapter dbChapter = (DbChapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChapterId(it.getId()));
        }
        Set chapters = (Set)destination$iv$iv;
        Iterable $this$mapToSet$iv2 = this.articleRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId.getId());
        boolean $i$f$mapToSet2 = false;
        destination$iv$iv = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbArticle bl = (DbArticle)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new ArticleId(it.getId()));
        }
        Set articles = (Set)destination$iv$iv2;
        return SetsKt.plus((Set)chapters, (Iterable)articles);
    }

    @NotNull
    public List<Ancestor> getAncestors(@NotNull ParentId firstAncestor) {
        Intrinsics.checkNotNullParameter((Object)firstAncestor, (String)"firstAncestor");
        return this.getAncestors(SetsKt.setOf((Object)firstAncestor)).getOrDefault(firstAncestor, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<Ancestor>> getAncestors(@NotNull Set<? extends ParentId> firstAncestor) {
        Intrinsics.checkNotNullParameter(firstAncestor, (String)"firstAncestor");
        Map loadedAncestors = this.loadAncestors(firstAncestor);
        Iterable $this$associateWith$iv = firstAncestor;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            ParentId ancestorId = it;
            List ancestors = new ArrayList();
            while (ancestorId != null) {
                Ancestor ancestor;
                if ((Ancestor)loadedAncestors.get(ancestorId) == null) {
                    throw new ParentNotFoundException(ancestorId);
                }
                ancestors.add(0, ancestor);
                ancestorId = this.getParentId(ancestor);
            }
            List list = ancestors;
            map.put(t, list);
        }
        return result$iv;
    }

    private ParentId getParentId(Ancestor $this$getParentId) {
        ParentId parentId;
        Ancestor ancestor = $this$getParentId;
        if (ancestor instanceof Chapter) {
            parentId = ((Chapter)$this$getParentId).getParentId();
        } else if (ancestor instanceof Wiki) {
            parentId = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return parentId;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ParentId, Ancestor> loadAncestors(Set<? extends ParentId> firstAncestors) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$mapKeysTo$iv$iv;
        Object $this$mapKeys$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        Map $this$mapToSet$iv;
        Object object;
        Object object2;
        Set wikiIds;
        Object object3;
        if (firstAncestors.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map loadedAncestors = new LinkedHashMap();
        Set parentWikiIds = new LinkedHashSet();
        Set nextParentIds = firstAncestors;
        while (!((Collection)nextParentIds).isEmpty()) {
            Set set;
            object3 = this.groupByType(nextParentIds);
            Set chapterIds = (Set)object3.component1();
            wikiIds = (Set)object3.component2();
            parentWikiIds.addAll(wikiIds);
            if (chapterIds.isEmpty()) {
                set = SetsKt.emptySet();
            } else {
                Iterator $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable $this$map$iv;
                void $this$associateByTo$iv$iv;
                Map $this$associateBy$iv;
                ParentId it;
                void $this$mapTo$iv$iv2;
                Iterable $this$mapToSet$iv2;
                DbChapter it2;
                boolean bl;
                void $this$mapTo$iv$iv22;
                Iterable $this$mapToSet$iv22;
                Iterable iterable = chapterIds;
                object2 = this.chapterRepository;
                boolean $i$f$mapToSet = false;
                void var10_12 = $this$mapToSet$iv22;
                Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv22));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv22) {
                    ChapterId chapterId = (ChapterId)t;
                    object = destination$iv$iv;
                    bl = false;
                    object.add(it2.getId());
                }
                $this$mapToSet$iv22 = ChapterRepository.findByIds$default((ChapterRepository)object2, (Set)((Set)destination$iv$iv), null, (int)2, null);
                $i$f$mapToSet = false;
                $this$mapTo$iv$iv22 = $this$mapToSet$iv2;
                destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
                $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv2) {
                    it2 = (DbChapter)t;
                    object2 = destination$iv$iv;
                    bl = false;
                    object2.add(DbChapter.Companion.toChapter((DbChapter)it));
                }
                $this$mapToSet$iv2 = (Set)destination$iv$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo232 = false;
                for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                    void it3;
                    Chapter bl2 = (Chapter)element$iv$iv2;
                    object2 = destination$iv$iv2;
                    boolean bl22 = false;
                    object2.put(it3.getId(), element$iv$iv2);
                }
                Map it4 = $this$associateBy$iv = destination$iv$iv2;
                boolean $i$a$-also-AncestorService$loadAncestors$532 = false;
                loadedAncestors.putAll(it4);
                boolean $i$f$map = false;
                void $i$a$-also-AncestorService$loadAncestors$532 = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                for (Map.Entry entry : $this$mapTo$iv$iv2.entrySet()) {
                    Object element$iv$iv2;
                    element$iv$iv2 = entry;
                    object2 = destination$iv$iv;
                    boolean bl3 = false;
                    object2.add(((Chapter)it.getValue()).getParentId());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv2 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator $i$f$associateByTo232 = $this$filterTo$iv$iv.iterator();
                while ($i$f$associateByTo232.hasNext()) {
                    Map.Entry entry = $i$f$associateByTo232.next();
                    it = (ParentId)entry;
                    boolean bl3 = false;
                    if (!(!loadedAncestors.containsKey(it))) continue;
                    destination$iv$iv.add(entry);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            nextParentIds = set;
        }
        object3 = parentWikiIds;
        object = this.wikiRepository;
        object2 = loadedAncestors;
        boolean $i$f$mapToSet = false;
        wikiIds = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$mapToSet$iv)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it5;
            WikiId $i$f$filterTo = (WikiId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it5.getId());
        }
        collection = (Set)destination$iv$iv;
        $this$mapToSet$iv = object.findByIds(collection);
        boolean $i$f$mapKeys = false;
        $this$mapTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            WikiId wikiId = new WikiId((UUID)entry.getKey());
            Object object4 = object;
            boolean bl4 = false;
            Object v = it$iv$iv.getValue();
            object4.put(wikiId, v);
        }
        $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object5 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            collection = entry.getKey();
            object = object5;
            boolean bl5 = false;
            DbWiki wiki = (DbWiki)entry2.getValue();
            Wiki wiki2 = DbWiki.Companion.toWiki(wiki);
            object.put(collection, wiki2);
        }
        object2.putAll(destination$iv$iv);
        return loadedAncestors;
    }

    private Pair<Set<ChapterId>, Set<WikiId>> groupByType(Set<? extends ParentId> $this$groupByType) {
        Set chapterIds = new LinkedHashSet();
        Set wikiIds = new LinkedHashSet();
        Iterable $this$forEach$iv = $this$groupByType;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            ParentId it = (ParentId)element$iv;
            boolean bl2 = false;
            ParentId parentId = it;
            if (parentId instanceof WikiId) {
                bl = wikiIds.add(it);
                continue;
            }
            if (parentId instanceof ChapterId) {
                bl = chapterIds.add(it);
                continue;
            }
            throw new IllegalArgumentException("Unsupported parent type: " + it.type());
        }
        return new Pair((Object)chapterIds, (Object)wikiIds);
    }

    @Transactional
    public void updateEditedStatusForAncestors(@NotNull ParentId parentId, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        this.updateEditedStatusForAncestors(SetsKt.setOf((Object)parentId), updatedAt, updatedBy);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateEditedStatusForAncestors(@NotNull Set<? extends ParentId> parentIds, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        Iterable iterable = CollectionsKt.flatten((Iterable)this.getAncestors(parentIds).values());
        AncestorService ancestorService = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Ancestor ancestor = (Ancestor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Pair pair = ancestorService.groupByType(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Set parentChaptersIds = (Set)pair.component1();
        Set parentWikiIds = (Set)pair.component2();
        WikiId parentWikiId = (WikiId)CollectionsKt.first((Iterable)parentWikiIds);
        destination$iv$iv = parentChaptersIds;
        ancestorService = this.chapterRepository;
        boolean $i$f$mapToSet = false;
        Iterator iterator = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChapterId chapterId = (ChapterId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getId());
        }
        ancestorService.setUpdatedStatus((Set)destination$iv$iv2, updatedBy.getId(), updatedAt);
        this.wikiRepository.setUpdatedStatus(parentWikiId.getId(), updatedBy.getId(), updatedAt);
        this.transactionUtils.afterCommit(() -> AncestorService.updateEditedStatusForAncestors$lambda$21(this, parentWikiId, parentChaptersIds));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public boolean moveChapter(@NotNull ChapterId chapterId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Iterable $this$forEach$iv;
        Collection collection;
        Iterable parentIds;
        List updatedChapters;
        Object object;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Object object2 = this.chapterRepository.getReferenceById((Object)chapterId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getReferenceById(...)");
        Chapter chapter = DbChapter.Companion.toChapter((DbChapter)object2);
        ParentId oldParentId = chapter.getParentId();
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)chapter.getParentId().getId()) && toParent.type() == chapter.getParentId().type()) {
            return false;
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)chapter.getId());
        WikiId toWikiId = this.getAncestorWikiId(toParent);
        Set chaptersToUpdate = new LinkedHashSet();
        if (!Intrinsics.areEqual((Object)toWikiId, (Object)chapter.getWikiId())) {
            Object $this$mapTo$iv$iv2;
            void $this$mapToSet$iv2;
            Object item$iv$iv3;
            void $this$mapTo$iv$iv3;
            void $this$mapTo$iv$iv4;
            Iterable $this$map$iv = this.getDescendantChapters(chapter.getWikiId(), (ParentId)chapterId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                void childChapter;
                void var18_38;
                Chapter chapter2 = (Chapter)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl = false;
                void $this$moveChapter_u24lambda_u2423_u24lambda_u2422 = var18_38 = childChapter;
                boolean bl2 = false;
                $this$moveChapter_u24lambda_u2423_u24lambda_u2422.setWikiId(toWikiId);
                object.add(var18_38);
            }
            updatedChapters = (List)destination$iv$iv;
            chaptersToUpdate.addAll(updatedChapters);
            Iterable $this$map$iv2 = updatedChapters;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                void it;
                Chapter bl = (Chapter)item$iv$iv3;
                object = destination$iv$iv2;
                boolean bl3 = false;
                object.add(it.getId());
            }
            Iterable $i$f$map22 = parentIds = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)), (Iterable)SetsKt.setOf((Object)chapterId));
            object = this.articleRepository;
            boolean $i$f$mapToSet = false;
            destination$iv$iv2 = $this$mapToSet$iv2;
            Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
            boolean $i$f$mapTo3 = false;
            item$iv$iv3 = $this$mapTo$iv$iv2.iterator();
            while (item$iv$iv3.hasNext()) {
                void it;
                Object item$iv$iv4 = item$iv$iv3.next();
                ChapterId bl3 = (ChapterId)item$iv$iv4;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(it.getId());
            }
            Iterable $this$map$iv3 = CollectionsKt.flatten((Iterable)object.findByParentIds((Set)destination$iv$iv3).values());
            boolean $i$f$map3 = false;
            $this$mapTo$iv$iv2 = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            $i$f$mapTo3 = false;
            item$iv$iv3 = $this$mapTo$iv$iv2.iterator();
            while (item$iv$iv3.hasNext()) {
                void article;
                void var20_50;
                Object item$iv$iv5 = item$iv$iv3.next();
                DbArticle it = (DbArticle)item$iv$iv5;
                object = destination$iv$iv3;
                boolean bl = false;
                void $this$moveChapter_u24lambda_u2427_u24lambda_u2426 = var20_50 = article;
                boolean bl4 = false;
                $this$moveChapter_u24lambda_u2427_u24lambda_u2426.setWikiId(toWikiId.getId());
                object.add(var20_50);
            }
            $this$map$iv3 = (List)destination$iv$iv3;
            $i$f$map3 = false;
            $this$mapTo$iv$iv2 = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            $i$f$mapTo3 = false;
            item$iv$iv3 = $this$mapTo$iv$iv2.iterator();
            while (item$iv$iv3.hasNext()) {
                void it;
                Object item$iv$iv6 = item$iv$iv3.next();
                DbArticle article = (DbArticle)item$iv$iv6;
                object = destination$iv$iv3;
                boolean bl = false;
                object.add(DbArticle.Companion.toArticle((DbArticle)it));
            }
            List updatedArticles = (List)destination$iv$iv3;
            if (!((Collection)updatedArticles).isEmpty()) {
                $this$map$iv3 = updatedArticles;
                object = this.articleRepository;
                $i$f$map3 = false;
                $this$mapTo$iv$iv2 = $this$map$iv3;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                $i$f$mapTo3 = false;
                item$iv$iv3 = $this$mapTo$iv$iv2.iterator();
                while (item$iv$iv3.hasNext()) {
                    Object item$iv$iv7 = item$iv$iv3.next();
                    Article it = (Article)item$iv$iv7;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    collection.add(DbArticle.Companion.toDbArticle(it));
                }
                object.saveAll((Iterable)((List)destination$iv$iv3));
                $this$forEach$iv = updatedArticles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Article it = (Article)element$iv;
                    boolean bl = false;
                    this.permissionService.removePermissionsForDeletedArticle(it.getId());
                    this.permissionService.addPermissionItemForNewArticle(it.getId(), toWikiId);
                }
                this.transactionUtils.afterCommit(() -> AncestorService.moveChapter$lambda$32(updatedArticles, this));
            }
            chapter.setWikiId(toWikiId);
            chapter.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
        } else {
            chapter.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        chapter.setParentId(toParent);
        chaptersToUpdate.add(chapter);
        parentIds = chaptersToUpdate;
        object = this.chapterRepository;
        boolean $i$f$mapToSet = false;
        $this$forEach$iv = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Chapter bl = (Chapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(DbChapter.Companion.toDbChapter((Chapter)it));
        }
        updatedChapters = object.saveAll((Iterable)((Set)destination$iv$iv));
        Intrinsics.checkNotNull((Object)updatedChapters);
        Instant instant = ((DbChapter)CollectionsKt.last((List)updatedChapters)).getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit(() -> AncestorService.moveChapter$lambda$35(chaptersToUpdate, this));
        return true;
    }

    @Transactional
    public boolean moveArticle(@NotNull ArticleId articleId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Object object = this.articleRepository.getReferenceById((Object)articleId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        Article article = DbArticle.Companion.toArticle((DbArticle)object);
        ParentId oldParentId = article.getParentId();
        if (toParent == null || Intrinsics.areEqual((Object)toParent, (Object)article.getParentId())) {
            return false;
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)article.getId());
        WikiId $this$moveArticle_u24lambda_u2436 = this.getAncestorWikiId(toParent);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$moveArticle_u24lambda_u2436, (Object)article.getWikiId())) {
            article.setWikiId($this$moveArticle_u24lambda_u2436);
            article.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
            this.permissionService.removePermissionsForDeletedArticle(articleId);
            this.permissionService.addPermissionItemForNewArticle(articleId, (WikiId)toParent);
        } else {
            article.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        article.setParentId(toParent);
        DbArticle updatedArticle = (DbArticle)this.articleRepository.save((Object)DbArticle.Companion.toDbArticle(article));
        Instant instant = updatedArticle.getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit(() -> AncestorService.moveArticle$lambda$37(this, articleId));
        return true;
    }

    public void checkValidMove$wiki_service(@NotNull ParentId toParent, @NotNull AbstractId movedElement) {
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)movedElement, (String)"movedElement");
        ParentId parentId = toParent;
        if (parentId instanceof ChapterId) {
            if (!this.chapterRepository.existsById((Object)((ChapterId)toParent).getId())) {
                throw new ChapterNotFoundException((ChapterId)toParent);
            }
            if (movedElement.type() == IdType.WIKI_CHAPTER) {
                List parentAncestors = this.getAncestors(toParent);
                int parentChaptersNestingDepth = parentAncestors.size() - 1;
                int childrenChaptersNestingDepth = this.getMaxChildrenChaptersNestingDepth(movedElement);
                this.checkMaxNestingDepth(parentChaptersNestingDepth, childrenChaptersNestingDepth);
                this.checkCircularAncestry(parentAncestors, movedElement);
            }
        } else if (parentId instanceof WikiId) {
            if (!this.wikiRepository.existsById((Object)((WikiId)toParent).getId())) {
                throw new WikiNotFoundException((WikiId)toParent);
            }
        } else {
            throw new IllegalArgumentException(toParent.type() + " is not a known parent type");
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMaxChildrenChaptersNestingDepth(AbstractId childrenId) {
        int n;
        if (childrenId instanceof ParentId) {
            void var2_2;
            int depth = 0;
            Set nextParentIds = SetsKt.setOf((Object)childrenId.getId());
            while (!((Collection)nextParentIds).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$mapToSet$iv;
                Map children = ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, (Set)nextParentIds, null, (int)2, null);
                Iterable iterable = CollectionsKt.flatten((Iterable)children.values());
                boolean $i$f$mapToSet = false;
                void var7_7 = $this$mapToSet$iv;
                Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DbChapter dbChapter = (DbChapter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getId());
                }
                nextParentIds = (Set)destination$iv$iv;
                ++depth;
            }
            n = var2_2;
        } else {
            n = 0;
        }
        return n;
    }

    public void checkMaxNestingDepthOfNewChapter(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        int parentChaptersNestingDepth = this.getAncestors(parentId).size() - 1;
        this.checkMaxNestingDepth(parentChaptersNestingDepth, 1);
    }

    private void checkMaxNestingDepth(int parentChaptersNestingDepth, int childrenChaptersNestingDepth) {
        if (parentChaptersNestingDepth + childrenChaptersNestingDepth > this.maxChapterDepth) {
            throw new ChapterNestingException("Maximum chapter nesting level " + this.maxChapterDepth + " reached");
        }
    }

    private void checkCircularAncestry(List<? extends Ancestor> parentAncestors, AbstractId movedElement) {
        boolean hasCircularAncestry;
        block4: {
            Iterable $this$any$iv = parentAncestors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Ancestor it = (Ancestor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)movedElement)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = hasCircularAncestry = false;
            }
        }
        if (hasCircularAncestry) {
            throw new CircularyAncestryException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getNextPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId.getId()));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            DbChapter it = (DbChapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMax = n != null ? n : -1;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId.getId()));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DbArticle it = (DbArticle)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMax = n2 != null ? n2 : -1;
        return Math.max(chapterPositionMax, articlePositionMax) + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getPreviousPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId.getId()));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            DbChapter it = (DbChapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMin = n != null ? n : 0;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId.getId()));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DbArticle it = (DbArticle)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMin = n2 != null ? n2 : 0;
        return Math.min(chapterPositionMin, articlePositionMin) - 1;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Chapter> getDescendantChapters(WikiId wikiId, ParentId parentId) {
        Set allChapters = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId.getId());
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)parentId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            Iterable $this$mapTo$iv$iv;
            void $this$mapToSet$iv;
            DbChapter it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allChapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DbChapter)element$iv$iv;
                boolean bl = false;
                if (!nextParentIds.contains(it.getParentId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapToSet = false;
            $this$filterTo$iv$iv = $this$mapToSet$iv;
            destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DbChapter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DbChapter.Companion.toChapter(it));
            }
            Set children = (Set)destination$iv$iv;
            result.addAll(children);
            Iterable $this$map$iv = children;
            boolean $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Chapter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId().getId());
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return result;
    }

    private static final Unit updateEditedStatusForAncestors$lambda$21(AncestorService this$0, WikiId $parentWikiId, Set $parentChaptersIds) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($parentWikiId));
        Iterable $this$forEach$iv = $parentChaptersIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveChapter$lambda$32(List $updatedArticles, AncestorService this$0) {
        Iterable $this$forEach$iv = $updatedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent(it.getId()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveChapter$lambda$35(Set $chaptersToUpdate, AncestorService this$0) {
        Iterable $this$forEach$iv = $chaptersToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Chapter it = (Chapter)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(it.getId()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveArticle$lambda$37(AncestorService this$0, ArticleId $articleId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent($articleId));
        return Unit.INSTANCE;
    }
}

