/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.PermissionApplicationService;
import de.justsoftware.wikiservice.application.model.ContentCountDto;
import de.justsoftware.wikiservice.application.model.CreateOrUpdateWikiDto;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.application.model.TranslatablePageDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.application.model.WikiMoveTargetDto;
import de.justsoftware.wikiservice.application.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.Subscription;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.business.model.WikiMoveTarget;
import de.justsoftware.wikiservice.business.model.WikiPreview;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.DbWikiOverview;
import de.justsoftware.wikiservice.translation.Translatable;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.translation.model.TranslationErrorCode;
import de.justsoftware.wikiservice.translation.model.TranslationMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J@\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0018\u0010/\u001a\u0002002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u00101\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u00103\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lde/justsoftware/wikiservice/application/WikiApplicationService;", "", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "permissionApplicationService", "Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "translationService", "Lde/justsoftware/wikiservice/translation/TranslationService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "<init>", "(Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/application/PermissionApplicationService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/translation/TranslationService;Lde/justsoftware/wikiservice/business/DeletionService;)V", "read", "Lde/justsoftware/wikiservice/application/model/WikiDto;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "translationLanguage", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getWikiList", "Lde/justsoftware/wikiservice/application/model/TranslatablePageDto;", "Lde/justsoftware/wikiservice/application/model/WikiPreviewDto;", "page", "", "pageSize", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Direction;", "getWikiMoveTargetList", "", "Lde/justsoftware/wikiservice/application/model/WikiMoveTargetDto;", "query", "create", "input", "Lde/justsoftware/wikiservice/application/model/CreateOrUpdateWikiDto;", "getContentCount", "Lde/justsoftware/wikiservice/application/model/ContentCountDto;", "update", "updateWikiDto", "delete", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiApplicationService.kt\nde/justsoftware/wikiservice/application/WikiApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n295#2,2:163\n1557#2:165\n1628#2,3:166\n*S KotlinDebug\n*F\n+ 1 WikiApplicationService.kt\nde/justsoftware/wikiservice/application/WikiApplicationService\n*L\n81#1:163,2\n103#1:165\n103#1:166,3\n*E\n"})
public class WikiApplicationService {
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final TranslationService translationService;
    @NotNull
    private final DeletionService deletionService;

    public WikiApplicationService(@NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull ProfileService profileService, @NotNull PermissionApplicationService permissionApplicationService, @NotNull SubscriptionService subscriptionService, @NotNull AuthorizationService authorizationService, @NotNull TranslationService translationService, @NotNull DeletionService deletionService) {
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)translationService, (String)"translationService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.profileService = profileService;
        this.permissionApplicationService = permissionApplicationService;
        this.subscriptionService = subscriptionService;
        this.authorizationService = authorizationService;
        this.translationService = translationService;
        this.deletionService = deletionService;
    }

    @NotNull
    public WikiDto read(@NotNull WikiId wikiId, @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        Wiki wiki = this.wikiService.read(wikiId);
        ProfileDto editor = ProfileDto.Companion.toDto(this.profileService.getById(wiki.getModifiedBy()));
        Subscription subscription = this.subscriptionService.readWiki(wikiId, authContext.getUser());
        boolean isManager = this.authorizationService.mayManageWiki(wikiId, authContext.getUser());
        boolean isWriter = isManager || this.authorizationService.mayWriteWiki(wikiId, authContext.getUser());
        WikiDto.Companion companion = WikiDto.Companion;
        Wiki wiki2 = (Wiki)this.translationService.translate((Translatable)wiki, translationLanguage, authContext.getTenantId());
        boolean bl = subscription.isSubscribed();
        return companion.toDto(wiki2, editor, isManager, isWriter, bl);
    }

    @NotNull
    public TranslatablePageDto<WikiPreviewDto> getWikiList(int page, int pageSize, @NotNull DbWikiOverview.Companion.Sort sortKey, @NotNull DbWikiOverview.Companion.Direction sortDirection, @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        TranslationMetaData translationMetaData;
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page result = this.wikiService.getPreviewPage(authContext.getUser(), page, pageSize, sortKey, sortDirection, authContext.getTenantId(), translationLanguage);
        if (result.isEmpty()) {
            return TranslatablePageDto.Companion.empty();
        }
        if (translationLanguage != null) {
            WikiPreview wikiPreview;
            Object v1;
            block4: {
                Iterable $this$firstOrNull$iv = (Iterable)result;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WikiPreview it = (WikiPreview)element$iv;
                    boolean bl = false;
                    TranslationMetaData translationMetaData2 = it.getTranslationMetaData();
                    if (!((translationMetaData2 != null ? translationMetaData2.getErrorCode() : null) != null)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            TranslationErrorCode errorCode = (wikiPreview = (WikiPreview)v1) != null && (wikiPreview = wikiPreview.getTranslationMetaData()) != null ? wikiPreview.getErrorCode() : null;
            translationMetaData = new TranslationMetaData(translationLanguage, null, (Object)TranslatablePageDto.Companion.toTranslatablePageDto(result, null, WikiApplicationService::getWikiList$lambda$1), errorCode);
        } else {
            translationMetaData = null;
        }
        TranslationMetaData translationMetaData3 = translationMetaData;
        return TranslatablePageDto.Companion.toTranslatablePageDto(result, translationMetaData3, WikiApplicationService::getWikiList$lambda$2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WikiMoveTargetDto> getWikiMoveTargetList(@NotNull String query, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Iterable $this$map$iv = this.wikiService.getWikiMoveTargets(authContext.getUser(), query, authContext.getTenantId());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WikiMoveTarget wikiMoveTarget = (WikiMoveTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WikiMoveTargetDto.Companion.toDto((WikiMoveTarget)it));
        }
        return (List)destination$iv$iv;
    }

    @Transactional
    @NotNull
    public WikiDto create(@NotNull CreateOrUpdateWikiDto input, @NotNull AuthContext authContext) {
        WikiDto wikiDto;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        ProfileDto profile = ProfileDto.Companion.toDto(this.profileService.getById(authContext.getUser()));
        WikiDto it = wikiDto = WikiDto.Companion.toDto(this.wikiService.create(input.getTitle(), input.getDescription(), authContext.getUser(), authContext.getTenantId()), profile, true, true, true);
        boolean bl = false;
        this.permissionApplicationService.setPermissionsForWikiCreation(it.getId(), authContext.getUser().toGranteeId(), authContext);
        return wikiDto;
    }

    @NotNull
    public ContentCountDto getContentCount(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        Integer n = (Integer)this.chapterService.countByWikiIds(SetsKt.setOf((Object)wikiId)).get(wikiId);
        int chapterCount = n != null ? n : 0;
        Integer n2 = (Integer)this.articleService.countByWikiIds(SetsKt.setOf((Object)wikiId)).get(wikiId);
        int articleCount = n2 != null ? n2 : 0;
        return new ContentCountDto((long)chapterCount, (long)articleCount);
    }

    @NotNull
    public WikiDto update(@NotNull WikiId wikiId, @NotNull CreateOrUpdateWikiDto updateWikiDto, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)updateWikiDto, (String)"updateWikiDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteWiki(wikiId);
        Wiki updatedWiki = this.wikiService.update(wikiId, updateWikiDto.getTitle(), updateWikiDto.getDescription(), authContext.getUser());
        WikiDto.Companion companion = WikiDto.Companion;
        ProfileDto profileDto = ProfileDto.Companion.toDto(this.profileService.getById(updatedWiki.getModifiedBy()));
        boolean bl = this.subscriptionService.readWiki(wikiId, authContext.getUser()).isSubscribed();
        boolean bl2 = this.authorizationService.mayManageWiki(wikiId, authContext.getUser());
        return companion.toDto(updatedWiki, profileDto, bl2, true, bl);
    }

    @Transactional
    @NotNull
    public WikiDto delete(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageWiki(wikiId);
        WikiDto wiki = this.read(wikiId, null, authContext);
        DeletionId deletionId = DeletionService.create$default((DeletionService)this.deletionService, (ItemId)((ItemId)wikiId), (ProfileId)authContext.getUser(), null, (int)4, null);
        this.wikiService.delete(wikiId, deletionId);
        return wiki;
    }

    private static final WikiPreviewDto getWikiList$lambda$1(WikiPreview it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TranslationMetaData translationMetaData = it.getTranslationMetaData();
        if (translationMetaData == null || (translationMetaData = (WikiPreview)translationMetaData.getSourceData()) == null || (translationMetaData = WikiPreviewDto.Companion.toDto((WikiPreview)translationMetaData)) == null) {
            translationMetaData = WikiPreviewDto.Companion.toDto(it);
        }
        return translationMetaData;
    }

    private static final WikiPreviewDto getWikiList$lambda$2(WikiPreview it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return WikiPreviewDto.Companion.toDto(it);
    }
}

