/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.application.model.AncestorDto;
import de.justsoftware.wikiservice.application.model.ArticlePreviewDto;
import de.justsoftware.wikiservice.application.model.ChapterPreviewDto;
import de.justsoftware.wikiservice.application.model.PreviewDto;
import de.justsoftware.wikiservice.application.model.SubscriptionDto;
import de.justsoftware.wikiservice.application.model.TranslatablePageDto;
import de.justsoftware.wikiservice.application.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.Ancestor;
import de.justsoftware.wikiservice.business.model.Article;
import de.justsoftware.wikiservice.business.model.ArticleVersion;
import de.justsoftware.wikiservice.business.model.Chapter;
import de.justsoftware.wikiservice.business.model.Subscription;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.translation.Translatable;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.translation.model.TranslationErrorCode;
import de.justsoftware.wikiservice.translation.model.TranslationMetaData;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 =2\u00020\u0001:\u0001=BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J*\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J6\u0010#\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030%0$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010+\u001a\u0012\u0012\u0004\u0012\u00020 \u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\u00132\f\u0010,\u001a\b\u0012\u0004\u0012\u00020 0-2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u001e\u0010.\u001a\u00020/2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020 0-2\u0006\u0010\u0018\u001a\u00020\u0019H\u0012Jd\u00100\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H20\u0013\"\u0004\b\u0000\u00101\"\u000e\b\u0001\u00102*\b\u0012\u0004\u0012\u0002H2032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H20\u00132\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u00105\u001a\u0002062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H108H\u0012JF\u00109\u001a\u0014\u0012\u0004\u0012\u00020:\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0\u00170\u00132\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020:\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0\u00170\u00132\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u00105\u001a\u000206H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "translationService", "Lde/justsoftware/wikiservice/translation/TranslationService;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "<init>", "(Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/translation/TranslationService;Lde/justsoftware/wikiservice/authorization/AuthorizationService;)V", "read", "", "Lde/justsoftware/wikiservice/model/WikiId;", "Lde/justsoftware/wikiservice/application/model/SubscriptionDto;", "wikiIds", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "setSubscription", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "isSubscribed", "", "getSubscribedItems", "Lde/justsoftware/wikiservice/application/model/TranslatablePageDto;", "Lde/justsoftware/wikiservice/application/model/PreviewDto;", "page", "", "pageSize", "translationLanguage", "", "findPreviewByItemsIds", "itemIds", "", "getReadableItems", "Lde/justsoftware/wikiservice/application/SubscriptionApplicationService$Companion$ReadableItems;", "translate", "K", "V", "Lde/justsoftware/wikiservice/translation/Translatable;", "wikis", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "keyMapper", "Lkotlin/Function1;", "translateAncestors", "Lde/justsoftware/wikiservice/model/ParentId;", "Lde/justsoftware/wikiservice/business/model/Ancestor;", "ancestors", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSubscriptionApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionApplicationService.kt\nde/justsoftware/wikiservice/application/SubscriptionApplicationService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,269:1\n462#2:270\n412#2:271\n487#2,7:396\n503#2,7:403\n503#2,7:410\n1246#3,4:272\n1611#3,9:276\n1863#3:285\n1864#3:287\n1620#3:288\n1368#3:289\n1454#3,2:290\n1557#3:292\n1628#3,3:293\n1456#3,3:296\n295#3,2:299\n1611#3,9:311\n1863#3:320\n1864#3:322\n1620#3:323\n1187#3,2:325\n1261#3,4:327\n1611#3,9:333\n1863#3:342\n1557#3:343\n1628#3,3:344\n1864#3:348\n1620#3:349\n1187#3,2:351\n1261#3,4:353\n1611#3,9:359\n1863#3:368\n1557#3:369\n1628#3,3:370\n1864#3:374\n1620#3:375\n1187#3,2:377\n1261#3,4:379\n817#3,2:384\n817#3,2:387\n817#3,2:390\n1202#3,2:417\n1230#3,4:419\n808#3,11:423\n1202#3,2:434\n1230#3,4:436\n808#3,11:440\n1202#3,2:451\n1230#3,4:453\n1611#3,9:459\n1863#3:468\n1557#3:469\n1628#3,3:470\n1864#3:474\n1620#3:475\n1187#3,2:477\n1261#3,4:479\n1#4:286\n1#4:321\n1#4:347\n1#4:373\n1#4:473\n16#5:301\n16#5:305\n80#5,2:309\n82#5:324\n80#5,2:331\n82#5:350\n80#5,2:357\n82#5:376\n22#5:383\n22#5:386\n22#5:389\n16#5:392\n80#5,2:457\n82#5:476\n153#6,3:302\n153#6,3:306\n153#6,3:393\n8#7:483\n7#7,3:484\n*S KotlinDebug\n*F\n+ 1 SubscriptionApplicationService.kt\nde/justsoftware/wikiservice/application/SubscriptionApplicationService\n*L\n60#1:270\n60#1:271\n204#1:396,7\n207#1:403,7\n211#1:410,7\n60#1:272,4\n113#1:276,9\n113#1:285\n113#1:287\n113#1:288\n119#1:289\n119#1:290,2\n120#1:292\n120#1:293,3\n119#1:296,3\n124#1:299,2\n168#1:311,9\n168#1:320\n168#1:322\n168#1:323\n168#1:325,2\n168#1:327,4\n169#1:333,9\n169#1:342\n172#1:343\n172#1:344,3\n169#1:348\n169#1:349\n169#1:351,2\n169#1:353,4\n178#1:359,9\n178#1:368\n182#1:369\n182#1:370,3\n178#1:374\n178#1:375\n178#1:377,2\n178#1:379,4\n195#1:384,2\n196#1:387,2\n197#1:390,2\n232#1:417,2\n232#1:419,4\n241#1:423,11\n244#1:434,2\n244#1:436,4\n247#1:440,11\n250#1:451,2\n250#1:453,4\n251#1:459,9\n251#1:468\n252#1:469\n252#1:470,3\n251#1:474\n251#1:475\n251#1:477,2\n251#1:479,4\n113#1:286\n168#1:321\n169#1:347\n178#1:373\n251#1:473\n160#1:301\n161#1:305\n168#1:309,2\n168#1:324\n169#1:331,2\n169#1:350\n178#1:357,2\n178#1:376\n195#1:383\n196#1:386\n197#1:389\n202#1:392\n251#1:457,2\n251#1:476\n160#1:302,3\n161#1:306,3\n202#1:393,3\n259#1:483\n259#1:484,3\n*E\n"})
public class SubscriptionApplicationService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final TranslationService translationService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private static final Logger LOG;

    @Autowired
    public SubscriptionApplicationService(@NotNull SubscriptionService subscriptionService, @NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull TranslationService translationService, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)translationService, (String)"translationService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.subscriptionService = subscriptionService;
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.translationService = translationService;
        this.authorizationService = authorizationService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, SubscriptionDto> read(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set userRoles = this.authorizationService.getUserRoles(authContext.getUser());
        Map map = this.subscriptionService.readWikis(CollectionsKt.toSet((Iterable)wikiIds), authContext.getUser(), userRoles);
        boolean $i$f$mapValues = false;
        void var6_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            SubscriptionDto subscriptionDto = SubscriptionDto.Companion.toDto((Subscription)entry.getValue());
            map3.put(k, subscriptionDto);
        }
        return destination$iv$iv;
    }

    @NotNull
    public SubscriptionDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.chapterService.read(chapterId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return SubscriptionDto.Companion.toDto(this.subscriptionService.readChapter(chapterId, authContext.getUser()));
    }

    @NotNull
    public SubscriptionDto read(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.articleService.read(articleId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return SubscriptionDto.Companion.toDto(this.subscriptionService.readArticle(articleId, authContext.getUser()));
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, boolean isSubscribed, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        switch (WhenMappings.$EnumSwitchMapping$0[itemId.type().ordinal()]) {
            case 1: {
                authContext.checkReadWiki((WikiId)itemId);
                break;
            }
            case 2: {
                WikiId wikiId = this.chapterService.read((ChapterId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            case 3: {
                WikiId wikiId = this.articleService.read((ArticleId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            default: {
                throw new RuntimeException("Cannot subscribe to " + itemId);
            }
        }
        return SubscriptionDto.Companion.toDto(this.subscriptionService.setSubscription(itemId, authContext.getUser(), isSubscribed));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TranslatablePageDto<? extends PreviewDto<?>> getSubscribedItems(int page, int pageSize, @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        TranslationMetaData translationMetaData;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page subscribedItemIds = this.subscriptionService.getSubscribedItemIds(page, pageSize, authContext.getUser());
        Set set = subscribedItemIds.toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        Map previews = this.findPreviewByItemsIds((Collection)set, translationLanguage, authContext);
        Iterable $this$mapNotNull$iv = (Iterable)subscribedItemIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            PreviewDto it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            ItemId it = (ItemId)element$iv$iv;
            boolean bl2 = false;
            if ((PreviewDto)previews.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        long l = subscribedItemIds.getTotalElements();
        Pageable pageable = (Pageable)PageRequest.of((int)page, (int)pageSize);
        List list = (List)destination$iv$iv;
        PageImpl subscribedPreviews = new PageImpl(list, pageable, l);
        if (translationLanguage != null) {
            Object v3;
            block6: {
                void $this$firstOrNull$iv;
                void $this$flatMapTo$iv$iv;
                List list2 = subscribedPreviews.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContent(...)");
                Iterable $this$flatMap$iv = list2;
                boolean $i$f$flatMap = false;
                $this$forEach$iv$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    PreviewDto preview = (PreviewDto)element$iv$iv;
                    boolean bl = false;
                    Iterable bl2 = preview.getAncestors();
                    Collection collection = CollectionsKt.listOf((Object)preview.getTranslationMetaData());
                    boolean $i$f$map = false;
                    void var23_34 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AncestorDto ancestorDto = (AncestorDto)item$iv$iv;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl4 = false;
                        collection2.add(it.getTranslationMetaData());
                    }
                    Iterable list$iv$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv3));
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TranslationMetaData it = (TranslationMetaData)element$iv;
                    boolean bl = false;
                    TranslationMetaData translationMetaData2 = it;
                    if (!((translationMetaData2 != null ? translationMetaData2.getErrorCode() : null) != null)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            iterable = v3;
            TranslationErrorCode errorCode = iterable != null ? iterable.getErrorCode() : null;
            translationMetaData = new TranslationMetaData(translationLanguage, null, (Object)TranslatablePageDto.Companion.toTranslatablePageDto((Page)subscribedPreviews, null, SubscriptionApplicationService::getSubscribedItems$lambda$5), errorCode);
        } else {
            translationMetaData = null;
        }
        TranslationMetaData translationMetaData3 = translationMetaData;
        return TranslatablePageDto.Companion.toTranslatablePageDto((Page)subscribedPreviews, translationMetaData3);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ItemId, PreviewDto<?>> findPreviewByItemsIds(Collection<? extends ItemId> itemIds, String translationLanguage, AuthContext authContext) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        void $this$associateTo$iv$iv$iv2;
        void $this$associate$iv$iv2;
        ChapterPreviewDto it$iv;
        ChapterPreviewDto.Companion companion;
        Object element$iv$iv$iv$iv3;
        void $this$mapNotNullTo$iv$iv$iv2;
        Iterable $this$mapNotNull$iv$iv2;
        void $this$associateTo$iv$iv$iv3;
        void $this$associate$iv$iv3;
        void $this$mapNotNullTo$iv$iv$iv3;
        Iterable $this$mapNotNull$iv$iv3;
        Collection<ParentId> collection;
        Map.Entry it;
        Collection<ParentId> collection2;
        Map.Entry item$iv$iv;
        Map $this$mapTo$iv$iv;
        Map $this$mapToSet$iv;
        Companion.ReadableItems readableItems = this.getReadableItems(itemIds, authContext);
        Map readableWikis = this.translate(readableItems.getWikis(), translationLanguage, authContext.getTenantId(), SubscriptionApplicationService::findPreviewByItemsIds$lambda$6);
        Map readableChapters = this.translate(readableItems.getChapters(), translationLanguage, authContext.getTenantId(), SubscriptionApplicationService::findPreviewByItemsIds$lambda$7);
        Map readableArticles = readableItems.getArticles();
        Map readableArticleVersions = this.translate(readableItems.getArticleVersions(), translationLanguage, authContext.getTenantId(), SubscriptionApplicationService::findPreviewByItemsIds$lambda$8);
        Map map = readableArticles;
        AncestorService ancestorService = this.ancestorService;
        SubscriptionApplicationService subscriptionApplicationService = this;
        boolean $i$f$mapToSet = false;
        void var12_14 = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet($this$mapToSet$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = item$iv$iv = iterator.next();
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((Article)it.getValue()).getParentId());
        }
        collection2 = (Set)destination$iv$iv;
        $this$mapToSet$iv = readableChapters;
        $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet($this$mapToSet$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Chapter)it.getValue()).getParentId());
        }
        collection = (Set)destination$iv$iv;
        Map ancestors = subscriptionApplicationService.translateAncestors(ancestorService.getAncestors(SetsKt.plus(collection2, (Iterable)collection)), translationLanguage, authContext.getTenantId());
        Map $this$mapValuesNotNull$iv = readableWikis;
        boolean $i$f$mapValuesNotNull = false;
        destination$iv$iv = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        iterator = $this$mapNotNull$iv$iv3;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv$iv2 : $this$forEach$iv$iv$iv$iv) {
            Pair pair;
            Object element$iv$iv$iv = element$iv$iv$iv$iv2;
            boolean bl = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = entry$iv;
            boolean bl3 = false;
            Wiki v = (Wiki)entry.getValue();
            if (WikiPreviewDto.Companion.toPreviewDto(v, true) != null) {
                WikiPreviewDto it$iv2;
                boolean bl4 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv2);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv3 = (List)destination$iv$iv$iv;
        boolean $i$f$associate22 = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv3, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv3;
        Object destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv3) {
            Object element$iv$iv$iv$iv2;
            element$iv$iv$iv$iv2 = destination$iv$iv$iv2;
            Pair it$iv3 = (Pair)element$iv$iv$iv;
            boolean bl = false;
            element$iv$iv$iv$iv2.put((Object)it$iv3.getFirst(), (Object)it$iv3.getSecond());
        }
        Map readableWikiPreviews = destination$iv$iv$iv2;
        Map $this$mapValuesNotNull$iv2 = readableChapters;
        boolean $i$f$mapValuesNotNull2 = false;
        Iterable $i$f$associate22 = $this$mapValuesNotNull$iv2.entrySet();
        boolean $i$f$mapNotNull2 = false;
        $this$associateTo$iv$iv$iv3 = $this$mapNotNull$iv$iv2;
        destination$iv$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv$iv2 = $this$mapNotNullTo$iv$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv$iv$iv3 : $this$forEach$iv$iv$iv$iv2) {
            Pair pair;
            List list;
            boolean bl;
            Chapter chapter;
            ChapterPreviewDto.Companion companion2;
            Object element$iv$iv$iv = element$iv$iv$iv$iv3;
            boolean bl6 = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl7 = false;
            Map.Entry bl3 = entry$iv;
            boolean bl8 = false;
            Chapter v = (Chapter)bl3.getValue();
            List list2 = (List)ancestors.get(v.getParentId());
            if (list2 != null) {
                void $this$mapTo$iv$iv2;
                Iterable bl4 = list2;
                it$iv$iv$iv = true;
                var32_83 = v;
                companion = ChapterPreviewDto.Companion;
                boolean $i$f$map = false;
                List list3 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void ancestor;
                    Ancestor ancestor2 = (Ancestor)item$iv$iv2;
                    var41_98 = destination$iv$iv2;
                    boolean bl9 = false;
                    var41_98.add(AncestorDto.Companion.toDto((Ancestor)ancestor));
                }
                var41_98 = (List)destination$iv$iv2;
                companion2 = companion;
                chapter = var32_83;
                bl = it$iv$iv$iv;
                list = var41_98;
            } else {
                List $i$f$map = $this$map$iv = CollectionsKt.emptyList();
                it$iv$iv$iv = true;
                boolean bl10 = false;
                LOG.error("No ancestor found for Chapter " + v.getId() + ". Return empty ancestor list as fallback.");
                var41_98 = Unit.INSTANCE;
                companion2 = companion;
                chapter = var32_83;
                bl = it$iv$iv$iv;
                list = $this$map$iv;
            }
            if (companion2.toPreviewDto(chapter, bl, list) != null) {
                boolean bl11 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl12 = false;
            destination$iv$iv$iv2.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv2 = (List)destination$iv$iv$iv2;
        boolean $i$f$associate32 = false;
        int capacity$iv$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv2, (int)10)), (int)16);
        destination$iv$iv$iv2 = $this$associate$iv$iv2;
        Object destination$iv$iv$iv3 = new LinkedHashMap(capacity$iv$iv2);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv2) {
            element$iv$iv$iv$iv3 = destination$iv$iv$iv3;
            Pair it$iv4 = (Pair)element$iv$iv$iv;
            boolean bl = false;
            element$iv$iv$iv$iv3.put((Object)it$iv4.getFirst(), (Object)it$iv4.getSecond());
        }
        Map readableChapterPreviews = destination$iv$iv$iv3;
        Map $this$mapValuesNotNull$iv3 = readableArticleVersions;
        boolean $i$f$mapValuesNotNull3 = false;
        Iterable $i$f$associate32 = $this$mapValuesNotNull$iv3.entrySet();
        boolean $i$f$mapNotNull3 = false;
        $this$associateTo$iv$iv$iv2 = $this$mapNotNull$iv$iv;
        destination$iv$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv$iv3 = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach3 = false;
        element$iv$iv$iv$iv3 = $this$forEach$iv$iv$iv$iv3.iterator();
        while (element$iv$iv$iv$iv3.hasNext()) {
            Pair pair;
            Object object;
            boolean bl;
            ArticleVersion articleVersion;
            ArticlePreviewDto.Companion companion3;
            Map.Entry entry$iv;
            block24: {
                List list;
                Unit unit;
                List article;
                ArticlePreviewDto.Companion companion4;
                boolean bl13;
                ArticleVersion v;
                block23: {
                    Object object2;
                    Object element$iv$iv$iv$iv4;
                    Object element$iv$iv$iv = element$iv$iv$iv$iv4 = element$iv$iv$iv$iv3.next();
                    boolean bl14 = false;
                    entry$iv = (Map.Entry)element$iv$iv$iv;
                    boolean bl15 = false;
                    Map.Entry entry = entry$iv;
                    boolean bl16 = false;
                    v = (ArticleVersion)entry.getValue();
                    companion3 = ArticlePreviewDto.Companion;
                    articleVersion = v;
                    bl = true;
                    object = (Article)readableArticles.get(v.getArticleId());
                    if (object == null) break block23;
                    Article it$iv$iv$iv = object;
                    bl13 = bl;
                    companion = articleVersion;
                    companion4 = companion3;
                    boolean bl17 = false;
                    List list4 = (List)ancestors.get(article.getParentId());
                    if (list4 != null) {
                        void $this$mapTo$iv$iv3;
                        Iterable $this$map$iv = list4;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo3 = false;
                        for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                            void ancestor;
                            it$iv = (Ancestor)item$iv$iv3;
                            Collection collection3 = destination$iv$iv3;
                            boolean bl18 = false;
                            collection3.add(AncestorDto.Companion.toDto((Ancestor)ancestor));
                        }
                        object2 = (List)destination$iv$iv3;
                    } else {
                        object2 = null;
                    }
                    unit = object2;
                    companion3 = companion4;
                    articleVersion = companion;
                    bl = bl13;
                    Unit unit2 = unit;
                    object = unit2;
                    if (unit2 != null) break block24;
                }
                article = list = CollectionsKt.emptyList();
                bl13 = bl;
                companion = articleVersion;
                companion4 = companion3;
                boolean bl19 = false;
                LOG.error("No ancestor found for Article " + v.getArticleId() + ". Return empty ancestor list as fallback.");
                unit = Unit.INSTANCE;
                companion3 = companion4;
                articleVersion = companion;
                bl = bl13;
                object = list;
            }
            if (companion3.toPreviewDto(articleVersion, bl, (List)object) != null) {
                ArticlePreviewDto it$iv5;
                boolean bl20 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv5);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl21 = false;
            destination$iv$iv$iv3.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv3;
        boolean $i$f$associate = false;
        int capacity$iv$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv3 = $this$associate$iv$iv;
        Map destination$iv$iv$iv4 = new LinkedHashMap(capacity$iv$iv3);
        boolean $i$f$associateTo3 = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map2 = destination$iv$iv$iv4;
            Pair it$iv6 = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv6;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map readableArticlePreviews = destination$iv$iv$iv4;
        return MapsKt.plus((Map)MapsKt.plus((Map)readableWikiPreviews, (Map)readableChapterPreviews), (Map)readableArticlePreviews);
    }

    /*
     * WARNING - void declaration
     */
    private Companion.ReadableItems getReadableItems(Collection<? extends ItemId> itemIds, AuthContext authContext) {
        Collection<WikiId> collection;
        Chapter v;
        Collection collection2;
        Map $this$mapTo$iv$iv;
        Map $this$mapToSet$iv;
        Object element$iv$iv42;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        Iterable $this$filterIsInstanceToSet$iv = itemIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable iterable = $this$filterIsInstanceToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv2 instanceof WikiId)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Set wikiIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv2 = itemIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        destination$iv$iv = $this$filterIsInstanceToSet$iv2;
        Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv3 instanceof ChapterId)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        Set chapterIds = (Set)destination$iv$iv2;
        Iterable $this$filterIsInstanceToSet$iv3 = itemIds;
        boolean $i$f$filterIsInstanceToSet3 = false;
        destination$iv$iv2 = $this$filterIsInstanceToSet$iv3;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv3));
        boolean $i$f$filterIsInstanceTo2232 = false;
        for (Object element$iv$iv42 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv42 instanceof ArticleId)) continue;
            destination$iv$iv3.add(element$iv$iv42);
        }
        Set articleIds = (Set)destination$iv$iv3;
        Map wikis = this.wikiService.getWikisByIds(wikiIds);
        Map chapters = this.chapterService.getChaptersByIds(chapterIds);
        Map articles = this.articleService.readByIds(articleIds);
        Map $i$f$filterIsInstanceTo2232 = chapters;
        Set set = wikiIds;
        boolean $i$f$mapToSet = false;
        element$iv$iv42 = $this$mapToSet$iv;
        Collection destination$iv$iv4 = new LinkedHashSet($this$mapToSet$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            collection2 = destination$iv$iv4;
            boolean bl = false;
            v = (Chapter)entry2.getValue();
            collection2.add(v.getWikiId());
        }
        $this$mapToSet$iv = articles;
        collection2 = (Set)destination$iv$iv4;
        $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        Collection destination$iv$iv5 = new LinkedHashSet($this$mapToSet$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry3 = entry = iterator.next();
            collection = destination$iv$iv5;
            boolean bl = false;
            v = (Article)entry3.getValue();
            collection.add(v.getWikiId());
        }
        collection = (Set)destination$iv$iv5;
        Set wikiIdsToCheck = SetsKt.plus((Set)set, (Iterable)SetsKt.plus((Set)collection2, (Iterable)collection));
        Map readableWikiIds = this.authorizationService.mayReadWikis(wikiIdsToCheck, authContext.getUser());
        Map $this$filterKeys$iv = wikis;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            WikiId wikiId = (WikiId)entry.getKey();
            boolean bl = false;
            if (!readableWikiIds.getOrDefault(wikiId, false).booleanValue()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map readableWikis = result$iv;
        Map $this$filterValues$iv = chapters;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            Chapter chapter = (Chapter)entry.getValue();
            boolean bl = false;
            if (!readableWikiIds.getOrDefault(chapter.getWikiId(), false).booleanValue()) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        Map readableChapters = result$iv2;
        Map $this$filterValues$iv2 = articles;
        boolean $i$f$filterValues2 = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv2.entrySet()) {
            Article it = (Article)entry.getValue();
            boolean bl = false;
            if (!readableWikiIds.getOrDefault(it.getWikiId(), false).booleanValue()) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        Map readableArticles = linkedHashMap;
        Map readableArticleVersions = this.articleService.findLatestPublishedArticleVersions(readableArticles.keySet());
        return new Companion.ReadableItems(readableWikis, readableChapters, readableArticles, readableArticleVersions);
    }

    /*
     * WARNING - void declaration
     */
    private <K, V extends Translatable<? extends V>> Map<K, V> translate(Map<K, ? extends V> wikis, String translationLanguage, TenantId tenantId, Function1<? super V, ? extends K> keyMapper) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = this.translationService.translate(CollectionsKt.toList((Iterable)wikis.values()), translationLanguage, tenantId);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var8_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Translatable translatable = (Translatable)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(keyMapper.invoke((Object)it), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ParentId, List<Ancestor>> translateAncestors(Map<ParentId, ? extends List<? extends Ancestor>> ancestors, String translationLanguage, TenantId tenantId) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$associateByTo$iv$iv2;
        void $this$associateBy$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv2;
        Iterable iterable = CollectionsKt.flatten((Iterable)ancestors.values());
        Object object = this.translationService;
        boolean $i$f$filterIsInstance = false;
        void var7_8 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof Wiki)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = object.translate(CollectionsKt.toList((Iterable)((List)destination$iv$iv)), translationLanguage, tenantId);
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            Wiki wiki = (Wiki)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(it.getId(), element$iv$iv);
        }
        Map translatedAncestorWiki = destination$iv$iv2;
        Iterable $i$f$associateBy22 = CollectionsKt.flatten((Iterable)ancestors.values());
        object = this.translationService;
        boolean $i$f$filterIsInstance2 = false;
        $this$associateByTo$iv$iv2 = $this$filterIsInstance$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Chapter)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = object.translate(CollectionsKt.toList((Iterable)((List)destination$iv$iv2)), translationLanguage, tenantId);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Chapter bl = (Chapter)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl2 = false;
            object.put(it.getId(), element$iv$iv);
        }
        Map translatedAncestorChapter = destination$iv$iv3;
        Map<ParentId, ? extends List<? extends Ancestor>> $this$mapValuesNotNull$iv = ancestors;
        boolean $i$f$mapValuesNotNull = false;
        Iterable capacity$iv22 = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        destination$iv$iv3 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl2 = $this$forEach$iv$iv$iv$iv.iterator();
        while (bl2.hasNext()) {
            Pair it$iv$iv$iv;
            void $this$mapTo$iv$iv;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = bl2.next();
            boolean bl = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl3 = false;
            Map.Entry entry = entry$iv;
            boolean bl4 = false;
            Iterable $this$map$iv = (Iterable)entry.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Ancestor ancestor = (Ancestor)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl5 = false;
                Object object2 = (Wiki)translatedAncestorWiki.get(it.getId());
                if (object2 == null) {
                    object2 = translatedAncestorChapter.get(it.getId());
                }
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type de.justsoftware.wikiservice.business.model.Ancestor");
                collection.add((Ancestor)object2);
            }
            List it$iv = (List)destination$iv$iv4;
            boolean bl6 = false;
            if (TuplesKt.to(entry$iv.getKey(), (Object)it$iv) == null) continue;
            boolean bl7 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv$iv2;
    }

    private static final PreviewDto getSubscribedItems$lambda$5(PreviewDto it) {
        TranslationMetaData translationMetaData = it.getTranslationMetaData();
        if (translationMetaData == null || (translationMetaData = (PreviewDto)translationMetaData.getSourceData()) == null) {
            translationMetaData = it;
        }
        return translationMetaData;
    }

    private static final WikiId findPreviewByItemsIds$lambda$6(Wiki it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    private static final ChapterId findPreviewByItemsIds$lambda$7(Chapter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId();
    }

    private static final ArticleId findPreviewByItemsIds$lambda$8(ArticleVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getArticleId();
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

