/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import de.justsoftware.auth.ToroJwtProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.onx.authorization.business.FrontendLoginService;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.security.jwt.ExternalLoginAuthenticationFilter;
import de.justsoftware.onx.security.service.JustAuthenticationProvider;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.transport.HttpsRedirectFilter;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@ParametersAreNonnullByDefault
@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    private static final String INTERNAL = "/internal/**";
    private static final String[] PUBLIC_PATHS = new String[]{"/rest/internal/**", "/rest/heartbeat", "/monitoring/**", "/config/**", "/internal/monitoring/**", "/external/login/error", "/login/config", "/login/legalAgreement", "/assets/**", "/www/**", "/font/**", "/api/*/i18n/**", "/resource/i18n**", "/api/*/info/**", "/api/*/account/unauthorized/**", "/api/*/theme/global", "/swagger-ui/**", "/swagger-resources/**", "/v3/api-docs/**", "/terms", "/privacy", "/imprint", "/help", "/press", "/about", "/articlesOfAssociation", "/registerTenant/**", "/requestActivation", "/requestNewPassword", "/activateAccount/**", "/newMail/**", "/outdatedBrowser"};

    @Bean
    protected SecurityFilterChain configure(HttpSecurity http, @Qualifier(value="encryptedJwtVerifier") JwtVerifier jwtVerifier, CsrfTokenRepository csrfTokenRepository, @Qualifier(value="jwtTokenAuthenticationProvider") JustAuthenticationProvider jwtTokenAuthenticationProvider, FrontendLoginService frontEndloginService, @Qualifier(value="justSessionRepositoryFilter") Filter supeopertySessionFilter, ExternalLoginAuthenticationFilter externalLoginAuthenticationFilter, @Qualifier(value="authenticationManager") AuthenticationManager justConnectAuthenticationManager, ServerUrlUtil serverUrlUtil) throws Exception {
        PathPatternRequestMatcher.Builder pathRequestMatcher = PathPatternRequestMatcher.withDefaults();
        OrRequestMatcher ignoredPatchs = new OrRequestMatcher(Arrays.stream(PUBLIC_PATHS).map(arg_0 -> ((PathPatternRequestMatcher.Builder)pathRequestMatcher).matcher(arg_0)).collect(Collectors.toList()));
        PathPatternRequestMatcher internalPathsMatcher = pathRequestMatcher.matcher(INTERNAL);
        ToroJwtProcessingFilter jwtAuthenticationProcessingFilter = new ToroJwtProcessingFilter(jwtVerifier, jwtTokenAuthenticationProvider, frontEndloginService);
        jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((RequestMatcher)ignoredPatchs).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)pathRequestMatcher.matcher("/resource/html"));
        http.authorizeHttpRequests(arg_0 -> WebSecurityConfig.lambda$configure$0(pathRequestMatcher, ignoredPatchs, (RequestMatcher)internalPathsMatcher, arg_0)).csrf(AbstractHttpConfigurer::disable).headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::sameOrigin)).requestCache(AbstractHttpConfigurer::disable).anonymous(AbstractHttpConfigurer::disable).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authenticationManager(justConnectAuthenticationManager).addFilterBefore((Filter)jwtAuthenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).addFilterBefore(supeopertySessionFilter, HttpsRedirectFilter.class).addFilterBefore((Filter)externalLoginAuthenticationFilter, BasicAuthenticationFilter.class).exceptionHandling(ex -> ex.authenticationEntryPoint(this.authenticationEntryPoint(serverUrlUtil))).logout(logout -> logout.invalidateHttpSession(true));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint(ServerUrlUtil serverUrlUtil) {
        RequestMatcher ajaxRequestMatcher = request -> "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
        LinkedHashMap<RequestMatcher, HttpStatusEntryPoint> entryPoints = new LinkedHashMap<RequestMatcher, HttpStatusEntryPoint>();
        entryPoints.put(ajaxRequestMatcher, new HttpStatusEntryPoint(HttpStatus.FORBIDDEN));
        DelegatingAuthenticationEntryPoint delegatingEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
        delegatingEntryPoint.setDefaultEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(serverUrlUtil.getSystemDomainPrefix()));
        return delegatingEntryPoint;
    }

    private static /* synthetic */ void lambda$configure$0(PathPatternRequestMatcher.Builder pathRequestMatcher, OrRequestMatcher ignoredPatchs, RequestMatcher internalPathsMatcher, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizeRequests) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizeRequests.requestMatchers(new RequestMatcher[]{pathRequestMatcher.matcher("/config/**")})).permitAll().requestMatchers(new RequestMatcher[]{ignoredPatchs})).permitAll().requestMatchers(new RequestMatcher[]{internalPathsMatcher})).permitAll().anyRequest()).authenticated();
    }
}

