/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.rest;

import de.justsoftware.news.connector.drive.DriveKafkaProducer;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.comment.CommentWithTenantId;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/news/rest/InternalRepublishService;", "", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "driveKafkaProducer", "Lde/justsoftware/news/connector/drive/DriveKafkaProducer;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "<init>", "(Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/connector/drive/DriveKafkaProducer;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "log", "Lorg/slf4j/Logger;", "republishAll", "", "getTenantId", "Lde/justsoftware/news/id/TenantId;", "channels", "", "Lde/justsoftware/news/domain/channel/Channel;", "post", "Lde/justsoftware/news/domain/post/Post;", "news-service"})
@SourceDebugExtension(value={"SMAP\nInternalRepublishService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalRepublishService.kt\nde/justsoftware/news/rest/InternalRepublishService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1740#2,3:112\n1869#2:116\n1869#2,2:117\n1870#2:119\n1#3:115\n*S KotlinDebug\n*F\n+ 1 InternalRepublishService.kt\nde/justsoftware/news/rest/InternalRepublishService\n*L\n107#1:112,3\n37#1:116\n41#1:117,2\n37#1:119\n*E\n"})
public class InternalRepublishService {
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final DriveKafkaProducer driveKafkaProducer;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final Logger log;

    public InternalRepublishService(@NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull ChannelRepo channelRepo, @NotNull DriveKafkaProducer driveKafkaProducer, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull PostCommentRepo postCommentRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)driveKafkaProducer, (String)"driveKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.channelPermissionRepo = channelPermissionRepo;
        this.channelRepo = channelRepo;
        this.driveKafkaProducer = driveKafkaProducer;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.postCommentRepo = postCommentRepo;
        this.postRepo = postRepo;
        Logger logger = LoggerFactory.getLogger(InternalRepublishService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void republishAll() {
        Set channels = this.channelRepo.getAllByDeletedFalse();
        this.log.info("Start republish channels");
        Set it = channels;
        boolean bl = false;
        this.permissionKafkaProducer.republish(ItemId.Type.CHANNEL, () -> InternalRepublishService.republishAll$lambda$3$lambda$2(it, this));
        this.log.info("Start republish posts");
        AutoCloseable autoCloseable = this.postRepo.findByDeletedFalse();
        Throwable throwable = null;
        try {
            Stream posts2 = (Stream)autoCloseable;
            boolean bl2 = false;
            this.permissionKafkaProducer.republish(ItemId.Type.POST, () -> InternalRepublishService.republishAll$lambda$7$lambda$6(posts2, this, channels));
            posts2 = Unit.INSTANCE;
        }
        catch (Throwable bl2) {
            throwable = bl2;
            throw bl2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.log.info("Start republish comments");
        autoCloseable = this.postCommentRepo.getAllWhichHaveAttachments();
        throwable = null;
        try {
            Stream it2 = (Stream)autoCloseable;
            boolean bl3 = false;
            this.permissionKafkaProducer.republish(ItemId.Type.COMMENT, () -> InternalRepublishService.republishAll$lambda$11$lambda$10(it2, this));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.log.info("Finish republishing");
    }

    private TenantId getTenantId(Set<Channel> channels, Post post) {
        TenantId tenantId;
        boolean onlyOneTenant;
        TenantId firstTenantId;
        block6: {
            firstTenantId = ((Channel)CollectionsKt.first((Iterable)channels)).getTenantId();
            Iterable $this$all$iv = channels;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Channel it = (Channel)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getTenantId(), (Object)firstTenantId)) continue;
                    v0 = false;
                    break block6;
                }
                v0 = onlyOneTenant = true;
            }
        }
        if (onlyOneTenant) {
            tenantId = firstTenantId;
        } else {
            Object v2;
            block7: {
                Iterable iterable = channels;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    Channel it = (Channel)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)post.getChannelId())) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            Channel channel = v2;
            Object object = channel != null ? channel.getTenantId() : null;
            tenantId = object;
            Intrinsics.checkNotNull((Object)object);
        }
        return tenantId;
    }

    /*
     * WARNING - void declaration
     */
    private static final void republishAll$lambda$3$lambda$2(Set $it, InternalRepublishService this$0) {
        Iterable $this$forEach$iv = $it;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            Channel channel = (Channel)element$iv;
            boolean bl = false;
            this$0.permissionKafkaProducer.publishChannel(channel);
            Iterable iterable = this$0.channelPermissionRepo.findAllByChannelId(channel.getId());
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ChannelPermission it = (ChannelPermission)element$iv2;
                boolean bl2 = false;
                this$0.permissionKafkaProducer.publishChannelPermission(it);
            }
        }
    }

    private static final Unit republishAll$lambda$7$lambda$6$lambda$4(InternalRepublishService this$0, Set $channels, Post post) {
        this$0.permissionKafkaProducer.publishPost(post.getId(), post.getChannelId(), post.getPublished());
        this$0.permissionKafkaProducer.publishPermission(new PermissionItem((ItemId)post.getId(), (UserId)post.getAuthorId(), PermissionRole.MANAGER));
        DriveKafkaProducer driveKafkaProducer = this$0.driveKafkaProducer;
        Intrinsics.checkNotNull((Object)post);
        driveKafkaProducer.publishPost(post, this$0.getTenantId($channels, post));
        return Unit.INSTANCE;
    }

    private static final void republishAll$lambda$7$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void republishAll$lambda$7$lambda$6(Stream $posts, InternalRepublishService this$0, Set $channels) {
        $posts.forEach(arg_0 -> InternalRepublishService.republishAll$lambda$7$lambda$6$lambda$5(arg_0 -> InternalRepublishService.republishAll$lambda$7$lambda$6$lambda$4(this$0, $channels, arg_0), arg_0));
    }

    private static final Unit republishAll$lambda$11$lambda$10$lambda$8(InternalRepublishService this$0, CommentWithTenantId comment) {
        this$0.permissionKafkaProducer.publishComment(comment.getId(), comment.getPostId());
        this$0.permissionKafkaProducer.publishPermission(new PermissionItem((ItemId)comment.getId(), (UserId)comment.getAuthorId(), PermissionRole.MANAGER));
        DriveKafkaProducer driveKafkaProducer = this$0.driveKafkaProducer;
        CommentId commentId = comment.getId();
        String string = comment.getText();
        TenantId tenantId = comment.getTenantId();
        driveKafkaProducer.publishComment(commentId, tenantId, string);
        return Unit.INSTANCE;
    }

    private static final void republishAll$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void republishAll$lambda$11$lambda$10(Stream $it, InternalRepublishService this$0) {
        $it.forEach(arg_0 -> InternalRepublishService.republishAll$lambda$11$lambda$10$lambda$9(arg_0 -> InternalRepublishService.republishAll$lambda$11$lambda$10$lambda$8(this$0, arg_0), arg_0));
    }
}

