/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.drive.DriveApiConnector;
import de.justsoftware.news.connector.drive.DriveDocument;
import de.justsoftware.news.connector.drive.DriveKafkaProducer;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.attachment.Attachment;
import de.justsoftware.news.domain.attachment.AttachmentInput;
import de.justsoftware.news.domain.attachment.AttachmentRepo;
import de.justsoftware.news.domain.attachment.AttachmentsInput;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.event.EventRepo;
import de.justsoftware.news.domain.poll.Poll;
import de.justsoftware.news.domain.poll.PollAnswer;
import de.justsoftware.news.domain.poll.PollAnswerRepo;
import de.justsoftware.news.domain.poll.PollRepo;
import de.justsoftware.news.domain.poll.PollTranslationService;
import de.justsoftware.news.domain.post.ChannelAndLatestPublishDate;
import de.justsoftware.news.domain.post.PinUpdate;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.PostService;
import de.justsoftware.news.domain.post.PostService$findAllByIds$;
import de.justsoftware.news.domain.post.PostTranslationService;
import de.justsoftware.news.domain.post.error.PostAlreadyUpdatedException;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.events.PostCreatedEvent;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostUpdatedEvent;
import de.justsoftware.news.events.PostUpdatedMentions;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.DriveFileReferenceId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.news.util.DateUtilsKt;
import de.justsoftware.news.util.PaginationSupportKt;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Observed
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001Bw\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u00bf\u0001\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\b\b\u0002\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\u0010\b\u0002\u00102\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001032\n\b\u0002\u00105\u001a\u0004\u0018\u00010/2\b\u00106\u001a\u0004\u0018\u00010/2\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\b\b\u0002\u00109\u001a\u0002082\b\b\u0002\u0010:\u001a\u00020/2\b\u0010;\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020=H\u0017\u00a2\u0006\u0002\u0010>J\u00f5\u0001\u0010?\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010@\u001a\u00020/2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010A\u001a\u0004\u0018\u0001082\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\u0010\b\u0002\u00102\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001032\n\b\u0002\u0010B\u001a\u0004\u0018\u0001082\n\b\u0002\u00105\u001a\u0004\u0018\u00010/2\n\b\u0002\u0010C\u001a\u0004\u0018\u0001082\n\b\u0002\u00106\u001a\u0004\u0018\u00010/2\n\b\u0002\u0010D\u001a\u0004\u0018\u0001082\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\b\u0010;\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020=H\u0017\u00a2\u0006\u0002\u0010EJH\u0010F\u001a\b\u0012\u0004\u0012\u00020!032\u0006\u0010\"\u001a\u00020#2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u0002082\u0006\u0010K\u001a\u0002082\b\u0010;\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020=H\u0016J8\u0010L\u001a\b\u0012\u0004\u0012\u00020!032\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020H2\u0006\u0010K\u001a\u0002082\b\u0010;\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020=H\u0016J0\u0010M\u001a\b\u0012\u0004\u0012\u00020!032\u0006\u0010<\u001a\u00020=2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020H2\b\u0010;\u001a\u0004\u0018\u00010%H\u0016J6\u0010N\u001a\b\u0012\u0004\u0012\u00020!032\f\u0010O\u001a\b\u0012\u0004\u0012\u00020#0P2\u0006\u0010Q\u001a\u0002082\b\u0010;\u001a\u0004\u0018\u00010%2\u0006\u0010<\u001a\u00020=H\u0016J\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020!032\f\u0010S\u001a\b\u0012\u0004\u0012\u00020)03H\u0017J\u0018\u0010T\u001a\u00020!2\u0006\u0010U\u001a\u00020)2\u0006\u0010<\u001a\u00020=H\u0016J&\u0010V\u001a\u0004\u0018\u00010!2\u0006\u0010U\u001a\u00020)2\u0006\u0010<\u001a\u00020=2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010!2\u0006\u0010U\u001a\u00020)H\u0017J,\u0010X\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010Z0Y2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020#0P2\u0006\u0010<\u001a\u00020=H\u0016J\u000e\u0010[\u001a\b\u0012\u0004\u0012\u00020!03H\u0017J\b\u0010\\\u001a\u00020]H\u0017J&\u0010^\u001a\u00020]2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010(\u001a\u00020)H\u0012J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020#0`2\u0006\u0010<\u001a\u00020=H\u0012J \u0010a\u001a\u00020]2\u0006\u0010b\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010c\u001a\u00020dH\u0012J \u0010e\u001a\u00020]2\u0006\u0010b\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010c\u001a\u00020dH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lde/justsoftware/news/domain/post/PostService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "driveKafkaProducer", "Lde/justsoftware/news/connector/drive/DriveKafkaProducer;", "eventRepo", "Lde/justsoftware/news/domain/event/EventRepo;", "pollRepo", "Lde/justsoftware/news/domain/poll/PollRepo;", "pollAnswerRepo", "Lde/justsoftware/news/domain/poll/PollAnswerRepo;", "attachmentRepo", "Lde/justsoftware/news/domain/attachment/AttachmentRepo;", "driveApiConnector", "Lde/justsoftware/news/connector/drive/DriveApiConnector;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "postTranslationService", "Lde/justsoftware/news/domain/post/PostTranslationService;", "pollTranslationService", "Lde/justsoftware/news/domain/poll/PollTranslationService;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/connector/drive/DriveKafkaProducer;Lde/justsoftware/news/domain/event/EventRepo;Lde/justsoftware/news/domain/poll/PollRepo;Lde/justsoftware/news/domain/poll/PollAnswerRepo;Lde/justsoftware/news/domain/attachment/AttachmentRepo;Lde/justsoftware/news/connector/drive/DriveApiConnector;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lde/justsoftware/news/util/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/domain/post/PostTranslationService;Lde/justsoftware/news/domain/poll/PollTranslationService;)V", "create", "Lde/justsoftware/news/domain/post/Post;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "title", "", "text", "jsonContent", "postId", "Lde/justsoftware/news/id/PostId;", "attachments", "Lde/justsoftware/news/domain/attachment/AttachmentsInput;", "event", "Lde/justsoftware/news/domain/event/Event;", "pinExpiration", "Ljava/time/Instant;", "poll", "Lde/justsoftware/news/domain/poll/Poll;", "pollAnswers", "", "Lde/justsoftware/news/domain/poll/PollAnswer;", "publishDate", "deleteDate", "commentsDisabled", "", "createNotifications", "createDate", "targetLanguage", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "(Lde/justsoftware/news/id/ChannelId;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/id/PostId;Lde/justsoftware/news/domain/attachment/AttachmentsInput;Lde/justsoftware/news/domain/event/Event;Ljava/time/Instant;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Boolean;ZLjava/time/Instant;Ljava/lang/String;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "update", "lastKnownModifyDate", "pin", "deletePoll", "published", "removeDeleteDate", "(Lde/justsoftware/news/id/PostId;Ljava/time/Instant;Lde/justsoftware/news/id/ChannelId;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/news/domain/attachment/AttachmentsInput;Lde/justsoftware/news/domain/event/Event;Ljava/lang/Boolean;Ljava/time/Instant;Lde/justsoftware/news/domain/poll/Poll;Ljava/util/List;Ljava/lang/Boolean;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;Lde/justsoftware/news/auth/AuthorizationContext;)Lde/justsoftware/news/domain/post/Post;", "getChannelPosts", "offset", "", "limit", "scheduled", "pinned", "getFeed", "getEvents", "getNewscoverSectionPosts", "channelIds", "", "pinnedOnly", "findAllByIds", "postIds", "getById", "id", "findById", "findByIdDeleted", "findLatestPublishDate", "", "", "publishScheduledPosts", "unpinPostsAfterPinExpiration", "", "insertPoll", "getSubscribedChannels", "", "createAttachments", "input", "userId", "Lde/justsoftware/news/id/ProfileId;", "updateAttachments", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PostService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,628:1\n1#2:629\n1563#3:630\n1634#3,3:631\n1563#3:634\n1634#3,3:635\n1563#3:638\n1634#3,3:639\n1056#3:642\n1193#3,2:643\n1267#3,4:645\n1285#3,2:649\n1299#3,4:651\n1563#3:655\n1634#3,3:656\n1563#3:659\n1634#3,3:660\n1563#3:663\n1634#3,3:664\n774#3:667\n865#3,2:668\n1563#3:670\n1634#3,3:671\n1563#3:674\n1634#3,3:675\n1878#3,3:678\n1563#3:681\n1634#3,3:682\n1563#3:685\n1634#3,3:686\n774#3:689\n865#3,2:690\n1869#3,2:692\n774#3:694\n865#3,2:695\n1869#3,2:697\n774#3:699\n865#3,2:700\n1869#3,2:702\n1878#3,3:704\n1869#3,2:707\n*S KotlinDebug\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PostService\n*L\n324#1:630\n324#1:631,3\n365#1:634\n365#1:635,3\n397#1:638\n397#1:639,3\n402#1:642\n427#1:643,2\n427#1:645,4\n430#1:649,2\n430#1:651,4\n438#1:655\n438#1:656,3\n459#1:659\n459#1:660,3\n472#1:663\n472#1:664,3\n488#1:667\n488#1:668,2\n490#1:670\n490#1:671,3\n495#1:674\n495#1:675,3\n499#1:678,3\n514#1:681\n514#1:682,3\n517#1:685\n517#1:686,3\n520#1:689\n520#1:690,2\n521#1:692,2\n525#1:694\n525#1:695,2\n527#1:697,2\n542#1:699\n542#1:700,2\n543#1:702,2\n550#1:704,3\n443#1:707,2\n*E\n"})
public class PostService {
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final DriveKafkaProducer driveKafkaProducer;
    @NotNull
    private final EventRepo eventRepo;
    @NotNull
    private final PollRepo pollRepo;
    @NotNull
    private final PollAnswerRepo pollAnswerRepo;
    @NotNull
    private final AttachmentRepo attachmentRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final PostTranslationService postTranslationService;
    @NotNull
    private final PollTranslationService pollTranslationService;

    public PostService(@NotNull ChannelRepo channelRepo, @NotNull DriveKafkaProducer driveKafkaProducer, @NotNull EventRepo eventRepo, @NotNull PollRepo pollRepo, @NotNull PollAnswerRepo pollAnswerRepo, @NotNull AttachmentRepo attachmentRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull PostRepo postRepo, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher eventPublisher, @NotNull PostTranslationService postTranslationService, @NotNull PollTranslationService pollTranslationService) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)driveKafkaProducer, (String)"driveKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)eventRepo, (String)"eventRepo");
        Intrinsics.checkNotNullParameter((Object)pollRepo, (String)"pollRepo");
        Intrinsics.checkNotNullParameter((Object)pollAnswerRepo, (String)"pollAnswerRepo");
        Intrinsics.checkNotNullParameter((Object)attachmentRepo, (String)"attachmentRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)postTranslationService, (String)"postTranslationService");
        Intrinsics.checkNotNullParameter((Object)pollTranslationService, (String)"pollTranslationService");
        this.channelRepo = channelRepo;
        this.driveKafkaProducer = driveKafkaProducer;
        this.eventRepo = eventRepo;
        this.pollRepo = pollRepo;
        this.pollAnswerRepo = pollAnswerRepo;
        this.attachmentRepo = attachmentRepo;
        this.driveApiConnector = driveApiConnector;
        this.postRepo = postRepo;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.transactionSupport = transactionSupport;
        this.eventPublisher = eventPublisher;
        this.postTranslationService = postTranslationService;
        this.pollTranslationService = pollTranslationService;
    }

    @Transactional
    @NotNull
    public Post create(@NotNull ChannelId channelId, @NotNull String title, @NotNull String text, @NotNull String jsonContent, @NotNull PostId postId, @Nullable AttachmentsInput attachments, @Nullable Event event, @Nullable Instant pinExpiration, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Instant publishDate, @Nullable Instant deleteDate, @Nullable Boolean commentsDisabled, boolean createNotifications, @NotNull Instant createDate, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        Event it;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)jsonContent, (String)"jsonContent");
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)createDate, (String)"createDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(channelId, ChannelAction.CREATE_POST);
        Instant now = Instant.now();
        if (publishDate != null && !publishDate.isAfter(now)) {
            boolean $i$a$-require-PostService$create$52 = false;
            String $i$a$-require-PostService$create$52 = "If provided, 'publishDate' must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$52.toString());
        }
        if (pinExpiration != null && !pinExpiration.isAfter(now)) {
            boolean $i$a$-require-PostService$create$62 = false;
            String $i$a$-require-PostService$create$62 = "If provided, 'pinExpiration' must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$62.toString());
        }
        if (pinExpiration != null && publishDate != null && !(pinExpiration.compareTo(publishDate) >= 0)) {
            boolean $i$a$-require-PostService$create$72 = false;
            String $i$a$-require-PostService$create$72 = "If provided, 'pinExpiration' must be set after publication date.";
            throw new IllegalArgumentException($i$a$-require-PostService$create$72.toString());
        }
        ProfileId profileId = authContext.getUser();
        AttachmentsInput attachmentsInput = attachments;
        Object object = attachmentsInput != null ? attachmentsInput.getCoverElementId() : null;
        Instant instant = pinExpiration != null ? now : null;
        Instant instant2 = publishDate;
        if (instant2 == null) {
            instant2 = createDate;
        }
        Boolean bl = commentsDisabled;
        PostRepo.insert$default((PostRepo)this.postRepo, (PostId)postId, (ProfileId)profileId, (ChannelId)channelId, (Instant)createDate, (Instant)createDate, (String)title, (String)text, (String)jsonContent, (DocumentId)object, (Instant)pinExpiration, (Instant)instant, (Instant)instant2, (publishDate == null ? 1 : 0) != 0, (boolean)false, (Instant)deleteDate, (boolean)(bl != null ? bl : false), null, (int)8192, null);
        if (poll != null) {
            Collection collection = pollAnswers;
            if (!(!(collection == null || collection.isEmpty()))) {
                boolean $i$a$-require-PostService$create$82 = false;
                String $i$a$-require-PostService$create$82 = "Answers are required when adding a Poll";
                throw new IllegalArgumentException($i$a$-require-PostService$create$82.toString());
            }
            this.insertPoll(poll, pollAnswers, postId);
        }
        Event event2 = event;
        if (event2 != null) {
            it = event2;
            boolean bl2 = false;
            this.eventRepo.insert(it.getId(), it.getPostId(), it.getStartDate(), it.getEndDate());
        }
        AttachmentsInput attachmentsInput2 = attachments;
        if (attachmentsInput2 != null) {
            it = attachmentsInput2;
            boolean bl3 = false;
            this.createAttachments((AttachmentsInput)it, postId, authContext.getUser());
        }
        Post post = this.postRepo.getByIdAndDeletedFalse(postId);
        this.transactionSupport.afterCommit(() -> PostService.create$lambda$6(this, post, authContext, createNotifications));
        return this.postTranslationService.translate(post, targetLanguage, authContext);
    }

    public static /* synthetic */ Post create$default(PostService postService, ChannelId channelId, String string, String string2, String string3, PostId postId, AttachmentsInput attachmentsInput, Event event, Instant instant, Poll poll, List list, Instant instant2, Instant instant3, Boolean bl, boolean bl2, Instant instant4, String string4, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 0x10) != 0) {
            postId = PostId.Companion.random();
        }
        if ((n & 0x20) != 0) {
            attachmentsInput = null;
        }
        if ((n & 0x40) != 0) {
            event = null;
        }
        if ((n & 0x100) != 0) {
            poll = null;
        }
        if ((n & 0x200) != 0) {
            list = null;
        }
        if ((n & 0x400) != 0) {
            instant2 = null;
        }
        if ((n & 0x1000) != 0) {
            bl = false;
        }
        if ((n & 0x2000) != 0) {
            bl2 = true;
        }
        if ((n & 0x4000) != 0) {
            instant4 = Instant.now();
        }
        return postService.create(channelId, string, string2, string3, postId, attachmentsInput, event, instant, poll, list, instant2, instant3, bl, bl2, instant4, string4, authorizationContext);
    }

    @Transactional
    @NotNull
    public Post update(@NotNull PostId postId, @NotNull Instant lastKnownModifyDate, @Nullable ChannelId channelId, @Nullable String title, @Nullable String text, @Nullable String jsonContent, @Nullable AttachmentsInput attachments, @Nullable Event event, @Nullable Boolean pin, @Nullable Instant pinExpiration, @Nullable Poll poll, @Nullable List<PollAnswer> pollAnswers, @Nullable Boolean deletePoll, @Nullable Instant publishDate, @Nullable Boolean published, @Nullable Instant deleteDate, @Nullable Boolean removeDeleteDate, @Nullable Boolean commentsDisabled, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        Collection originPoll;
        AttachmentsInput it;
        Instant instant;
        Instant instant2;
        Event event2;
        String string;
        String string2;
        String string3;
        String string4;
        ChannelId channelId2;
        boolean hasChannelChanged;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)lastKnownModifyDate, (String)"lastKnownModifyDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post origin = this.postRepo.getByIdAndDeletedFalse(postId);
        authContext.checkPostAction(origin, PostAction.EDIT);
        boolean bl = hasChannelChanged = channelId != null && !Intrinsics.areEqual((Object)channelId, (Object)origin.getChannelId());
        if (hasChannelChanged) {
            authContext.checkWrite((ItemId)channelId);
        }
        if (!DateUtilsKt.equals((Instant)lastKnownModifyDate, (Instant)origin.getModifyDate(), (boolean)true)) {
            boolean bl2 = false;
            throw new PostAlreadyUpdatedException("Post has already been edited by someone else.");
        }
        Instant now = Instant.now();
        Instant instant3 = publishDate;
        if (instant3 != null) {
            Instant it2 = instant3;
            boolean bl3 = false;
            if (!(!origin.getPublished())) {
                boolean $i$a$-require-PostService$update$2$32 = false;
                String $i$a$-require-PostService$update$2$32 = "An already published post may not be planned again";
                throw new IllegalArgumentException($i$a$-require-PostService$update$2$32.toString());
            }
            if (!it2.isAfter(now)) {
                boolean $i$a$-require-PostService$update$2$42 = false;
                String $i$a$-require-PostService$update$2$42 = "publishDate must be a date in the future";
                throw new IllegalArgumentException($i$a$-require-PostService$update$2$42.toString());
            }
        }
        PinUpdate pinUpdate = new PinUpdate(pin, pinExpiration, publishDate, origin, channelId, authContext);
        boolean publishNow = hasChannelChanged ? origin.getPublished() || Intrinsics.areEqual((Object)published, (Object)true) : !origin.getPublished() && Intrinsics.areEqual((Object)published, (Object)true);
        boolean needsReTranslation = title != null || jsonContent != null;
        ChannelId channelId3 = channelId;
        if (channelId3 == null) {
            channelId3 = channelId2 = origin.getChannelId();
        }
        if ((string4 = title) == null) {
            string4 = string3 = origin.getTitle();
        }
        if ((string2 = text) == null) {
            string2 = string = origin.getText();
        }
        if ((event2 = event) == null) {
            event2 = origin.getEvent();
        }
        Event event3 = event2;
        AttachmentsInput attachmentsInput = attachments;
        DocumentId documentId = attachmentsInput == null ? origin.getCoverElementId() : attachmentsInput.getCoverElementId();
        String string5 = jsonContent;
        if (string5 == null) {
            string5 = origin.getJsonContent();
        }
        String string6 = string5;
        Instant instant4 = pinUpdate.pinExpiration();
        Instant instant5 = pinUpdate.pinnedAt();
        if (publishNow) {
            instant2 = now;
        } else {
            instant2 = publishDate;
            if (instant2 == null) {
                instant2 = origin.getPublishDate();
            }
        }
        Instant instant6 = instant2;
        Intrinsics.checkNotNull((Object)instant6);
        Instant instant7 = instant6;
        Boolean bl4 = published;
        boolean bl5 = bl4 != null ? bl4.booleanValue() : origin.getPublished();
        Intrinsics.checkNotNull((Object)now);
        Instant instant8 = now;
        ProfileId profileId = authContext.getUser();
        if (Intrinsics.areEqual((Object)removeDeleteDate, (Object)true)) {
            instant = null;
        } else {
            instant = deleteDate;
            if (instant == null) {
                instant = origin.getDeleteDate();
            }
        }
        Instant instant9 = instant;
        Boolean bl6 = commentsDisabled;
        boolean bl7 = bl6 != null ? bl6.booleanValue() : origin.getCommentsDisabled();
        String string7 = needsReTranslation ? null : origin.getSourceLanguage();
        Post update = Post.copy$default((Post)origin, null, null, (ChannelId)channelId2, null, (Instant)instant8, (String)string3, (String)string, (String)string6, (DocumentId)documentId, (boolean)false, (Instant)instant9, (Instant)instant4, (Instant)instant5, (Instant)instant7, (boolean)bl5, (ProfileId)profileId, (Event)event3, (boolean)bl7, (String)string7, null, (int)524811, null);
        AttachmentsInput attachmentsInput2 = attachments;
        if (attachmentsInput2 != null) {
            it = attachmentsInput2;
            boolean bl8 = false;
            this.updateAttachments(it, postId, authContext.getUser());
        }
        if (Intrinsics.areEqual((Object)deletePoll, (Object)true) && (originPoll = this.pollRepo.findByPostId(origin.getId())) != null) {
            List originPollAnswers = this.pollAnswerRepo.findAllByPollId(originPoll.getId());
            this.pollTranslationService.deleteTranslations((Poll)originPoll, originPollAnswers);
            this.pollRepo.deleteById((Object)originPoll.getId());
        }
        if (poll != null) {
            originPoll = pollAnswers;
            if (!(!(originPoll == null || originPoll.isEmpty()))) {
                boolean $i$a$-require-PostService$update$62 = false;
                String $i$a$-require-PostService$update$62 = "Answers are required when adding a Poll";
                throw new IllegalArgumentException($i$a$-require-PostService$update$62.toString());
            }
            originPoll = this.pollRepo.findByPostId(origin.getId());
            if (!(originPoll == null)) {
                boolean $i$a$-require-PostService$update$72 = false;
                String $i$a$-require-PostService$update$72 = "The Post '" + origin.getId() + "' has already a Poll and can only have one Poll";
                throw new IllegalArgumentException($i$a$-require-PostService$update$72.toString());
            }
            this.insertPoll(poll, pollAnswers, postId);
        }
        if (needsReTranslation) {
            this.postTranslationService.deleteTranslations(origin);
        }
        this.transactionSupport.afterCommit(() -> PostService.update$lambda$14(origin, hasChannelChanged, title, text, this, postId, update, authContext, publishNow));
        it = (Post)this.postRepo.save((Object)update);
        boolean bl9 = false;
        Intrinsics.checkNotNull((Object)it);
        return this.postTranslationService.translate((Post)it, targetLanguage, authContext);
    }

    public static /* synthetic */ Post update$default(PostService postService, PostId postId, Instant instant, ChannelId channelId, String string, String string2, String string3, AttachmentsInput attachmentsInput, Event event, Boolean bl, Instant instant2, Poll poll, List list, Boolean bl2, Instant instant3, Boolean bl3, Instant instant4, Boolean bl4, Boolean bl5, String string4, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 4) != 0) {
            channelId = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            string3 = null;
        }
        if ((n & 0x40) != 0) {
            attachmentsInput = null;
        }
        if ((n & 0x80) != 0) {
            event = null;
        }
        if ((n & 0x100) != 0) {
            bl = null;
        }
        if ((n & 0x200) != 0) {
            instant2 = null;
        }
        if ((n & 0x400) != 0) {
            poll = null;
        }
        if ((n & 0x800) != 0) {
            list = null;
        }
        if ((n & 0x1000) != 0) {
            bl2 = null;
        }
        if ((n & 0x2000) != 0) {
            instant3 = null;
        }
        if ((n & 0x4000) != 0) {
            bl3 = null;
        }
        if ((n & 0x8000) != 0) {
            instant4 = null;
        }
        if ((n & 0x10000) != 0) {
            bl4 = null;
        }
        if ((n & 0x20000) != 0) {
            bl5 = null;
        }
        return postService.update(postId, instant, channelId, string, string2, string3, attachmentsInput, event, bl, instant2, poll, list, bl2, instant3, bl3, instant4, bl4, bl5, string4, authorizationContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getChannelPosts(@NotNull ChannelId channelId, int offset, int limit, boolean scheduled, boolean pinned, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List posts2 = PaginationSupportKt.convertPaging((int)offset, (int)limit, (arg_0, arg_1) -> PostService.getChannelPosts$lambda$16(scheduled, pinned, this, channelId, arg_0, arg_1));
        List<Post> list = posts2;
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        authorizationContext.checkReadAll((Collection)((List)destination$iv$iv));
        list = posts2.parallelStream().map(arg_0 -> PostService.getChannelPosts$lambda$19(arg_0 -> PostService.getChannelPosts$lambda$18(this, targetLanguage, authContext, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public List<Post> getFeed(int offset, int limit, boolean pinned, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set subscribedChannelIds = this.getSubscribedChannels(authContext);
        KFunction feedQuery2 = pinned ? (KFunction)getFeed.feedQuery.1.INSTANCE : (KFunction)getFeed.feedQuery.2.INSTANCE;
        List<Post> list = PaginationSupportKt.convertPaging((int)offset, (int)limit, (arg_0, arg_1) -> PostService.getFeed$lambda$20(feedQuery2, this, subscribedChannelIds, arg_0, arg_1)).parallelStream().map(arg_0 -> PostService.getFeed$lambda$22(arg_0 -> PostService.getFeed$lambda$21(this, targetLanguage, authContext, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getEvents(@NotNull AuthorizationContext authContext, int offset, int limit, @Nullable String targetLanguage) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set tenantChannels = this.channelRepo.getByTenantIdAndDeletedFalse(authContext.getTenantId());
        List<Post> list = (List<Post>)((Object)tenantChannels);
        AuthorizationContext authorizationContext = authContext;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set channelIds = CollectionsKt.toSet((Iterable)authorizationContext.filterReadable((Collection)((List)destination$iv$iv)));
        if (channelIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        list = this.postRepo.findEventsByChannelIdIn(channelIds, offset, limit).parallelStream().map(arg_0 -> PostService.getEvents$lambda$25(arg_0 -> PostService.getEvents$lambda$24(this, targetLanguage, authContext, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Post> getNewscoverSectionPosts(@NotNull Collection<ChannelId> channelIds, boolean pinnedOnly, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Collection collection;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Collection collection2 = channelIds;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = this.channelRepo.getIdsByTenant(authContext.getTenantId());
        } else {
            collection = collection2;
        }
        Collection it = collection;
        boolean bl = false;
        List channelIdsReadable = authContext.filterReadable(it);
        PageRequest pageRequest = PageRequest.of((int)0, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageRequest2 = pageRequest;
        Page page = pinnedOnly ? this.postRepo.findByChannelIdInAndPinExpirationNotNullAndPublishedTrueAndDeletedFalseOrderByPinnedAtDesc((Collection)channelIdsReadable, (Pageable)pageRequest2) : this.postRepo.findByChannelIdInAndPublishedTrueAndDeletedFalseOrderByPublishDateDesc((Collection)channelIdsReadable, (Pageable)pageRequest2);
        List list = page.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Post post = (Post)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            collection3.add(this.postTranslationService.translate((Post)it2, targetLanguage, authContext));
        }
        return (List)destination$iv$iv;
    }

    @Unauthorized
    @NotNull
    public List<Post> findAllByIds(@NotNull List<PostId> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Iterable iterable = this.postRepo.findAllById((Iterable)postIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAllById(...)");
        Iterable $this$sortedBy$iv = iterable;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAllByIds$$inlined$sortedBy$1(postIds)));
    }

    @NotNull
    public Post getById(@NotNull PostId id, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = PostService.findById$default((PostService)this, (PostId)id, (AuthorizationContext)authContext, null, (int)4, null);
        if (post == null) {
            throw new NoSuchElementException("Post with id :'" + id + "' does not exist.");
        }
        return post;
    }

    @Nullable
    public Post findById(@NotNull PostId id, @NotNull AuthorizationContext authContext, @Nullable String targetLanguage) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Post post = PostRepo.findByIdAndDeleted$default((PostRepo)this.postRepo, (PostId)id, (boolean)false, (int)2, null);
        if (post == null) {
            return null;
        }
        Post post2 = post;
        authContext.checkRead((ItemId)post2.getId());
        return this.postTranslationService.translate(post2, targetLanguage, authContext);
    }

    public static /* synthetic */ Post findById$default(PostService postService, PostId postId, AuthorizationContext authorizationContext, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findById");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return postService.findById(postId, authorizationContext, string);
    }

    @Unauthorized
    @Nullable
    public Post findByIdDeleted(@NotNull PostId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.postRepo.findByIdAndDeleted(id, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChannelId, Long> findLatestPublishDate(@NotNull Collection<ChannelId> channelIds, @NotNull AuthorizationContext authContext) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (channelIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        List channelIdsReadable = authContext.filterReadable(channelIds);
        Set results = this.postRepo.findLatestPublishDatesByChannelIds(CollectionsKt.toSet((Iterable)channelIdsReadable));
        Iterable $this$associate$iv = results;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ChannelAndLatestPublishDate it = (ChannelAndLatestPublishDate)element$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getChannelId(), (Object)it.getLatestPublishDate());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map resultMap = destination$iv$iv;
        Iterable $this$associateWith$iv = channelIdsReadable;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Object element$iv$iv2;
            element$iv$iv2 = (ChannelId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Instant instant = (Instant)resultMap.get(it);
            Long l = instant != null ? Long.valueOf(instant.getEpochSecond()) : null;
            map.put(t, l);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Unauthorized
    @NotNull
    public List<Post> publishScheduledPosts() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PostRepo.findByDeletedFalseAndPublishedFalseAndPublishDateLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Post.copy$default((Post)it, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)true, null, null, (boolean)false, null, null, (int)1032191, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.postRepo.saveAll((Iterable)it);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"let(...)");
        List publishedPosts = CollectionsKt.toList((Iterable)iterable2);
        this.transactionSupport.afterCommit(() -> PostService.publishScheduledPosts$lambda$35(publishedPosts, this));
        return publishedPosts;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    public void unpinPostsAfterPinExpiration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PostRepo.findByDeletedFalseAndPinExpirationLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Post.copy$default((Post)it, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, null, null, (int)1042431, null));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        this.postRepo.saveAll((Iterable)it);
    }

    /*
     * WARNING - void declaration
     */
    private void insertPoll(Poll poll, List<PollAnswer> pollAnswers, PostId postId) {
        void $this$mapTo$iv$iv;
        this.pollRepo.insert(poll.getId(), poll.getQuestion(), poll.getAllowMultipleAnswers(), postId, poll.getPrivacy());
        Iterable $this$map$iv = pollAnswers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void answer;
            PollAnswer pollAnswer = (PollAnswer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.pollAnswerRepo.insert(answer.getId(), answer.getText(), answer.getPosition(), answer.getPollId());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Set<ChannelId> getSubscribedChannels(AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        ChannelId channelId;
        void $this$filterTo$iv$iv;
        Set channelIdsOfTenant = this.channelRepo.getIdsByTenant(authContext.getTenantId());
        Iterable $this$filter$iv = this.subscriptionRepoWrapper.getSubscribedChannelIds(authContext.getUser());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            channelId = (ChannelId)element$iv$iv;
            boolean bl = false;
            if (!channelIdsOfTenant.contains(channelId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean $i$a$-let-PostService$getSubscribedChannels$32 = false;
        Iterable $this$map$iv = authContext.filterReadable((Collection)it);
        boolean $i$f$map = false;
        Iterable $i$a$-let-PostService$getSubscribedChannels$32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            channelId = (ChannelId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChannelId.Companion.fromString(it2.toTypedString()));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private void createAttachments(AttachmentsInput input, PostId postId, ProfileId userId) {
        void $this$forEachIndexed$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = input.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AttachmentInput attachmentInput = (AttachmentInput)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List documentIds = (List)destination$iv$iv;
        $this$map$iv = this.driveApiConnector.addFiles(documentIds, (DriveFileReferenceId)postId, userId);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object v0;
            AttachmentRepo attachmentRepo;
            DocumentId documentId;
            DriveFileReferenceId driveFileReferenceId;
            String string;
            String string2;
            int n;
            int n2;
            block4: {
                void attachment;
                int n3;
                Object item$iv$iv;
                if ((n3 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (DriveDocument)item$iv;
                int index = n3;
                boolean bl = false;
                Iterable iterable2 = input.getValues();
                n2 = index;
                n = attachment.getSize();
                string2 = attachment.getName();
                string = attachment.getMimeType();
                driveFileReferenceId = (DriveFileReferenceId)postId;
                documentId = attachment.getDocumentId();
                attachmentRepo = this.attachmentRepo;
                Iterable iterable3 = iterable2;
                for (Object t : iterable3) {
                    AttachmentInput it = (AttachmentInput)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)attachment.getDocumentId())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Object var27_32 = v0;
            AttachmentInput attachmentInput = var27_32;
            attachmentRepo.insert(documentId, driveFileReferenceId, string, string2, n, n2, attachmentInput != null ? attachmentInput.getAltText() : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateAttachments(AttachmentsInput input, PostId postId, ProfileId userId) {
        Iterable $this$forEach$iv;
        int n;
        Iterator $this$filterTo$iv$iv;
        Object element$iv2;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv2;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List originAttachments = this.attachmentRepo.findAllByItemIdOrderByPosition((DriveFileReferenceId)postId);
        Iterable $this$map$iv = originAttachments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            Attachment attachment = (Attachment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List originAttachmentIds = (List)destination$iv$iv;
        List updateAttachments = input.getValues();
        Iterable $this$map$iv2 = updateAttachments;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AttachmentInput attachmentInput = (AttachmentInput)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getId());
        }
        List updateAttachmentIds = (List)destination$iv$iv2;
        Iterable $this$filter$iv = originAttachmentIds;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator item$iv$iv = $this$filterTo$iv$iv2.iterator();
        while (item$iv$iv.hasNext()) {
            element$iv$iv = item$iv$iv.next();
            DocumentId it = (DocumentId)element$iv$iv;
            boolean bl = false;
            if (!(!updateAttachmentIds.contains(it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List toDelete = (List)destination$iv$iv3;
        Iterable $this$forEach$iv2 = toDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            DocumentId it = (DocumentId)element$iv2;
            boolean bl = false;
            this.driveApiConnector.deleteFile(it, userId);
        }
        this.attachmentRepo.deleteAllById((Iterable)toDelete);
        Iterable $this$filter$iv2 = updateAttachmentIds;
        boolean $i$f$filter2 = false;
        element$iv2 = $this$filter$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        element$iv$iv = $this$filterTo$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            Object element$iv$iv2 = element$iv$iv.next();
            DocumentId it = (DocumentId)element$iv$iv2;
            n = 0;
            if (!(!originAttachmentIds.contains(it))) continue;
            destination$iv$iv4.add(element$iv$iv2);
        }
        List toAdd = (List)destination$iv$iv4;
        $this$filter$iv2 = this.driveApiConnector.addFiles(toAdd, (DriveFileReferenceId)postId, userId);
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Object v0;
            AttachmentRepo attachmentRepo;
            DocumentId documentId;
            DriveFileReferenceId driveFileReferenceId;
            String string;
            String string2;
            int it;
            block11: {
                DriveDocument attachment = (DriveDocument)element$iv3;
                boolean bl = false;
                Iterable element$iv$iv2 = updateAttachments;
                it = 999;
                n = attachment.getSize();
                string2 = attachment.getName();
                string = attachment.getMimeType();
                driveFileReferenceId = (DriveFileReferenceId)postId;
                documentId = attachment.getDocumentId();
                attachmentRepo = this.attachmentRepo;
                Iterable iterable2 = element$iv$iv2;
                for (Object t : iterable2) {
                    AttachmentInput it2 = (AttachmentInput)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)attachment.getDocumentId())) continue;
                    v0 = t;
                    break block11;
                }
                v0 = null;
            }
            Object var29_64 = v0;
            AttachmentInput attachmentInput = var29_64;
            attachmentRepo.insert(documentId, driveFileReferenceId, string, string2, n, it, attachmentInput != null ? attachmentInput.getAltText() : null);
        }
        $this$forEach$iv = updateAttachments;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv2;
        destination$iv$iv4 = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv3 = bl.next();
            AttachmentInput it = (AttachmentInput)element$iv$iv3;
            boolean bl3 = false;
            if (!originAttachmentIds.contains(it.getId())) continue;
            destination$iv$iv4.add(element$iv$iv3);
        }
        $this$filter$iv2 = (List)destination$iv$iv4;
        $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            AttachmentInput toUpdate = (AttachmentInput)element$iv3;
            boolean bl4 = false;
            this.attachmentRepo.updateAltText(toUpdate.getId(), toUpdate.getAltText());
        }
        Iterable $this$forEachIndexed$iv = updateAttachments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void attachment;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AttachmentInput element$iv$iv3 = (AttachmentInput)item$iv;
            int index = n2;
            boolean bl5 = false;
            this.attachmentRepo.updatePosition(attachment.getId(), index);
        }
    }

    private static final Unit create$lambda$6(PostService this$0, Post $post, AuthorizationContext $authContext, boolean $createNotifications) {
        KafkaPublishOperation[] kafkaPublishOperationArray = new KafkaPublishOperation[]{this$0.permissionKafkaProducer.publishPost($post.getId(), $post.getChannelId(), $post.getPublished()), this$0.permissionKafkaProducer.publishPermission(new PermissionItem((ItemId)$post.getId(), (UserId)$authContext.getUser(), PermissionRole.MANAGER))};
        KafkaPublishOperation.waitForCompletion$default((KafkaPublishOperation)new KafkaPublishOperation(kafkaPublishOperationArray), null, (int)1, null);
        this$0.driveKafkaProducer.publishPost($post, $authContext.getTenantId());
        this$0.eventPublisher.publishEvent((ApplicationEvent)new PostCreatedEvent($post, $authContext.getTenantId()));
        if ($post.getPublished()) {
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostPublishedEvent($post, $authContext.getTenantId(), $createNotifications, false, 8, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$14(Post $origin, boolean $hasChannelChanged, String $title, String $text, PostService this$0, PostId $postId, Post $update, AuthorizationContext $authContext, boolean $publishNow) {
        if ($origin.getPublished() && !$hasChannelChanged) {
            boolean titleOrTextChanged;
            boolean bl = titleOrTextChanged = $title != null || $text != null;
            if (titleOrTextChanged) {
                this$0.eventPublisher.publishEvent((ApplicationEvent)new PostUpdatedEvent($postId));
            }
            if ($text != null) {
                Set originMentions = QuillUtils.INSTANCE.extractMentions($origin.getJsonContent());
                Set updateMentions = QuillUtils.INSTANCE.extractMentions($update.getJsonContent());
                Set newMentions = CollectionsKt.subtract((Iterable)updateMentions, (Iterable)originMentions);
                if (!((Collection)newMentions).isEmpty()) {
                    this$0.eventPublisher.publishEvent((ApplicationEvent)new PostUpdatedMentions($update, $authContext.getTenantId(), (Collection)newMentions));
                }
            }
        } else if ($publishNow) {
            this$0.permissionKafkaProducer.publishPost($update.getId(), $update.getChannelId(), true);
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostPublishedEvent($update, $authContext.getTenantId(), false, $origin.getPublished(), 4, null));
        }
        return Unit.INSTANCE;
    }

    private static final List getChannelPosts$lambda$16(boolean $scheduled, boolean $pinned, PostService this$0, ChannelId $channelId, int pageIndex, int pageSize) {
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        KFunction postsQuery2 = $scheduled && $pinned ? (KFunction)getChannelPosts.posts.1.postsQuery.1.INSTANCE : ($scheduled && !$pinned ? (KFunction)getChannelPosts.posts.1.postsQuery.2.INSTANCE : (!$scheduled && $pinned ? (KFunction)getChannelPosts.posts.1.postsQuery.3.INSTANCE : (KFunction)getChannelPosts.posts.1.postsQuery.4.INSTANCE));
        List list = ((Page)((Function3)postsQuery2).invoke((Object)this$0.postRepo, (Object)$channelId, (Object)pageable)).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    private static final Post getChannelPosts$lambda$18(PostService this$0, String $targetLanguage, AuthorizationContext $authContext, Post it) {
        PostTranslationService postTranslationService = this$0.postTranslationService;
        Intrinsics.checkNotNull((Object)it);
        return postTranslationService.translate(it, $targetLanguage, $authContext);
    }

    private static final Post getChannelPosts$lambda$19(Function1 $tmp0, Object p0) {
        return (Post)$tmp0.invoke(p0);
    }

    private static final List getFeed$lambda$20(KFunction $feedQuery, PostService this$0, Set $subscribedChannelIds, int pageIndex, int pageSize) {
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        List list = ((Page)((Function3)$feedQuery).invoke((Object)this$0.postRepo, (Object)$subscribedChannelIds, (Object)pageable)).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    private static final Post getFeed$lambda$21(PostService this$0, String $targetLanguage, AuthorizationContext $authContext, Post it) {
        PostTranslationService postTranslationService = this$0.postTranslationService;
        Intrinsics.checkNotNull((Object)it);
        return postTranslationService.translate(it, $targetLanguage, $authContext);
    }

    private static final Post getFeed$lambda$22(Function1 $tmp0, Object p0) {
        return (Post)$tmp0.invoke(p0);
    }

    private static final Post getEvents$lambda$24(PostService this$0, String $targetLanguage, AuthorizationContext $authContext, Post it) {
        PostTranslationService postTranslationService = this$0.postTranslationService;
        Intrinsics.checkNotNull((Object)it);
        return postTranslationService.translate(it, $targetLanguage, $authContext);
    }

    private static final Post getEvents$lambda$25(Function1 $tmp0, Object p0) {
        return (Post)$tmp0.invoke(p0);
    }

    private static final Unit publishScheduledPosts$lambda$35(List $publishedPosts, PostService this$0) {
        Iterable $this$forEach$iv = $publishedPosts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Post it = (Post)element$iv;
            boolean bl = false;
            Channel channel = this$0.channelRepo.getByIdAndDeletedFalse(it.getChannelId());
            this$0.permissionKafkaProducer.publishPost(it.getId(), it.getChannelId(), true);
            this$0.eventPublisher.publishEvent((ApplicationEvent)new PostUpdatedEvent(it.getId()));
            ApplicationEventPublisher applicationEventPublisher = this$0.eventPublisher;
            Intrinsics.checkNotNull((Object)it);
            applicationEventPublisher.publishEvent((ApplicationEvent)new PostPublishedEvent(it, channel.getTenantId(), false, false, 12, null));
        }
        return Unit.INSTANCE;
    }
}

