/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.post.PinUpdate;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.id.ChannelId;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/news/domain/post/PinUpdate;", "", "pin", "", "pinExpiration", "Ljava/time/Instant;", "publishDate", "origin", "Lde/justsoftware/news/domain/post/Post;", "targetChannelId", "Lde/justsoftware/news/id/ChannelId;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "<init>", "(Ljava/lang/Boolean;Ljava/time/Instant;Ljava/time/Instant;Lde/justsoftware/news/domain/post/Post;Lde/justsoftware/news/id/ChannelId;Lde/justsoftware/news/auth/AuthorizationContext;)V", "Ljava/lang/Boolean;", "validatePinExpiration", "", "pinnedAt", "calculateWithDefaultPinDuration", "unpinDueToRestrictionsInTargetChannel", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostService.kt\nde/justsoftware/news/domain/post/PinUpdate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,628:1\n1#2:629\n*E\n"})
final class PinUpdate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Boolean pin;
    @Nullable
    private final Instant pinExpiration;
    @Nullable
    private final Instant publishDate;
    @NotNull
    private final Post origin;
    @Nullable
    private final ChannelId targetChannelId;
    @NotNull
    private final AuthorizationContext authContext;
    private static final long DEFAULT_PIN_DURATION = 14L;

    public PinUpdate(@Nullable Boolean pin, @Nullable Instant pinExpiration, @Nullable Instant publishDate, @NotNull Post origin, @Nullable ChannelId targetChannelId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.pin = pin;
        this.pinExpiration = pinExpiration;
        this.publishDate = publishDate;
        this.origin = origin;
        this.targetChannelId = targetChannelId;
        this.authContext = authContext;
        if (this.pin != null || this.pinExpiration != null) {
            if (this.targetChannelId != null) {
                this.authContext.checkChannelAction(this.targetChannelId, ChannelAction.PIN_POST);
            } else {
                this.authContext.checkPostAction(this.origin, PostAction.PIN);
            }
        }
        this.validatePinExpiration();
    }

    private final void validatePinExpiration() {
        if (this.pinExpiration == null) {
            return;
        }
        if (!this.pinExpiration.isAfter(Instant.now())) {
            boolean $i$a$-require-PinUpdate$validatePinExpiration$42 = false;
            String $i$a$-require-PinUpdate$validatePinExpiration$42 = "Pin expiration must be a date in the future.";
            throw new IllegalArgumentException($i$a$-require-PinUpdate$validatePinExpiration$42.toString());
        }
        if (this.publishDate != null) {
            if (!this.pinExpiration.isAfter(this.publishDate)) {
                boolean $i$a$-require-PinUpdate$validatePinExpiration$52 = false;
                String $i$a$-require-PinUpdate$validatePinExpiration$52 = "'pinExpiration' must be set after publication date.";
                throw new IllegalArgumentException($i$a$-require-PinUpdate$validatePinExpiration$52.toString());
            }
        } else if (!this.pinExpiration.isAfter(this.origin.getPublishDate())) {
            boolean bl = false;
            String string = "'pinExpiration' must be set after publication date.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final Instant pinnedAt() {
        Instant instant;
        if (this.unpinDueToRestrictionsInTargetChannel()) {
            return null;
        }
        Boolean bl = this.pin;
        if (bl == null) {
            instant = this.origin.getPinnedAt();
        } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            instant = Instant.now();
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            instant = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return instant;
    }

    @Nullable
    public final Instant pinExpiration() {
        if (this.unpinDueToRestrictionsInTargetChannel()) {
            return null;
        }
        if (this.pinExpiration != null) {
            return this.pinExpiration;
        }
        if (this.pin == null) {
            return this.origin.getPinExpiration();
        }
        if (Intrinsics.areEqual((Object)this.pin, (Object)false)) {
            return null;
        }
        return this.calculateWithDefaultPinDuration();
    }

    private final Instant calculateWithDefaultPinDuration() {
        if (this.origin.isPublished()) {
            Instant instant = Instant.now().plus(14L, ChronoUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
            return instant;
        }
        if (this.publishDate == null) {
            Instant instant = this.origin.getPublishDate().plus(14L, ChronoUnit.DAYS);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
            return instant;
        }
        Instant instant = this.publishDate.plus(14L, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        return instant;
    }

    private final boolean unpinDueToRestrictionsInTargetChannel() {
        boolean hasChannelChanged;
        boolean bl = hasChannelChanged = this.targetChannelId != null && !Intrinsics.areEqual((Object)this.targetChannelId, (Object)this.origin.getChannelId());
        return hasChannelChanged && !this.authContext.mayChannelAction(this.targetChannelId, ChannelAction.PIN_POST);
    }
}

