/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.drive.DriveApiConnector;
import de.justsoftware.news.connector.drive.DriveDocument;
import de.justsoftware.news.connector.drive.DriveKafkaProducer;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.domain.attachment.Attachment;
import de.justsoftware.news.domain.attachment.AttachmentRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.comment.CommentTextInput;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentAction;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.comment.PostCommentService;
import de.justsoftware.news.domain.comment.PostCommentService$findAllByIds$;
import de.justsoftware.news.domain.comment.PostCommentTranslationService;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.error.CommentWrongMimeTypeException;
import de.justsoftware.news.domain.post.error.PostCommentsAreDisabledException;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.events.PostCommentCreatedEvent;
import de.justsoftware.news.events.PostCommentUpdatedMentionsEvent;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.CommentableId;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.DriveFileReferenceId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.kafka.KafkaPublishOperation;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.news.util.Sort;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import io.micrometer.observation.annotation.Observed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Observed
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J<\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0017J@\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0017J&\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J0\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020-H\u0017J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020%0\u001dH\u0017JB\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001d012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010*\u001a\u00020+2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020-H\u0017J\"\u00103\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u000204012\f\u00105\u001a\b\u0012\u0004\u0012\u00020)06H\u0017J&\u00107\u001a\u0002082\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u00109\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentService;", "", "attachmentRepo", "Lde/justsoftware/news/domain/attachment/AttachmentRepo;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "driveApiConnector", "Lde/justsoftware/news/connector/drive/DriveApiConnector;", "driveKafkaProducer", "Lde/justsoftware/news/connector/drive/DriveKafkaProducer;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "postCommentTranslationService", "Lde/justsoftware/news/domain/comment/PostCommentTranslationService;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "<init>", "(Lde/justsoftware/news/domain/attachment/AttachmentRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/connector/drive/DriveApiConnector;Lde/justsoftware/news/connector/drive/DriveKafkaProducer;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/comment/PostCommentTranslationService;Lde/justsoftware/news/util/TransactionSupport;)V", "createComment", "Lde/justsoftware/news/domain/comment/PostComment;", "referenceId", "Lde/justsoftware/news/id/CommentableId;", "text", "Lde/justsoftware/news/domain/comment/CommentTextInput;", "attachmentIds", "", "Lde/justsoftware/news/id/DocumentId;", "targetLanguage", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "update", "id", "Lde/justsoftware/news/id/CommentId;", "findById", "getDirectComments", "postId", "Lde/justsoftware/news/id/PostId;", "sort", "Lde/justsoftware/news/util/Sort;", "tenantId", "Lde/justsoftware/news/id/TenantId;", "findAllByIds", "commentIds", "getByParentIds", "", "parentIds", "getCommentCount", "", "postIds", "", "addAttachments", "", "comment", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostCommentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostCommentService.kt\nde/justsoftware/news/domain/comment/PostCommentService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n1563#2:331\n1634#2,3:332\n774#2:335\n865#2,2:336\n1869#2,2:338\n774#2:340\n865#2,2:341\n774#2:343\n865#2,2:344\n1878#2,3:346\n1563#2:349\n1634#2,3:350\n1056#2:353\n1563#2:354\n1634#2,3:355\n1285#2,2:358\n1299#2,2:360\n774#2:362\n865#2,2:363\n1302#2:365\n1193#2,2:366\n1267#2,4:368\n1285#2,2:372\n1299#2,4:374\n1878#2,3:378\n*S KotlinDebug\n*F\n+ 1 PostCommentService.kt\nde/justsoftware/news/domain/comment/PostCommentService\n*L\n179#1:331\n179#1:332,3\n181#1:335\n181#1:336,2\n182#1:338,2\n185#1:340\n185#1:341,2\n188#1:343\n188#1:344,2\n195#1:346,3\n230#1:349\n230#1:350,3\n235#1:353\n249#1:354\n249#1:355,3\n251#1:358,2\n251#1:360,2\n252#1:362\n252#1:363,2\n251#1:365\n260#1:366,2\n260#1:368,4\n262#1:372,2\n262#1:374,4\n276#1:378,3\n*E\n"})
public class PostCommentService {
    @NotNull
    private final AttachmentRepo attachmentRepo;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final DriveKafkaProducer driveKafkaProducer;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final PostCommentTranslationService postCommentTranslationService;
    @NotNull
    private final TransactionSupport transactionSupport;

    public PostCommentService(@NotNull AttachmentRepo attachmentRepo, @NotNull PostCommentRepo commentRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull DriveKafkaProducer driveKafkaProducer, @NotNull ApplicationEventPublisher eventPublisher, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull PostRepo postRepo, @NotNull PostCommentTranslationService postCommentTranslationService, @NotNull TransactionSupport transactionSupport) {
        Intrinsics.checkNotNullParameter((Object)attachmentRepo, (String)"attachmentRepo");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)driveKafkaProducer, (String)"driveKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)postCommentTranslationService, (String)"postCommentTranslationService");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        this.attachmentRepo = attachmentRepo;
        this.commentRepo = commentRepo;
        this.driveApiConnector = driveApiConnector;
        this.driveKafkaProducer = driveKafkaProducer;
        this.eventPublisher = eventPublisher;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.postRepo = postRepo;
        this.postCommentTranslationService = postCommentTranslationService;
        this.transactionSupport = transactionSupport;
    }

    @Transactional
    @NotNull
    public PostComment createComment(@NotNull CommentableId referenceId, @Nullable CommentTextInput text, @Nullable List<DocumentId> attachmentIds, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        CommentableId commentableId;
        Post post;
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Object object = referenceId;
        if (object instanceof CommentId) {
            PostComment comment = this.commentRepo.getById((CommentId)referenceId);
            Post post2 = this.postRepo.getByIdAndDeletedFalse(comment.getPostId());
            authContext.checkPostCommentAction(post2.getChannelId(), comment, PostCommentAction.COMMENT);
            post = post2;
        } else if (object instanceof PostId) {
            Post post3 = this.postRepo.getByIdAndDeletedFalse((PostId)referenceId);
            authContext.checkPostAction(post3, PostAction.COMMENT);
            post = post3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Post post4 = post;
        if (post4.getCommentsDisabled()) {
            throw new PostCommentsAreDisabledException(null, 1, null);
        }
        if (!(text != null || !((object = (Collection)attachmentIds) == null || object.isEmpty()))) {
            boolean $i$a$-require-PostCommentService$createComment$22 = false;
            String $i$a$-require-PostCommentService$createComment$22 = "A Comment needs to contain either text or images";
            throw new IllegalArgumentException($i$a$-require-PostCommentService$createComment$22.toString());
        }
        List list = attachmentIds;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List nonNullAttachmentIds = list;
        CommentId commentId = CommentId.Companion.random();
        Instant now = Instant.now();
        CommentableId commentableId2 = referenceId;
        if (commentableId2 instanceof CommentId) {
            PostComment respondedComment = this.commentRepo.getById((CommentId)referenceId);
            commentableId = Intrinsics.areEqual((Object)respondedComment.getParentId(), (Object)post4.getId()) ? (CommentableId)respondedComment.getId() : respondedComment.getParentId();
        } else if (commentableId2 instanceof PostId) {
            commentableId = (CommentableId)post4.getId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        CommentableId parentId = commentableId;
        commentableId2 = this.commentRepo;
        PostId postId = post4.getId();
        ProfileId profileId = authContext.getUser();
        CommentTextInput commentTextInput = text;
        String string = commentTextInput != null ? commentTextInput.getPlainText() : null;
        CommentTextInput commentTextInput2 = text;
        String string2 = commentTextInput2 != null ? commentTextInput2.getJsonContent() : null;
        Intrinsics.checkNotNull((Object)now);
        Instant instant = now;
        Instant instant2 = now;
        ProfileId profileId2 = authContext.getUser();
        commentableId2.insert(commentId, postId, (ItemId)parentId, (ItemId)referenceId, profileId, instant, instant2, profileId2, string2, string);
        PostComment comment = this.commentRepo.getById(commentId);
        if (!((Collection)nonNullAttachmentIds).isEmpty()) {
            this.addAttachments(nonNullAttachmentIds, comment, authContext);
        }
        CommentTextInput commentTextInput3 = text;
        this.eventPublisher.publishEvent((ApplicationEvent)new PostCommentCreatedEvent(post4.getId(), parentId, commentTextInput3 != null ? commentTextInput3.getJsonContent() : null, authContext.getUser(), authContext.getTenantId()));
        return this.postCommentTranslationService.translate(comment, targetLanguage, authContext.getTenantId());
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public PostComment update(@NotNull CommentId id, @Nullable List<DocumentId> attachmentIds, @Nullable CommentTextInput text, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        PostComment update;
        block12: {
            void $this$filterTo$iv$iv;
            Object element$iv$iv;
            Iterable $this$filterTo$iv$iv2;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Object object;
            Object object2;
            Object object3;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
            PostComment origin = this.commentRepo.getById(id);
            Post post = this.postRepo.getByIdAndDeletedFalse(origin.getPostId());
            authContext.checkPostCommentAction(post.getChannelId(), origin, PostCommentAction.EDIT);
            if (!(text != null || !((object3 = (CharSequence)origin.getText()) == null || object3.length() == 0) || !((object3 = (Collection)attachmentIds) == null || object3.isEmpty()))) {
                boolean bl = false;
                String string = "A Comment update needs to contain either text or images";
                throw new IllegalArgumentException(string.toString());
            }
            Object object4 = text;
            if (object4 == null || (object4 = object4.getPlainText()) == null) {
                object4 = object2 = origin.getText();
            }
            if ((object = text) == null || (object = object.getJsonContent()) == null) {
                object = origin.getJsonContent();
            }
            Object object5 = object;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = instant;
            ProfileId profileId = authContext.getUser();
            String string = text == null ? origin.getSourceLanguage() : null;
            update = PostComment.copy$default((PostComment)origin, null, null, null, null, null, null, (Instant)instant2, (ProfileId)profileId, (String)object5, (String)object2, (boolean)false, null, null, (String)string, null, (int)23615, null);
            this.commentRepo.save((Object)update);
            CommentTextInput commentTextInput = text;
            if (commentTextInput != null) {
                CommentTextInput it = commentTextInput;
                boolean bl = false;
                this.postCommentTranslationService.deleteTranslations(origin);
                Set originMentions = QuillUtils.INSTANCE.extractMentions(origin.getJsonContent());
                Set updateMentions = QuillUtils.INSTANCE.extractMentions(update.getJsonContent());
                Set newMentions = CollectionsKt.subtract((Iterable)updateMentions, (Iterable)originMentions);
                if (!((Collection)newMentions).isEmpty()) {
                    this.eventPublisher.publishEvent((ApplicationEvent)new PostCommentUpdatedMentionsEvent(update.getPostId(), authContext.getTenantId(), (Collection)newMentions));
                }
            }
            List<DocumentId> list = attachmentIds;
            if (list == null) break block12;
            List<DocumentId> updateAttachments = list;
            boolean bl = false;
            List originAttachments = this.attachmentRepo.findAllByItemIdOrderByPosition((DriveFileReferenceId)id);
            Iterable $this$map$iv = originAttachments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void it;
                Attachment attachment = (Attachment)item$iv$iv2;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getId());
            }
            List originAttachmentIds = (List)destination$iv$iv;
            Iterable $this$filter$iv = originAttachmentIds;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            item$iv$iv2 = $this$filterTo$iv$iv2.iterator();
            while (item$iv$iv2.hasNext()) {
                element$iv$iv = item$iv$iv2.next();
                DocumentId it = (DocumentId)element$iv$iv;
                boolean bl3 = false;
                if (!(!attachmentIds.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List toDelete = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = toDelete;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DocumentId it = (DocumentId)element$iv;
                boolean bl4 = false;
                this.driveApiConnector.deleteFile(it, authContext.getUser());
            }
            this.attachmentRepo.deleteAllById((Iterable)toDelete);
            $this$filter$iv = attachmentIds;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            Object bl4 = $this$filterTo$iv$iv2.iterator();
            while (bl4.hasNext()) {
                element$iv$iv = bl4.next();
                DocumentId it = (DocumentId)element$iv$iv;
                boolean bl5 = false;
                if (!(!toDelete.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List remainingAttachmentsIds = (List)destination$iv$iv2;
            boolean bl6 = false;
            Iterable $this$filter$iv2 = remainingAttachmentsIds;
            boolean $i$f$filter2 = false;
            bl4 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                DocumentId it = (DocumentId)element$iv$iv2;
                boolean bl7 = false;
                if (!(!originAttachmentIds.contains(it))) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            List newAttachmentsToAdd = (List)destination$iv$iv3;
            this.addAttachments(newAttachmentsToAdd, update, authContext);
            Iterable $this$forEachIndexed$iv = remainingAttachmentsIds;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void documentId;
                int n;
                Object element$iv$iv2;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv2 = (DocumentId)item$iv;
                int index = n;
                boolean bl8 = false;
                this.attachmentRepo.updatePosition((DocumentId)documentId, index);
            }
        }
        return this.postCommentTranslationService.translate(update, targetLanguage, authContext.getTenantId());
    }

    public static /* synthetic */ PostComment update$default(PostCommentService postCommentService, CommentId commentId, List list, CommentTextInput commentTextInput, String string, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            commentTextInput = null;
        }
        return postCommentService.update(commentId, list, commentTextInput, string, authorizationContext);
    }

    @Nullable
    public PostComment findById(@NotNull CommentId id, @NotNull AuthorizationContext authContext, @Nullable String targetLanguage) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PostComment postComment = (PostComment)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.commentRepo), (Object)id);
        if (postComment == null) {
            return null;
        }
        PostComment comment = postComment;
        authContext.checkRead((ItemId)comment.getPostId());
        return this.postCommentTranslationService.translate(comment, targetLanguage, authContext.getTenantId());
    }

    public static /* synthetic */ PostComment findById$default(PostCommentService postCommentService, CommentId commentId, AuthorizationContext authorizationContext, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findById");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return postCommentService.findById(commentId, authorizationContext, string);
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public List<PostComment> getDirectComments(@NotNull PostId postId, @NotNull Sort sort, @Nullable String targetLanguage, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (this.postRepo.getByIdAndDeletedFalse(postId).getCommentsDisabled()) {
            return CollectionsKt.emptyList();
        }
        List comments = switch (WhenMappings.$EnumSwitchMapping$0[sort.ordinal()]) {
            case 1 -> this.commentRepo.findAllByParentIdOrderByCreatedAtAsc((ItemId)postId);
            case 2 -> this.commentRepo.findAllByParentIdOrderByCreatedAtDesc((ItemId)postId);
            default -> throw new NoWhenBranchMatchedException();
        };
        Iterable $this$map$iv = comments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PostComment postComment = (PostComment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.postCommentTranslationService.translate((PostComment)it, targetLanguage, tenantId));
        }
        return (List)destination$iv$iv;
    }

    @Unauthorized
    @NotNull
    public List<PostComment> findAllByIds(@NotNull List<CommentId> commentIds) {
        Intrinsics.checkNotNullParameter(commentIds, (String)"commentIds");
        Iterable iterable = this.commentRepo.findAllById((Iterable)commentIds);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"findAllById(...)");
        Iterable $this$sortedBy$iv = iterable;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new findAllByIds$$inlined$sortedBy$1(commentIds)));
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<CommentableId, List<PostComment>> getByParentIds(@NotNull List<? extends CommentableId> parentIds, @NotNull Sort sort, @Nullable String targetLanguage, @NotNull TenantId tenantId) {
        CommentableId it;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (parentIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable iterable = sort == Sort.ASC ? this.commentRepo.findAllByParentIdInOrderByCreatedAtAsc((Collection)parentIds) : this.commentRepo.findAllByParentIdInOrderByCreatedAtDesc((Collection)parentIds);
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PostComment postComment = (PostComment)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.postCommentTranslationService.translate((PostComment)it, targetLanguage, tenantId));
        }
        List comments = (List)destination$iv$iv;
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            it = (CommentableId)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = comments;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void id;
                PostComment it2 = (PostComment)element$iv$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getParentId(), (Object)id)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            object.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Unauthorized
    @NotNull
    public Map<PostId, Integer> getCommentCount(@NotNull Set<PostId> postIds) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        Iterable $this$associate$iv = this.commentRepo.countByPostIds(postIds);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Pair it = (Pair)element$iv$iv2;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map counts = destination$iv$iv;
        Iterable $this$associateWith$iv = postIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Object element$iv$iv2;
            element$iv$iv2 = (PostId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = ((Number)counts.getOrDefault(it, 0)).intValue();
            map.put(t, n);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private void addAttachments(List<DocumentId> attachmentIds, PostComment comment, AuthorizationContext authContext) {
        void $this$forEachIndexed$iv;
        Iterable iterable = this.driveApiConnector.addFiles(attachmentIds, (DriveFileReferenceId)comment.getId(), authContext.getUser());
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void attachment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DriveDocument driveDocument = (DriveDocument)item$iv;
            int index = n;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)attachment.getMimeType(), (String)"image/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)attachment.getMimeType(), (String)"video/", (boolean)false, (int)2, null))) {
                boolean bl2 = false;
                throw new CommentWrongMimeTypeException("Only image or video types are allowed");
            }
            this.attachmentRepo.insert(attachment.getDocumentId(), (DriveFileReferenceId)comment.getId(), attachment.getMimeType(), attachment.getName(), attachment.getSize(), index, null);
        }
        this.transactionSupport.afterCommit(() -> PostCommentService.addAttachments$lambda$20(this, comment, authContext));
    }

    private static final Unit addAttachments$lambda$20(PostCommentService this$0, PostComment $comment, AuthorizationContext $authContext) {
        DriveKafkaProducer driveKafkaProducer = new DriveKafkaProducer[]{this$0.permissionKafkaProducer.publishComment($comment.getId(), $comment.getPostId()), this$0.permissionKafkaProducer.publishPermission(new PermissionItem((ItemId)$comment.getId(), (UserId)$authContext.getUser(), PermissionRole.MANAGER))};
        KafkaPublishOperation.waitForCompletion$default((KafkaPublishOperation)new KafkaPublishOperation((KafkaPublishOperation[])driveKafkaProducer), null, (int)1, null);
        driveKafkaProducer = this$0.driveKafkaProducer;
        CommentId commentId = $comment.getId();
        String string = $comment.getText();
        TenantId tenantId = $authContext.getTenantId();
        driveKafkaProducer.publishComment(commentId, tenantId, string);
        return Unit.INSTANCE;
    }
}

