/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.service;

import de.justsoftware.mobile.gateway.common.service.UrlService;
import de.justsoftware.mobile.gateway.exception.InvalidWikiIdType;
import de.justsoftware.mobile.gateway.util.ListsKt;
import de.justsoftware.mobile.gateway.util.NumbersKt;
import de.justsoftware.mobile.gateway.wiki.generated.apis.WikiControllerApi;
import de.justsoftware.mobile.gateway.wiki.generated.models.ArticleDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.ChapterDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.Direction;
import de.justsoftware.mobile.gateway.wiki.generated.models.Sort;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslationMetaDataArticleDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslationMetaDataChapterDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslationMetaDataWikiDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.UpdateSubscriptionDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.WikiDto;
import de.justsoftware.mobile.gateway.wiki.model.LinkValidationResult;
import de.justsoftware.mobile.gateway.wiki.model.ParentTitle;
import de.justsoftware.mobile.gateway.wiki.model.Subscription;
import de.justsoftware.mobile.gateway.wiki.model.Wiki;
import de.justsoftware.mobile.gateway.wiki.model.WikiArticle;
import de.justsoftware.mobile.gateway.wiki.model.WikiChapter;
import de.justsoftware.mobile.gateway.wiki.model.WikiIdType;
import de.justsoftware.mobile.gateway.wiki.model.WikiIdTypeKt;
import de.justsoftware.mobile.gateway.wiki.model.WikiItem;
import de.justsoftware.mobile.gateway.wiki.service.WikiService;
import de.justsoftware.mobile.gateway.wiki.service.WikiService$getSubscribedWikiItems$;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0016J\u0016\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&H\u0016J\u001a\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lde/justsoftware/mobile/gateway/wiki/service/WikiService;", "", "urlService", "Lde/justsoftware/mobile/gateway/common/service/UrlService;", "wikiBaseUrl", "", "commonRequestInitializer", "Lorg/springframework/http/client/ClientHttpRequestInitializer;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Lde/justsoftware/mobile/gateway/common/service/UrlService;Ljava/lang/String;Lorg/springframework/http/client/ClientHttpRequestInitializer;Lorg/springframework/web/client/RestClient$Builder;)V", "wikiControllerApi", "Lde/justsoftware/mobile/gateway/wiki/generated/apis/WikiControllerApi;", "getWikiTeasers", "", "Lde/justsoftware/mobile/gateway/wiki/model/WikiItem;", "offset", "", "limit", "getSubscribedWikiItems", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/model/Wiki;", "wikiId", "translationLanguage", "updateSubscription", "Lde/justsoftware/mobile/gateway/wiki/model/Subscription;", "isSubscribed", "", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/model/WikiChapter;", "chapterId", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/WikiArticle;", "articleId", "validateInternalLinks", "Lde/justsoftware/mobile/gateway/wiki/model/LinkValidationResult;", "linkIds", "", "getParentTitle", "Lde/justsoftware/mobile/gateway/wiki/model/ParentTitle;", "wikiItemId", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nWikiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiService.kt\nde/justsoftware/mobile/gateway/wiki/service/WikiService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1056#2:210\n1#3:211\n*S KotlinDebug\n*F\n+ 1 WikiService.kt\nde/justsoftware/mobile/gateway/wiki/service/WikiService\n*L\n75#1:210\n*E\n"})
public class WikiService {
    @NotNull
    private final UrlService urlService;
    @NotNull
    private final WikiControllerApi wikiControllerApi;

    public WikiService(@NotNull UrlService urlService, @Value(value="${just.wiki.baseUrl}") @NotNull String wikiBaseUrl, @Qualifier(value="commonRequestInitializer") @NotNull ClientHttpRequestInitializer commonRequestInitializer, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)urlService, (String)"urlService");
        Intrinsics.checkNotNullParameter((Object)wikiBaseUrl, (String)"wikiBaseUrl");
        Intrinsics.checkNotNullParameter((Object)commonRequestInitializer, (String)"commonRequestInitializer");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        this.urlService = urlService;
        RestClient restClient = restClientBuilder.requestInitializer(commonRequestInitializer).baseUrl(wikiBaseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        RestClient restClient2 = restClient;
        this.wikiControllerApi = new WikiControllerApi(restClient2);
    }

    @NotNull
    public List<WikiItem> getWikiTeasers(int offset, int limit) {
        return WikiItem.Companion.WikiPreviewDtosToWikiItems(WikiControllerApi.getWikiPreviews$default((WikiControllerApi)this.wikiControllerApi, (Integer)(limit > 0 ? NumbersKt.ceilDiv((int)offset, (int)limit) : 0), (Integer)limit, (Sort)Sort.SUBSCRIBED, (Direction)Direction.DESCENDING, null, (int)16, null).getContent());
    }

    @NotNull
    public List<WikiItem> getSubscribedWikiItems(int offset, int limit) {
        Iterable $this$sortedBy$iv = WikiControllerApi.getSubscribedItems$default((WikiControllerApi)this.wikiControllerApi, null, (Integer)200, null, (int)5, null).getContent();
        boolean $i$f$sortedBy = false;
        return WikiItem.Companion.TranslatablePageDtoPreviewDtoObjectContentInnerToWikiItems(ListsKt.page((List)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new getSubscribedWikiItems$$inlined$sortedBy$1())), (int)offset, (int)limit));
    }

    @NotNull
    public Wiki getWiki(@NotNull String wikiId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return (Wiki)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public Subscription updateSubscription(@NotNull String wikiId, boolean isSubscribed) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return Subscription.Companion.toSubscription(this.wikiControllerApi.createOrUpdateSubscription(new UpdateSubscriptionDto(isSubscribed, wikiId)));
    }

    @NotNull
    public WikiChapter getWikiChapter(@NotNull String chapterId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        ChapterDto chapterDto = this.wikiControllerApi.getChapter(chapterId, translationLanguage);
        ParentTitle parentTitle = this.getParentTitle(chapterDto.getParentId(), translationLanguage);
        return WikiChapter.Companion.toWikiChapter(chapterDto, parentTitle, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public WikiArticle getWikiArticle(@NotNull String articleId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        ArticleDto articleDto = WikiControllerApi.getArticle$default((WikiControllerApi)this.wikiControllerApi, (String)articleId, null, (String)translationLanguage, (int)2, null);
        ParentTitle parentTitle = this.getParentTitle(articleDto.getParentId(), translationLanguage);
        return WikiArticle.Companion.toWikiArticle(articleDto, parentTitle, (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public LinkValidationResult validateInternalLinks(@NotNull Set<String> linkIds) {
        Intrinsics.checkNotNullParameter(linkIds, (String)"linkIds");
        Map p0 = this.wikiControllerApi.getLinkStatus(linkIds);
        boolean bl = false;
        return new LinkValidationResult(p0);
    }

    private ParentTitle getParentTitle(String wikiItemId, String translationLanguage) {
        WikiIdType wikiIdType = WikiIdTypeKt.getWikiIdType((String)wikiItemId);
        return switch (wikiIdType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[wikiIdType.ordinal()]) {
            case 1 -> {
                TranslationMetaDataWikiDto v2;
                WikiDto wikiDto = this.wikiControllerApi.getWiki(wikiItemId, translationLanguage);
                boolean $i$a$-let-WikiService$getParentTitle$1 = false;
                yield new ParentTitle(wikiDto.getTitle(), (v2 = wikiDto.getTranslationMetaData()) != null && (v2 = v2.getSourceData()) != null ? v2.getTitle() : null);
            }
            case 2 -> {
                TranslationMetaDataChapterDto v3;
                ChapterDto chapterDto = this.wikiControllerApi.getChapter(wikiItemId, translationLanguage);
                boolean $i$a$-let-WikiService$getParentTitle$2 = false;
                yield new ParentTitle(chapterDto.getTitle(), (v3 = chapterDto.getTranslationMetaData()) != null && (v3 = v3.getSourceData()) != null ? v3.getTitle() : null);
            }
            case 3 -> {
                TranslationMetaDataArticleDto v4;
                ArticleDto articleDto = WikiControllerApi.getArticle$default((WikiControllerApi)this.wikiControllerApi, (String)wikiItemId, null, (String)translationLanguage, (int)2, null);
                boolean $i$a$-let-WikiService$getParentTitle$3 = false;
                yield new ParentTitle(articleDto.getTitle(), (v4 = articleDto.getTranslationMetaData()) != null && (v4 = v4.getSourceData()) != null ? v4.getTitle() : null);
            }
            case -1 -> throw new InvalidWikiIdType(wikiItemId);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ WikiControllerApi access$getWikiControllerApi$p(WikiService $this) {
        return $this.wikiControllerApi;
    }

    public static final /* synthetic */ UrlService access$getUrlService$p(WikiService $this) {
        return $this.urlService;
    }
}

