/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.service;

import de.justsoftware.mobile.gateway.notification.model.ChangeList;
import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.model.NotificationsCount;
import de.justsoftware.mobile.gateway.notification.model.PushToken;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$archiveNotification$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$getChanges$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$getNotification$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$getNotifications$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$openNotifications$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$registerAndroid$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$registerIos$;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService$unregisterPushToken$;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0016\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0016J\u0012\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010+\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0012J\u0010\u0010,\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0003H\u0012J\u0010\u0010-\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0003H\u0012J\u0018\u0010.\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0012J\u001c\u0010/\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0012J$\u00100\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0012J\u0018\u00101\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0012J\u0012\u00102\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0012R\u0010\u0010\u0002\u001a\u00020\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;", "", "notificationApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "archiveAllNotificationsUri", "Ljava/net/URI;", "notificationsCountUri", "openNotificationsUri", "getNotifications", "", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "status", "limit", "", "before", "getNotification", "notificationId", "getNotificationsCount", "Lde/justsoftware/mobile/gateway/notification/model/NotificationsCount;", "archiveAllNotifications", "archiveNotification", "", "openNotifications", "notificationIds", "markNotification", "action", "registerAndroid", "Lde/justsoftware/mobile/gateway/notification/model/PushToken;", "pushToken", "publicKey", "mobilePlatformVersion", "registerIos", "silenceAlerts", "", "unregisterPushToken", "mobilePlatform", "getChanges", "Lde/justsoftware/mobile/gateway/notification/model/ChangeList;", "token", "notificationsUri", "notificationUri", "archiveNotificationUri", "markNotificationUri", "registerAndroidUri", "registerIosUri", "unregisterPushTokenUri", "changesUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nNotificationApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n48#2:160\n48#2:161\n48#2:162\n82#2:163\n82#2:164\n88#2:165\n82#2:166\n60#2:167\n60#2:168\n91#2:169\n48#2:170\n1#3:171\n*S KotlinDebug\n*F\n+ 1 NotificationApiGatewayService.kt\nde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService\n*L\n31#1:160\n40#1:161\n43#1:162\n46#1:163\n49#1:164\n53#1:165\n63#1:166\n76#1:167\n84#1:168\n90#1:169\n99#1:170\n*E\n"})
public class NotificationApiGatewayService {
    @Value(value="${just.notification.api.url}")
    @NotNull
    private final String notificationApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI archiveAllNotificationsUri;
    @NotNull
    private final URI notificationsCountUri;
    @NotNull
    private final URI openNotificationsUri;

    public NotificationApiGatewayService(@Value(value="${just.notification.api.url}") @NotNull String notificationApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)notificationApiUrl, (String)"notificationApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.notificationApiUrl = notificationApiUrl;
        this.webClient = webClient;
        this.archiveAllNotificationsUri = UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/archive"), null, null, (int)6, null);
        this.notificationsCountUri = UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/count"), null, null, (int)6, null);
        this.openNotificationsUri = UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/open"), null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Notification> getNotifications(@NotNull String status, int limit, @NotNull String before) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        WebClient webClient = this.webClient;
        URI uRI = this.notificationsUri(status, limit, before);
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getNotifications$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Notification getNotification(@NotNull String notificationId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.notificationUri(notificationId);
        boolean $i$f$get = false;
        return (Notification)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getNotification$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NotificationsCount getNotificationsCount() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.notificationsCountUri;
        boolean $i$f$get = false;
        return (NotificationsCount)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> archiveAllNotifications() {
        void $this$put$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveAllNotificationsUri;
        boolean $i$f$put = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void archiveNotification(@NotNull String notificationId) {
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.archiveNotificationUri(notificationId);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new archiveNotification$$inlined$put$1((WebClient)$this$put$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void openNotifications(@NotNull List<String> notificationIds) {
        void body$iv;
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        WebClient webClient = this.webClient;
        URI uRI = this.openNotificationsUri;
        List<String> list = notificationIds;
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new openNotifications$$inlined$put$1((WebClient)$this$put$iv, (URI)uri$iv, (Object)body$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void markNotification(@NotNull String notificationId, @NotNull String action) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        WebClient webClient = this.webClient;
        URI uRI = this.markNotificationUri(notificationId, action);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PushToken registerAndroid(@NotNull String pushToken, @Nullable String publicKey, @Nullable String mobilePlatformVersion) {
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uRI = this.registerAndroidUri(publicKey, mobilePlatformVersion);
        String body$iv = pushToken;
        boolean $i$f$post = false;
        return (PushToken)BuildersKt.runBlocking$default(null, (Function2)((Function2)new registerAndroid$$inlined$post$1((WebClient)$this$post$iv, (URI)uri$iv, (Object)body$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PushToken registerIos(@NotNull String pushToken, @Nullable String publicKey, boolean silenceAlerts, @Nullable String mobilePlatformVersion) {
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uRI = this.registerIosUri(publicKey, silenceAlerts, mobilePlatformVersion);
        String body$iv = pushToken;
        boolean $i$f$post = false;
        return (PushToken)BuildersKt.runBlocking$default(null, (Function2)((Function2)new registerIos$$inlined$post$1((WebClient)$this$post$iv, (URI)uri$iv, (Object)body$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterPushToken(@NotNull String mobilePlatform, @NotNull String pushToken) {
        void uri$iv;
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        WebClient webClient = this.webClient;
        URI uRI = this.unregisterPushTokenUri(mobilePlatform, pushToken);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new unregisterPushToken$$inlined$delete$1((WebClient)$this$delete$iv, (URI)uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ChangeList getChanges(@Nullable String token) {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.changesUri(token);
        boolean $i$f$get = false;
        return (ChangeList)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getChanges$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null);
    }

    private URI notificationsUri(String status, int limit, String before) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"status", (Object)status), TuplesKt.to((Object)"limit", (Object)limit), TuplesKt.to((Object)"before", (Object)before)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/mobile/notifications"), (Map)params, null, (int)4, null);
    }

    private URI notificationUri(String notificationId) {
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/mobile/notifications/" + notificationId), null, null, (int)6, null);
    }

    private URI archiveNotificationUri(String notificationId) {
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/archive/" + notificationId), null, null, (int)6, null);
    }

    private URI markNotificationUri(String notificationId, String action) {
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/notification/" + notificationId + "/" + action), null, null, (int)6, null);
    }

    private URI registerAndroidUri(String publicKey, String mobilePlatformVersion) {
        String it;
        Map map;
        Map $this$registerAndroidUri_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        String string = publicKey;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$registerAndroidUri_u24lambda_u242.put("publicKey", it);
        }
        String string2 = mobilePlatformVersion;
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$registerAndroidUri_u24lambda_u242.put("mobilePlatformVersion", it);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/mobilepush/android"), (Map)params, null, (int)4, null);
    }

    private URI registerIosUri(String publicKey, boolean silenceAlerts, String mobilePlatformVersion) {
        String it;
        Map map;
        Map $this$registerIosUri_u24lambda_u245 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$registerIosUri_u24lambda_u245.put("silenceAlerts", silenceAlerts);
        String string = publicKey;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$registerIosUri_u24lambda_u245.put("publicKey", it);
        }
        String string2 = mobilePlatformVersion;
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$registerIosUri_u24lambda_u245.put("mobilePlatformVersion", it);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/mobilepush/ios"), (Map)params, null, (int)4, null);
    }

    private URI unregisterPushTokenUri(String mobilePlatform, String pushToken) {
        return UrisKt.buildUri$default((String)(this.notificationApiUrl + "/mobilepush/" + mobilePlatform + "/" + pushToken), null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private URI changesUri(String token) {
        Map map;
        Map map2;
        String string = this.notificationApiUrl + "/mobile/changes";
        String string2 = token;
        if (string2 != null) {
            void token2;
            String string3 = string2;
            String string4 = string;
            boolean bl = false;
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"token", (Object)token2));
            string = string4;
        } else {
            map2 = map = null;
        }
        if (map2 == null) {
            map = MapsKt.emptyMap();
        }
        return UrisKt.buildUri$default((String)string, (Map)map, null, (int)4, null);
    }
}

