/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.resolver;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import de.justsoftware.justimport.business.UserGroupImportConfig;
import de.justsoftware.justimport.domain.JustLdapUtils;
import de.justsoftware.justimport.domain.impl.resolver.MembersLookupResult;
import de.justsoftware.justimport.domain.model.common.ExternalIdField;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupImportModel;
import de.justsoftware.justimport.domain.profile.ldap.LdapProfile;
import de.justsoftware.justimport.domain.profile.ldap.LdapProfileRepository;
import de.justsoftware.justimport.domain.resolver.LdapQueryResolver;
import de.justsoftware.justimport.domain.usergroup.ldap.LdapUserGroup;
import de.justsoftware.justimport.domain.usergroup.ldap.LdapUserGroupRepository;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class LdapQueryResolverImpl
implements LdapQueryResolver {
    private static final Logger LOG = LoggerFactory.getLogger(LdapQueryResolverImpl.class);
    private final Map<Name, LdapProfile> _profileCache = new HashMap();
    private final LdapUserGroupRepository _userGroupRepository;
    private final LdapProfileRepository _profileRepository;
    private final Function<LdapUserGroup, Optional<String>> _externalIdSupplier;
    private final UserGroupImportConfig _config;
    private final LdapTemplate _template;
    private final ContextMapper<MembersLookupResult> _memberContextMapper;

    @Autowired
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="we want exception to be thrown")
    public LdapQueryResolverImpl(LdapUserGroupRepository userGroupRepository, LdapProfileRepository profileRepository, UserGroupImportConfig importConfig, LdapTemplate template) {
        this._userGroupRepository = userGroupRepository;
        this._profileRepository = profileRepository;
        this._config = importConfig;
        this._template = template;
        this._externalIdSupplier = LdapUserGroup.externalIdAccessor((ExternalIdField)new ExternalIdField(importConfig.getExternalIdAttribute(), importConfig.getExternalIdIsGUID()));
        this._memberContextMapper = ctx -> {
            DirContextAdapter context = (DirContextAdapter)ctx;
            return new MembersLookupResult(JustLdapUtils.normalizeDn((Name)context.getDn(), (Name)JustLdapUtils.determineLdapBase((LdapTemplate)template)), context.getStringAttributes(importConfig.getMemberAttribute()));
        };
    }

    @Nonnull
    public final Stream<UserGroupImportModel> getImportModels() {
        Iterable topLevelGroups = this.findTopLevelGroups();
        Stream members = this.findGroupMembers(topLevelGroups);
        this._profileCache.clear();
        return members;
    }

    @Nonnull
    private Iterable<LdapUserGroup> findTopLevelGroups() {
        Name searchBaseDn = this._config.getUserGroupSearchBaseDn();
        String filter = this._config.getFilter();
        if (Strings.isNullOrEmpty((String)filter) && searchBaseDn.isEmpty()) {
            return this._userGroupRepository.findAll();
        }
        LdapQueryBuilder query = LdapQueryBuilder.query();
        if (!searchBaseDn.isEmpty()) {
            query.base(searchBaseDn);
        }
        if (Strings.isNullOrEmpty((String)filter)) {
            throw new IllegalArgumentException("You must always use searchBaseDn and filter together! No filter defined.");
        }
        query.filter(filter);
        return this._userGroupRepository.findAll((LdapQuery)query);
    }

    @Nonnull
    private Stream<UserGroupImportModel> findGroupMembers(Iterable<LdapUserGroup> topLevelGroups) {
        return Streams.stream(topLevelGroups).map(ldapGroup -> {
            Optional externalId = (Optional)this._externalIdSupplier.apply(ldapGroup);
            return externalId.map(id -> {
                try {
                    Set allMembers = this.getAllMembersWithSubgroups(ldapGroup);
                    return new UserGroupImportModel(id, (String)MoreObjects.firstNonNull((Object)ldapGroup.getDescription(), (Object)ldapGroup.getName()), this.resolveMembers(allMembers));
                }
                catch (InvalidNameException e) {
                    LOG.error("Group name or base are invalid.", (Throwable)e);
                    return null;
                }
            }).orElseGet(() -> {
                LOG.warn("Failed to extract external id of imported ldap group {}. Skipping import.", (Object)ldapGroup.getDn());
                return null;
            });
        }).filter(Objects::nonNull);
    }

    @Nonnull
    private Set<Name> getAllMembersWithSubgroups(LdapUserGroup ldapUserGroup) throws InvalidNameException {
        LdapName base = JustLdapUtils.determineLdapBase((LdapTemplate)this._template);
        Name topLevelName = JustLdapUtils.normalizeDn((Name)ldapUserGroup.getDn(), (Name)base);
        HashSet<Name> personsFound = new HashSet<Name>();
        HashSet<Name> groupsToVisit = new HashSet<Name>(Set.of(topLevelName));
        HashSet<Name> visitedGroups = new HashSet<Name>();
        while (!groupsToVisit.isEmpty()) {
            Name node = (Name)groupsToVisit.stream().findFirst().get();
            if (visitedGroups.contains(node)) {
                groupsToVisit.remove(node);
                continue;
            }
            Set subNodes = this._config.useDirectGroupMembers() ? this.lookupByMember(node) : this.lookupByMemberOf(node);
            personsFound.addAll(this.getPersons(subNodes));
            groupsToVisit.addAll(this.getGroups(subNodes));
            groupsToVisit.remove(node);
            visitedGroups.add(node);
        }
        return personsFound;
    }

    @Nonnull
    private Set<MembersLookupResult> lookupByMember(Name groupDn) {
        LOG.debug("lookupByMember {}", (Object)groupDn);
        Name dn = JustLdapUtils.removeBase((Name)groupDn, (Name)JustLdapUtils.determineLdapBase((LdapTemplate)this._template));
        MembersLookupResult group = (MembersLookupResult)this._template.lookup(dn, this._memberContextMapper);
        return group.getMembers().stream().map(memberDn -> {
            try {
                return (MembersLookupResult)this._template.lookup(memberDn, this._memberContextMapper);
            }
            catch (NameNotFoundException e) {
                LOG.warn("Lookup of member \"{}\" for group \"{}\" failed. Ignoring.", memberDn, (Object)dn);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nonnull
    private Set<MembersLookupResult> lookupByMemberOf(Name groupDn) {
        LOG.debug("lookupByMemberOf {}", (Object)groupDn);
        int pageSize = this._config.getLdapPageSize();
        String memberAttribute = this._config.getMemberAttribute();
        EqualsFilter memberOfFilter = new EqualsFilter(this._config.getMembershipAttribute(), groupDn.toString());
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{"dn", memberAttribute});
        searchControls.setSearchScope(2);
        ArrayList results = new ArrayList();
        if (this._config.getUsePagination()) {
            LOG.info("Importing with pagination and a page size of {}.", (Object)pageSize);
            PagedResultsDirContextProcessor paginator = new PagedResultsDirContextProcessor(pageSize);
            do {
                results.addAll(this._template.search("", memberOfFilter.encode(), searchControls, this._memberContextMapper, (DirContextProcessor)paginator));
            } while (paginator.hasMore());
        } else {
            LOG.info("Importing without pagination");
            results.addAll(this._template.search("", memberOfFilter.encode(), searchControls, this._memberContextMapper));
        }
        return Set.copyOf(results);
    }

    @Nonnull
    private Set<Name> getPersons(Set<MembersLookupResult> members) {
        return members.stream().filter(MembersLookupResult::isPerson).map(MembersLookupResult::getDn).collect(Collectors.toSet());
    }

    @Nonnull
    private Set<Name> getGroups(Set<MembersLookupResult> members) {
        return members.stream().filter(MembersLookupResult::isGroup).map(MembersLookupResult::getDn).collect(Collectors.toSet());
    }

    @Nonnull
    private Set<ExternalId> resolveMembers(Set<Name> members) {
        return members.stream().map(arg_0 -> this.resolveMember(arg_0)).flatMap(Optional::stream).map(LdapProfile::getExternalId).collect(Collectors.toSet());
    }

    @Nonnull
    private Optional<LdapProfile> resolveMember(Name name) {
        if (this._config.getProfileCacheEnabled()) {
            return this.resolvePotentiallyCachedMember(name);
        }
        return this.resolveMemberFromLdap(name);
    }

    @Nonnull
    private Optional<LdapProfile> resolvePotentiallyCachedMember(Name name) {
        LdapProfile cachedProfile = (LdapProfile)this._profileCache.get(name);
        if (cachedProfile != null) {
            return Optional.of(cachedProfile);
        }
        Optional profile = this.resolveMemberFromLdap(name);
        profile.ifPresent(ldapProfile -> this._profileCache.put(name, ldapProfile));
        return profile;
    }

    @Nonnull
    private Optional<LdapProfile> resolveMemberFromLdap(Name name) {
        return this._profileRepository.findById(name, this._config.getExternalIdAttribute());
    }
}

