/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.config;

import de.justsoftware.gateway.config.WebSecurityConfig;
import de.justsoftware.gateway.domain.login.UserLoginRepository;
import de.justsoftware.gateway.security.AddJustTokenHeaderFilter;
import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.EmailToProfileMapper;
import de.justsoftware.gateway.security.JustAuthenticationManager;
import de.justsoftware.gateway.security.JustAuthenticationManagerResolver;
import de.justsoftware.gateway.security.LoginCookieHandler;
import de.justsoftware.gateway.security.PublicApiClientReactiveAuthenticationManager;
import de.justsoftware.gateway.security.ToroOpaqueTokenIntrospector;
import de.justsoftware.gateway.security.oauth2.JustClientRegistrationService;
import de.justsoftware.gateway.security.oauth2.JustOauthLoginAuthenticationEntryPoint;
import de.justsoftware.gateway.security.oauth2.JustServerLogoutSuccessHandler;
import de.justsoftware.jwtfilter.ReactiveJwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.DelegatingServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Configuration
@EnableWebFluxSecurity
@ParametersAreNonnullByDefault
public class WebSecurityConfig {
    private static final String[] UNAUTHORIZED_PATHS = new String[]{"/gateway/config/idps/mobile", "/gateway/images/**", "/gateway/internal/**", "/toro/assets/**", "/toro/www/**", "/toro/font/**", "/toro/rest/heartbeat", "/toro/outdatedBrowser", "/toro/terms", "/toro/privacy", "/toro/imprint", "/toro/help", "/toro/press", "/toro/about", "/toro/articlesOfAssociation", "/toro/registerTenant/**", "/toro/requestActivation", "/toro/requestNewPassword", "/toro/activateAccount/**", "/toro/newMail/**", "/toro/logout", "/toro/swagger-ui.html", "/toro/swagger-ui/**", "/toro/swagger-resources/**", "/toro/v3/api-docs/**", "/toro/resource/i18n**", "/toro/api/v1/i18n/**", "/storageserver/images/ngloginpagelogo/**", "/toro/api/v1/i18n/**", "/toro/api/v1/info/**", "/toro/api/v1/account/unauthorized/**", "/toro/api/v1/theme/global", "/drive/api/unauthenticated/**", "/drive/sync/**", "/drive/s/**", "/toro/external/login/**", "/oauth2/login", "/registration/**", "/account/**", "/about/**", "/just/loggedOut*"};
    private static final String[] ANONYMOUS_PATHS = new String[]{"/login", "/login**", "/toro/login", "/toro/login/**", "/auth/**", "/toro/oauth/**"};
    private static final String[] COOKIE_ONLY_PATHS = new String[]{"/just/*", "/toro/import/csv-upload", "/toro/upload/**", "/toro/export/survey", "/toro/resource/icsexport.ics", "/toro/printPreview/**", "/toro/resource/html", "/toro/api/v1/conversation/message/*/thumbnail", "/drive/api/previews/**", "/drive/api/documents/folder/*/zip", "/drive/api/documents/fileversion/*/download", "/drive/api/documents/*/download", "/people/api/profiles/export", "/chat/swagger-ui/**", "/chat/swagger-resources/**", "/chat/v3/api-docs/**", "/chat/webjars/**", "/public-api/swagger-ui/**", "/public-api/swagger-resources/**", "/public-api/v3/api-docs/**", "/public-api/webjars/**", "/news/rest/event/*/ics-export", "/news/rest/poll/*/csv-export", "/storageserver/images/**", "/monitoring/**", "/toro/config", "/toro/config/**", "/toro/dwr/**"};
    private static final String[] PUBLIC_API_PATHS = new String[]{"/public-api/v1/**"};
    private final JwtVerifier _jwtVerifier;
    private final LoginCookieHandler _loginSuccessHandler;
    private final JustClientRegistrationService _oAuthClientRepository;

    @Autowired
    public WebSecurityConfig(JwtVerifier jwtVerifier, LoginCookieHandler loginSuccessHandler, JustClientRegistrationService oAuthClientRepository) {
        this._jwtVerifier = jwtVerifier;
        this._loginSuccessHandler = loginSuccessHandler;
        this._oAuthClientRepository = oAuthClientRepository;
    }

    @Nonnull
    private static Mono<Void> removeJustCookies(WebFilterExchange exchange, Authentication authentication) {
        LoginCookieHandler.removeJustLoginCookies((ServerWebExchange)exchange.getExchange());
        return Mono.empty();
    }

    @Bean
    @Nonnull
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http, JustAuthenticationManager justAuthenticationManager, ToroOpaqueTokenIntrospector toroOpaqueTokenIntrospector, JustOauthLoginAuthenticationEntryPoint oauthLoginEntryPoint, UserLoginRepository userLoginRepository, EmailToProfileMapper emailToProfileMapper) {
        OrServerWebExchangeMatcher cookieOnlyRequestsMatcher = new OrServerWebExchangeMatcher(Arrays.stream((String[])ArrayUtils.addAll((Object[])COOKIE_ONLY_PATHS, (Object[])ANONYMOUS_PATHS)).map(PathPatternParserServerWebExchangeMatcher::new).collect(Collectors.toList()));
        ReactiveJwtAuthenticationProcessingFilter jwtFilter = new ReactiveJwtAuthenticationProcessingFilter(this._jwtVerifier);
        jwtFilter.applyAllowCookieOnlyVerificationMatcher((ServerWebExchangeMatcher)cookieOnlyRequestsMatcher);
        jwtFilter.applyIgnoreFilterMatcher((ServerWebExchangeMatcher)new OrServerWebExchangeMatcher(Arrays.stream(UNAUTHORIZED_PATHS).map(PathPatternParserServerWebExchangeMatcher::new).collect(Collectors.toList())));
        ProfileCheckingWebfilter profileCheckingFilter = new ProfileCheckingWebfilter(arg_0 -> ((EmailToProfileMapper)emailToProfileMapper).mayLogin(arg_0));
        DelegatingServerAuthenticationSuccessHandler successHandler = new DelegatingServerAuthenticationSuccessHandler(new ServerAuthenticationSuccessHandler[]{this._loginSuccessHandler, new SessionInvalidatingSuccessHandler(), new RedirectServerAuthenticationSuccessHandler()});
        JustAuthenticationManagerResolver authResolver = new JustAuthenticationManagerResolver(arg_0 -> ((JustClientRegistrationService)this._oAuthClientRepository).resolve(arg_0), justAuthenticationManager, toroOpaqueTokenIntrospector);
        NegatedServerWebExchangeMatcher securedPathsMatcher = new NegatedServerWebExchangeMatcher(ServerWebExchangeMatchers.pathMatchers((String[])UNAUTHORIZED_PATHS));
        http.securityMatcher((ServerWebExchangeMatcher)securedPathsMatcher).csrf(ServerHttpSecurity.CsrfSpec::disable).anonymous(Customizer.withDefaults()).authorizeExchange(exchanges -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)exchanges.pathMatchers(ANONYMOUS_PATHS)).permitAll().pathMatchers(PUBLIC_API_PATHS)).access(PublicApiClientReactiveAuthenticationManager.onlyPublicClientAllowed()).anyExchange().access(PublicApiClientReactiveAuthenticationManager.authenticatedButNotPublicClient())).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)oauthLoginEntryPoint)).requestCache(ServerHttpSecurity.RequestCacheSpec::disable).oauth2ResourceServer(resourceServer -> resourceServer.authenticationManagerResolver((ReactiveAuthenticationManagerResolver)authResolver)).oauth2Login(oauth2Login -> oauth2Login.clientRegistrationRepository((ReactiveClientRegistrationRepository)this._oAuthClientRepository).authenticationSuccessHandler((ServerAuthenticationSuccessHandler)successHandler).authenticationFailureHandler((ServerAuthenticationFailureHandler)new ServerAuthenticationEntryPointFailureHandler((ServerAuthenticationEntryPoint)oauthLoginEntryPoint))).logout(logout -> logout.logoutHandler(WebSecurityConfig::removeJustCookies).requiresLogout((ServerWebExchangeMatcher)new OrServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.GET, (String[])new String[]{"/just/logout"}), ServerWebExchangeMatchers.pathMatchers((HttpMethod)HttpMethod.POST, (String[])new String[]{"/just/logout"})})).logoutSuccessHandler((ServerLogoutSuccessHandler)this.getJustServerLogoutSuccessHandler(userLoginRepository))).addFilterBefore((WebFilter)jwtFilter, SecurityWebFiltersOrder.AUTHENTICATION).addFilterAfter((WebFilter)profileCheckingFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        return http.build();
    }

    @Nonnull
    private JustServerLogoutSuccessHandler getJustServerLogoutSuccessHandler(UserLoginRepository userLoginRepository) {
        JustServerLogoutSuccessHandler logoutSuccessHandler = new JustServerLogoutSuccessHandler((ReactiveClientRegistrationRepository)this._oAuthClientRepository, userLoginRepository);
        logoutSuccessHandler.setPostLogoutRedirectUri("{baseUrl}/just/loggedOut");
        return logoutSuccessHandler;
    }

    @Nonnull
    @Bean
    public GlobalFilter justTokenHeaderFilter(AuthenticationToJwtStringConverter converter) {
        return new AddJustTokenHeaderFilter(converter);
    }
}

