/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.item;

import com.google.common.base.MoreObjects;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ItemCreateModel {
    static final int NAME_MAX_LENGTH = 250;
    final ItemId _itemId;
    final String _name;
    @CheckForNull
    final TenantId _tenantId;

    public ItemCreateModel(ItemId itemId, String name, @Nullable TenantId tenantId) {
        this._itemId = itemId;
        this._name = this.limitNameLength(name);
        this._tenantId = tenantId;
    }

    @Nonnull
    private String limitNameLength(String name) {
        if (name.length() > 250) {
            return name.substring(0, 250) + "...";
        }
        return name;
    }

    @Nonnull
    private Object[] equalsToFields() {
        return new Object[]{this._itemId, this._name, this._tenantId};
    }

    public boolean equalTo(ItemCreateModel itemCreateModel) {
        return Arrays.equals(this.equalsToFields(), itemCreateModel.equalsToFields());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("itemId", (Object)this._itemId).add("name", (Object)this._name).add("tenantId", (Object)this._tenantId).toString();
    }
}

