/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.accessrequest.AccessRequestService;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.AuthorizationKey;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.change.ChangeService;
import de.justsoftware.drive.business.event.ItemVisibilitiesChangedEvent;
import de.justsoftware.drive.business.exception.InvalidShareNameTooLongException;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.business.folder.CurrentVersionData;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.business.kafka.NotificationConnector;
import de.justsoftware.drive.business.server.business.PeopleApiConnector;
import de.justsoftware.drive.business.shares.SharesPublisher;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.Roles;
import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.shares.model.ShareBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.common.util.EntryCollectors;
import de.justsoftware.drive.common.util.EntryStream;
import de.justsoftware.drive.persistence.person.PersonDAO;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionDAO;
import de.justsoftware.drive.persistence.sharesubscription.ShareSubscriptionDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SharesServiceImpl
implements SharesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharesServiceImpl.class);
    private static final int MAX_SHARE_NAME_LENGTH = 255;
    private final TransactionSupport _transactionSupport;
    private final ItemReadService _itemReadService;
    private final ItemWriteService _itemWriteService;
    private final ChangeModificationService _changeModificationService;
    private final ChangeService _changeService;
    private final FolderService _folderService;
    private final AccessRequestService _accessRequestService;
    private final EventBus _eventbus;
    private final SharesPublisher _sharesPublisher;
    private final NotificationConnector _notificationConnector;
    private final PeopleApiConnector _peopleApiConnector;
    private final SharePermissionDAO _sharePermissionDAO;
    private final ShareSubscriptionDAO _shareSubscriptionDAO;
    private final PersonDAO _personDAO;

    @Autowired
    public SharesServiceImpl(TransactionSupport transactionSupport, ItemReadService itemReadService, ItemWriteService itemWriteService, ChangeModificationService changeModificationService, ChangeService changeService, FolderService folderService, AccessRequestService accessRequestService, EventBus eventbus, SharesPublisher sharesPublisher, NotificationConnector notificationConnector, PeopleApiConnector peopleApiConnector, SharePermissionDAO sharePermissionDAO, ShareSubscriptionDAO shareSubscriptionDAO, PersonDAO personDAO) {
        this._transactionSupport = transactionSupport;
        this._itemReadService = itemReadService;
        this._itemWriteService = itemWriteService;
        this._changeModificationService = changeModificationService;
        this._changeService = changeService;
        this._folderService = folderService;
        this._accessRequestService = accessRequestService;
        this._eventbus = eventbus;
        this._sharesPublisher = sharesPublisher;
        this._notificationConnector = notificationConnector;
        this._peopleApiConnector = peopleApiConnector;
        this._sharePermissionDAO = sharePermissionDAO;
        this._shareSubscriptionDAO = shareSubscriptionDAO;
        this._personDAO = personDAO;
    }

    public ItemId createShare(AuthorizationContext authCtx, PersonId executor, String name, Map<Role, SharePrivilege> members) {
        TenantId tenantId = authCtx.getNonnullTenantId();
        authCtx.check(Role.writeApp((CoreApp)CoreApp.DRIVE, (UUID)((UUID)tenantId.getId())));
        this.checkShareNameLength(name);
        ItemId shareId = new ItemId(ItemType.SHARE, UUID.randomUUID());
        Role executorRole = executor.asPermissionRole();
        HashMap<Role, SharePrivilege> effectiveMembers = new HashMap<Role, SharePrivilege>(members);
        if (!SharePrivilege.MANAGER.equals((Object)members.get(executorRole))) {
            effectiveMembers.put(executorRole, SharePrivilege.MANAGER);
        }
        ImmutableMap savedMembers = (ImmutableMap)this._transactionSupport.doInTransaction(() -> {
            this._changeModificationService.getOrCreateNewestChange(shareId, executor, null);
            return this.doEditShare(authCtx, shareId, executor, name, (Map)effectiveMembers, (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), tenantId);
        });
        this._sharesPublisher.publishNewShare(shareId, tenantId);
        this._sharesPublisher.publishMemberPermissionChanges(shareId, (Map)savedMembers).waitForOffsets();
        this._eventbus.post((Object)new ItemVisibilitiesChangedEvent(ImmutableSet.of((Object)shareId)));
        return shareId;
    }

    public ImmutableList<ItemBO> getShares(AuthorizationContext authCtx) {
        if (authCtx.isTenantManager()) {
            return (ImmutableList)this._itemReadService.getAllSharesForTenant(authCtx.getNonnullTenantId()).stream().collect(ImmutableList.toImmutableList());
        }
        ImmutableSetMultimap sharesWithRoles = this._sharePermissionDAO.getSharesAccessibleBy((Set)authCtx.getSearchRoles());
        ImmutableSet sharesAccessibleInContext = (ImmutableSet)sharesWithRoles.values().stream().distinct().collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)this._itemReadService.getItems((Set)sharesAccessibleInContext).values().stream().filter(i -> !i.isDeleted()).collect(ImmutableList.toImmutableList());
    }

    public ImmutableMap<ItemId, DocumentId> getRootFolderIds(Set<ItemId> itemIds) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)this.getRootFolderVersions(itemIds), DocumentVersionBO::getDocumentId));
    }

    @Nonnull
    public ImmutableMap<ItemId, FolderVersionBO> getRootFolderVersions(Set<ItemId> itemIds) {
        ImmutableMap changes = this._changeService.getNewestChangePerItem(itemIds);
        ImmutableSet documentVersions = FluentIterable.from((Iterable)changes.values()).transform(ChangeBO::getId).toSet();
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)FluentIterable.from((Iterable)this._folderService.getFolderVersionsByIds((Set)documentVersions).values()).uniqueIndex(DocumentVersionBO::getItemId), (Function)Functions.identity()));
    }

    public void editShare(AuthorizationContext authCtx, ItemId shareId, PersonId executor, String name, Map<Role, SharePrivilege> addedMembers, Map<Role, SharePrivilege> updatedMembers, Set<Role> deletedMembers) {
        TenantId tenantId = authCtx.getNonnullTenantId();
        this.checkShareNameLength(name);
        Map changedMembers = (Map)this._transactionSupport.doInTransaction(() -> this.doEditShare(authCtx, shareId, executor, name, addedMembers, updatedMembers, deletedMembers, tenantId));
        this.updatePendingAccessRequests(addedMembers, shareId);
        this.publishAllMemberChanges(tenantId, shareId, executor, name, addedMembers, changedMembers);
        this._eventbus.post((Object)new ItemVisibilitiesChangedEvent(ImmutableSet.of((Object)shareId)));
    }

    private void publishAllMemberChanges(TenantId tenantId, ItemId shareId, PersonId executor, String shareName, Map<Role, SharePrivilege> addedMembers, Map<Role, Optional<SharePrivilege>> changedMembers) {
        ImmutableSet receiverIds = (ImmutableSet)this.filterPersonIds(addedMembers.keySet()).stream().map(personId -> "PROFILE," + personId.getId()).collect(ImmutableSet.toImmutableSet());
        String executorName = this.getFullProfileName(executor);
        DocumentId rootFolderId = this.getRootFolderId(shareId);
        if (rootFolderId == null) {
            throw new UnknownResourceBusinessException("Did not find rootFolderId for share " + String.valueOf(shareId));
        }
        try {
            this._notificationConnector.sendShareGrantNotification(tenantId, shareName, shareId, rootFolderId, executorName, receiverIds);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error sending notifications for share grant (drive).", (Throwable)e);
        }
        this._sharesPublisher.publishMemberPermissionChanges(shareId, changedMembers).waitForOffsets();
    }

    private void updatePendingAccessRequests(Map<Role, SharePrivilege> addedMembers, ItemId shareId) {
        ImmutableSet addedMemberIds = (ImmutableSet)EntryStream.from(addedMembers).filterKey(Role::isProfileRole).mapKey(Role::getProfileId).filterKey(Optional::isPresent).mapKey(Optional::get).mapKey(PersonId::new).keys().collect(ImmutableSet.toImmutableSet());
        if (!addedMemberIds.isEmpty()) {
            this._accessRequestService.updatePendingRequests((Set)addedMemberIds, shareId);
        }
    }

    private void checkShareNameLength(String name) {
        if (name.length() >= 255) {
            throw new InvalidShareNameTooLongException(String.format("The share name exceeds the maximum amount of %s characters", 255));
        }
    }

    @Nonnull
    private ImmutableMap<Role, Optional<SharePrivilege>> doEditShare(AuthorizationContext authCtx, ItemId shareId, PersonId executor, String name, Map<Role, SharePrivilege> addedMembers, Map<Role, SharePrivilege> updatedMembers, Set<Role> deletedMembers, TenantId tenantId) {
        this.checkMembersToAdd(authCtx, addedMembers, shareId, tenantId);
        ImmutableMap existingPermissions = this._sharePermissionDAO.getPermissions((Set)ImmutableSet.of((Object)shareId)).row((Object)shareId);
        Map membersToUpdate = Maps.filterKeys(updatedMembers, arg_0 -> ((ImmutableMap)existingPermissions).containsKey(arg_0));
        HashMap<Role, SharePrivilege> permissionsToSave = new HashMap<Role, SharePrivilege>((Map<Role, SharePrivilege>)existingPermissions);
        permissionsToSave.putAll(addedMembers);
        permissionsToSave.putAll(membersToUpdate);
        deletedMembers.forEach(permissionsToSave::remove);
        ImmutableSet.Builder changedRoles = ImmutableSet.builder().addAll(addedMembers.keySet()).addAll(membersToUpdate.keySet()).addAll(deletedMembers);
        if (!permissionsToSave.containsValue(SharePrivilege.MANAGER)) {
            permissionsToSave.put(executor.asPermissionRole(), SharePrivilege.MANAGER);
            changedRoles.add((Object)executor.asPermissionRole());
        }
        this._transactionSupport.doInTransaction(() -> {
            this._shareSubscriptionDAO.unsubscribe(shareId, (Set)Roles.toPersonIds((Set)deletedMembers));
            this._itemWriteService.setNames((Map)ImmutableMap.of((Object)shareId, (Object)name.trim()));
            this._itemWriteService.setTenantIdIfNotExists(shareId, tenantId);
            this.savePermissionActions(shareId, (Map)permissionsToSave);
        });
        return (ImmutableMap)changedRoles.build().stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), role -> Optional.ofNullable((SharePrivilege)permissionsToSave.get(role))));
    }

    private void savePermissionActions(ItemId shareId, Map<Role, SharePrivilege> permissionsByAction) {
        ImmutableTable newItemActions = (ImmutableTable)EntryStream.from(permissionsByAction).collect(ImmutableTable.toImmutableTable((java.util.function.Function)Functions.constant((Object)shareId), Map.Entry::getKey, Map.Entry::getValue));
        this._sharePermissionDAO.deletePermissions(shareId);
        this._sharePermissionDAO.setPermission((Table)newItemActions);
    }

    private void checkMembersToAdd(AuthorizationContext authCtx, Map<Role, SharePrivilege> addedMembers, ItemId shareId, TenantId tenantId) {
        Set invalidRoles = addedMembers.keySet().stream().filter(role -> !role.isProfileRole() && !role.isUserGroupRole()).collect(Collectors.toUnmodifiableSet());
        if (!invalidRoles.isEmpty()) {
            LOGGER.error("User tried to add invalid roles as share permissions: {}", invalidRoles);
            throw new PermissionDeniedException("You are not allowed to perform the given action");
        }
        Set rolesToCheck = addedMembers.keySet().stream().map(role -> Role.read((String)role.asString())).collect(Collectors.toUnmodifiableSet());
        Set userIdsAsRoles = addedMembers.keySet().stream().map(role -> Role.create((String)role.asString())).collect(Collectors.toUnmodifiableSet());
        Optional share = this._itemReadService.getItems((Set)ImmutableSet.of((Object)shareId)).values().stream().findFirst();
        if (share.isPresent()) {
            authCtx.checkRead(Role.tenantRead((UUID)((UUID)Objects.requireNonNull(((ItemBO)share.get()).getTenantId()).getId())), userIdsAsRoles);
        } else {
            authCtx.checkRead(Role.tenantRead((UUID)((UUID)tenantId.getId())), userIdsAsRoles);
        }
        authCtx.check(rolesToCheck);
    }

    @Nonnull
    public ShareBO getShareDetails(ItemId shareId) {
        ItemBO item = (ItemBO)this._itemReadService.getItems((Set)ImmutableSet.of((Object)shareId)).get((Object)shareId);
        if (item == null) {
            throw new PermissionDeniedException(String.valueOf(shareId) + " does not denote an existing Share");
        }
        ImmutableTable permissions = this._sharePermissionDAO.getPermissions((Set)ImmutableSet.of((Object)shareId));
        ImmutableMap members = permissions.row((Object)shareId);
        return new ShareBO(item.getId(), item.getName(), members);
    }

    public ShareBO getShareDetails(ItemId shareId, AuthorizationContext authCtx) {
        if (shareId.getType() != ItemType.SHARE) {
            throw new PermissionDeniedException(String.valueOf(shareId) + " does not denote a Share");
        }
        authCtx.check((AbstractId)shareId, StaticAction.DOCUMENT_READ);
        return this.getShareDetails(shareId);
    }

    @Nonnull
    public ItemBO getShare(ItemId shareId, AuthorizationContext authCtx) {
        authCtx.check((AbstractId)shareId, StaticAction.DOCUMENT_READ);
        ItemBO share = (ItemBO)this._itemReadService.getItems((Set)ImmutableSet.of((Object)shareId)).get((Object)shareId);
        if (share == null) {
            throw new UnknownResourceBusinessException("Share not found:" + String.valueOf(shareId));
        }
        return share;
    }

    public ImmutableSet<AccessRequestBO> getPendingAccessRequestsForShare(ItemId shareId, AuthorizationContext authCtx) {
        authCtx.check((AbstractId)shareId, StaticAction.SHARE_MANAGE);
        return this._accessRequestService.getPendingRequestsForShare(shareId);
    }

    public void rejectAccessRequests(Set<Role> roles, ItemId shareId, AuthorizationContext authCtx) {
        authCtx.check((AbstractId)shareId, StaticAction.SHARE_MANAGE);
        ImmutableSet personIds = (ImmutableSet)roles.stream().filter(role -> role.getProfileId().isPresent()).map(profileRole -> (Long)profileRole.getProfileId().get()).map(PersonId::new).collect(ImmutableSet.toImmutableSet());
        this._accessRequestService.cancelRequestForUsersAndShare((Set)personIds, shareId);
    }

    public void deleteShare(ItemId shareId) {
        ImmutableMap shareMembers = this.getShareDetails(shareId).getPermissions();
        this._transactionSupport.doInTransaction(() -> {
            this._shareSubscriptionDAO.unsubscribeAll(shareId);
            this._itemWriteService.markAsDeleted((Set)ImmutableSet.of((Object)shareId));
            this._accessRequestService.cancelAllRequestsForShare(shareId);
        });
        this._sharesPublisher.publishDeletedShare(shareId, shareMembers.keySet()).waitForOffsets();
        this._eventbus.post((Object)new ItemVisibilitiesChangedEvent(ImmutableSet.of((Object)shareId)));
    }

    public void deleteAllShares(TenantId tenantId) {
        Set shareIds = this._itemReadService.getAllShareIds(tenantId);
        shareIds.forEach(arg_0 -> this.deleteShare(arg_0));
        LOGGER.info("Successfully deleted all of tenant '{}' shares", (Object)tenantId);
    }

    public void requestAccess(PersonId personId, TenantId tenantId, DocumentId folderId) {
        ItemId shareId = this.getShareForFolder(folderId);
        ShareBO shareBO = this.getShareDetails(shareId);
        ImmutableSet receiverIds = ImmutableSet.builder().addAll((Iterable)this.getAllAdminsForShare(shareBO)).addAll((Iterable)this.getAllUserGroupsForShare(shareBO)).build();
        String fullProfileName = this.getFullProfileName(personId);
        DocumentId rootFolderId = this.getRootFolderId(shareId);
        if (rootFolderId == null) {
            throw new UnknownResourceBusinessException("Did not find rootFolderId for share " + String.valueOf(shareId));
        }
        this._accessRequestService.createAccessRequest(personId, shareId);
        try {
            this._notificationConnector.sendShareRequestNotification(tenantId, shareBO.getName(), shareId, rootFolderId, fullProfileName, receiverIds);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error sending notifications for share request (drive).", (Throwable)e);
        }
    }

    @Nonnull
    private ItemId getShareForFolder(DocumentId folderId) {
        CurrentVersionData newestFolderVersion = this.getNewestVersionDataForFolder(folderId);
        ItemId itemId = newestFolderVersion.getNewestChange().getItemId();
        if (!ItemType.SHARE.equals((Object)itemId.getType())) {
            throw new UnknownResourceBusinessException("Folder with ID " + String.valueOf(folderId) + " does not belong to a Share");
        }
        return itemId;
    }

    @Nonnull
    private CurrentVersionData getNewestVersionDataForFolder(DocumentId folderId) {
        CurrentVersionData newestVersionData = (CurrentVersionData)this._folderService.getCurrentVersionDataOfDocuments((Set)ImmutableSet.of((Object)folderId)).get((Object)folderId);
        if (newestVersionData == null) {
            throw new UnknownResourceBusinessException("Found no folder with ID " + String.valueOf(folderId));
        }
        return newestVersionData;
    }

    @Nonnull
    private String getFullProfileName(PersonId personId) {
        return ((PersonBO)this._personDAO.getPersons(Set.of(personId)).get((Object)personId)).getFullname();
    }

    @Nonnull
    private ImmutableSet<String> getAllAdminsForShare(ShareBO share) {
        return (ImmutableSet)EntryStream.from((Map)share.getProfilePermissionsOnly()).filterValue(privilege -> privilege.equals((Object)SharePrivilege.MANAGER)).map((personId, privilege) -> "PROFILE," + personId.getId()).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<String> getAllUserGroupsForShare(ShareBO share) {
        return (ImmutableSet)EntryStream.from((Map)share.getUserGroupPermissionsOnly()).filterValue(privilege -> privilege.equals((Object)SharePrivilege.MANAGER)).map((userGroupId, privilege) -> "USER_GROUP," + String.valueOf(userGroupId.getId())).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<PersonId> filterPersonIds(Set<Role> shareRoles) {
        return (ImmutableSet)shareRoles.stream().filter(Role::isProfileRole).map(role -> PersonId.parse((String)role.asString().substring("PROFILE,".length()))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
    }

    public void removeMemberships(Set<Role> roles) {
        ImmutableSet sharesAccessibleByRoles = ImmutableSet.copyOf((Collection)this._sharePermissionDAO.getSharesAccessibleBy(roles).values());
        ImmutableTable existingPermissionsForShares = this._sharePermissionDAO.getPermissions((Set)sharesAccessibleByRoles);
        this._transactionSupport.doInTransaction(() -> sharesAccessibleByRoles.forEach(shareId -> {
            ImmutableMap rolesWithPrivileges = existingPermissionsForShares.row(shareId);
            ImmutableMap sharePermissions = (ImmutableMap)EntryStream.from((Map)rolesWithPrivileges).filterKey((Predicate)Predicates.not(roles::contains)).collect(EntryCollectors.toImmutableMap());
            this.savePermissionActions(shareId, (Map)sharePermissions);
        }));
    }

    public boolean isSubscribed(ItemId shareId, AuthorizationContext authCtx) {
        authCtx.check((AbstractId)shareId, StaticAction.DOCUMENT_READ);
        ItemId subscription = this._shareSubscriptionDAO.subscription(authCtx.getPersonId(), shareId);
        return subscription != null;
    }

    public ImmutableSet<ItemBO> getSubscribedShares(AuthorizationContext authCtx) {
        ImmutableSet subscriptions = this._shareSubscriptionDAO.subscriptions(authCtx.getPersonId());
        ImmutableSet shareIdsToCheck = (ImmutableSet)subscriptions.stream().map(itemId -> new AuthorizationKey(authCtx.getPersonId(), (AbstractId)itemId, StaticAction.DOCUMENT_READ)).collect(ImmutableSet.toImmutableSet());
        ImmutableSet maySee = (ImmutableSet)authCtx.may((Set)shareIdsToCheck).stream().map(AuthorizationKey::getNullableId).collect(ImmutableSet.toImmutableSet());
        Sets.SetView notAllowedSubscriptions = Sets.difference((Set)subscriptions, (Set)maySee);
        this._shareSubscriptionDAO.unsubscribePersonFromShares((Set)notAllowedSubscriptions.immutableCopy(), authCtx.getPersonId());
        return ImmutableSet.copyOf((Collection)this._itemReadService.getItems((Set)maySee).values());
    }

    public void subscribeShare(ItemId shareId, PersonId personId) {
        ItemId subscription = this._shareSubscriptionDAO.subscription(personId, shareId);
        if (subscription == null) {
            this._shareSubscriptionDAO.subscribe(shareId, personId);
        }
    }

    public void unsubscribeShare(ItemId shareId, PersonId personId) {
        this._shareSubscriptionDAO.unsubscribe(shareId, (Set)ImmutableSet.of((Object)personId));
    }

    public void migrateAllUsersRole() {
        ImmutableSet allTenantRoles = this._sharePermissionDAO.getAllTenantRoles();
        allTenantRoles.forEach(tenantId -> {
            UserGroupId allTenantUsersGroup = this._peopleApiConnector.getAllUsersGroupForTenant(tenantId);
            if (allTenantUsersGroup != null) {
                this._sharePermissionDAO.migrateTenantRole(tenantId.asPermissionRole(), allTenantUsersGroup.asPermissionRole());
            }
        });
        this._sharesPublisher.publishAllSharePermissions();
        this._itemReadService.forAllShares(share -> this._eventbus.post((Object)new ItemVisibilitiesChangedEvent(ImmutableSet.of((Object)share.getId()))));
    }
}

