/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.server.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.drive.business.server.business.DriveVersionService;
import de.justsoftware.drive.business.server.business.DriveVersionUpdateProcessor;
import de.justsoftware.drive.business.server.business.UpdateBehaviour;
import de.justsoftware.drive.business.server.business.impl.DriveVersionServiceImpl;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionBO;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionId;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionUpdateProcessBO;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionUpdateProcessStatus;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessorType;
import de.justsoftware.drive.persistence.versionupdate.DriveVersionDAO;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DriveVersionServiceImpl
implements DriveVersionService {
    private static final Logger LOG = LoggerFactory.getLogger(DriveVersionServiceImpl.class);
    private final ConcurrentMap<UpdateProcessorType, DriveVersionUpdateProcessor> _processorsByType = new ConcurrentHashMap();
    private final DriveVersionDAO _versionDAO;
    private final String _currentVersion;
    private final ScheduledExecutorService _executorService;

    @Autowired
    public DriveVersionServiceImpl(DriveVersionDAO driveVersionDAO) {
        this(driveVersionDAO, "25.9.14-4737", Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("DriveVersionServiceImpl-%d").build()));
    }

    @VisibleForTesting
    DriveVersionServiceImpl(DriveVersionDAO driveVersionDAO, String currentVersion, ScheduledExecutorService executorService) {
        this._currentVersion = currentVersion;
        this._versionDAO = driveVersionDAO;
        this._executorService = executorService;
    }

    @PreDestroy
    void onDestroy() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this._executorService, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    public void register(DriveVersionUpdateProcessor updateProcessor) {
        this._processorsByType.put(updateProcessor.getProcessorType(), updateProcessor);
    }

    public void checkDriveVersionUpdate() {
        DriveVersionId versionToProcess = this.getVersionToProcess();
        this._executorService.execute((Runnable)new StartUpdateProcessesRunnable(this, versionToProcess));
    }

    @Nonnull
    @VisibleForTesting
    DriveVersionId getVersionToProcess() {
        DriveVersionBO lastDriveVersionBO = this._versionDAO.getLatestVersion();
        if (lastDriveVersionBO != null && lastDriveVersionBO.isEqualTo(this._currentVersion)) {
            LOG.info("No drive version change found. Current version is {}", (Object)this._currentVersion);
            return lastDriveVersionBO.getId();
        }
        LOG.info("Drive version update found: {} -> {}", (Object)(lastDriveVersionBO != null ? lastDriveVersionBO.getVersion() : "unknown"), (Object)this._currentVersion);
        return this._versionDAO.insertVersion(this._currentVersion, (Iterable)this.determineRequiredProcessesForNewVersion(this._currentVersion));
    }

    @Nonnull
    private ImmutableList<DriveVersionUpdateProcessBO> determineRequiredProcessesForNewVersion(String newVersionString) {
        return FluentIterable.from(this._processorsByType.values()).filter(p -> p.getUpdateBehaviour().applyForNewVersion(newVersionString, (UpdateBehaviour.UpdateProcessInformationProvider)new UpdateProcessInformationProviderImpl(this))).transform(p -> new DriveVersionUpdateProcessBO(p.getProcessorType(), DriveVersionUpdateProcessStatus.REQUIRED, p.getProcessorVersion())).toList();
    }
}

