/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.TempFileService;
import de.justsoftware.drive.business.file.VideoTeaserService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.TempFileBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.filepersistence.common.StorageConnector;
import de.justsoftware.drive.filepersistence.common.model.BasePath;
import de.justsoftware.permission.client.model.Role;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

@Service
@ParametersAreNonnullByDefault
public class VideoTeaserServiceImpl
implements VideoTeaserService {
    public static final String TEASER_BASE_PATH = BasePath.DRIVE.getPath() + "/video-teasers";
    private final StorageConnector _storageConnector;
    private final FileService _fileService;
    private final TempFileService _tempFileService;

    @Autowired
    public VideoTeaserServiceImpl(StorageConnector storageConnector, FileService fileService, TempFileService tempFileService) {
        this._storageConnector = storageConnector;
        this._fileService = fileService;
        this._tempFileService = tempFileService;
    }

    public UUID setVideoTeaser(ByteSourceWithFilename teaser, UUID videoId, AuthorizationContext authContext) {
        this.requireImageMimeType(teaser);
        VideoTeaserId videoTeaserId = new VideoTeaserId(videoId);
        return (UUID)this.resolveFile(videoId, tempFile -> {
            this.mayChangeVideoTeaser(tempFile, authContext);
            this.requireVideoMimeType(tempFile.getMimeType());
            this._tempFileService.setVideoTeaser(tempFile, videoTeaserId);
            this._storageConnector.store(TEASER_BASE_PATH, videoTeaserId.toString(), teaser.getByteSource());
            return videoId;
        }, fileVersion -> {
            this.mayChangeVideoTeaser(fileVersion, authContext);
            this.requireVideoMimeType(fileVersion.getMimeType());
            this._fileService.setVideoTeaser(fileVersion, videoTeaserId);
            this._storageConnector.store(TEASER_BASE_PATH, videoTeaserId.toString(), teaser.getByteSource());
            return videoId;
        });
    }

    public boolean deleteVideoTeaser(UUID videoId, AuthorizationContext authContext) {
        return (Boolean)this.resolveFile(videoId, tempFile -> {
            this.mayChangeVideoTeaser(tempFile, authContext);
            if (tempFile.getVideoTeaserId() == null) {
                return false;
            }
            this._tempFileService.deleteVideoTeaser(tempFile.getId());
            this._storageConnector.delete(TEASER_BASE_PATH, tempFile.getVideoTeaserId().toString());
            return true;
        }, fileVersion -> {
            this.mayChangeVideoTeaser(fileVersion, authContext);
            if (fileVersion.getVideoTeaserId() == null) {
                return false;
            }
            this._fileService.deleteVideoTeaser(fileVersion.getId());
            this._storageConnector.delete(TEASER_BASE_PATH, fileVersion.getVideoTeaserId().toString());
            return true;
        });
    }

    public String getTeaserStorageUrl(VideoTeaserId videoTeaserId) {
        return this._storageConnector.getUrl(TEASER_BASE_PATH + "/" + String.valueOf(videoTeaserId));
    }

    private <T> T resolveFile(UUID videoId, Function<TempFileBO, T> onTempFile, Function<FileVersionBO, T> onPersistedFile) {
        TempFileId tempFileId = new TempFileId(videoId);
        TempFileBO tempVideo = this._tempFileService.getTempFile(tempFileId);
        if (tempVideo != null) {
            return onTempFile.apply(tempVideo);
        }
        DocumentId documentId = new DocumentId(videoId);
        FileVersionBO latestVersion = this._fileService.getLastFileVersion(documentId);
        if (latestVersion == null) {
            throw new NoSuchElementException("No video with id %s found".formatted(videoId));
        }
        return onPersistedFile.apply(latestVersion);
    }

    private void requireVideoMimeType(String mimeType) {
        if (!mimeType.startsWith("video/")) {
            throw new IllegalArgumentException("Invalid MIME type: " + mimeType + ". Only videos are supported for teaser upload.");
        }
    }

    private void requireImageMimeType(ByteSourceWithFilename teaser) {
        String mimeType = FileMetaInfoUtil.getMimeTypeFromSource((String)teaser.getFilename(), (ByteSource)teaser.getByteSource());
        if (!mimeType.startsWith("image/")) {
            throw new UnsupportedMediaTypeStatusException("Only images are allowed as teasers, sent file is of type: " + mimeType);
        }
    }

    private void mayChangeVideoTeaser(TempFileBO tempFile, AuthorizationContext authContext) {
        if (!tempFile.getOwner().equals((Object)authContext.getPersonId())) {
            throw new PermissionDeniedException("You do not have permission to access this file");
        }
    }

    private void mayChangeVideoTeaser(FileVersionBO fileVersion, AuthorizationContext authContext) {
        authContext.check(Role.manage((String)fileVersion.getItemId().toString()));
    }
}

