/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.trusteddevice;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.trusteddevice.AccountFailedLogin;
import de.justsoftware.authorization.trusteddevice.AccountFailedLoginService;
import de.justsoftware.authorization.trusteddevice.AccountLockService;
import de.justsoftware.authorization.trusteddevice.TrustedDeviceService;
import de.justsoftware.authorization.trusteddevice.TrustedDeviceTokenService;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.WebUtils;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0015H\u0012J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/authorization/trusteddevice/TrustedDeviceService;", "", "accountFailedLoginService", "Lde/justsoftware/authorization/trusteddevice/AccountFailedLoginService;", "accountLockService", "Lde/justsoftware/authorization/trusteddevice/AccountLockService;", "trustedDeviceTokenService", "Lde/justsoftware/authorization/trusteddevice/TrustedDeviceTokenService;", "userDetailService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "<init>", "(Lde/justsoftware/authorization/trusteddevice/AccountFailedLoginService;Lde/justsoftware/authorization/trusteddevice/AccountLockService;Lde/justsoftware/authorization/trusteddevice/TrustedDeviceTokenService;Lde/justsoftware/authorization/oauth2/JustUserDetailService;)V", "countFailedAuthentication", "", "attemptingUser", "", "accountMayLogIn", "", "loginNameOrEmail", "user", "Lorg/springframework/security/core/userdetails/UserDetails;", "Lde/justsoftware/authorization/oauth2/JustUser;", "issueTrustedDeviceToken", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "lifetime", "Ljava/time/Duration;", "getCurrentTrustedDeviceCookie", "Companion", "just-authorization-server"})
public class TrustedDeviceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AccountFailedLoginService accountFailedLoginService;
    @NotNull
    private final AccountLockService accountLockService;
    @NotNull
    private final TrustedDeviceTokenService trustedDeviceTokenService;
    @NotNull
    private final JustUserDetailService userDetailService;
    @NotNull
    public static final String TRUSTED_DEVICE = "trusted-device";
    @NotNull
    private static final Logger LOG;

    public TrustedDeviceService(@NotNull AccountFailedLoginService accountFailedLoginService, @NotNull AccountLockService accountLockService, @NotNull TrustedDeviceTokenService trustedDeviceTokenService, @NotNull JustUserDetailService userDetailService) {
        Intrinsics.checkNotNullParameter((Object)accountFailedLoginService, (String)"accountFailedLoginService");
        Intrinsics.checkNotNullParameter((Object)accountLockService, (String)"accountLockService");
        Intrinsics.checkNotNullParameter((Object)trustedDeviceTokenService, (String)"trustedDeviceTokenService");
        Intrinsics.checkNotNullParameter((Object)userDetailService, (String)"userDetailService");
        this.accountFailedLoginService = accountFailedLoginService;
        this.accountLockService = accountLockService;
        this.trustedDeviceTokenService = trustedDeviceTokenService;
        this.userDetailService = userDetailService;
    }

    public void countFailedAuthentication(@NotNull String attemptingUser) {
        Intrinsics.checkNotNullParameter((Object)attemptingUser, (String)"attemptingUser");
        JustUser user = this.userDetailService.loadUserByUsername(attemptingUser);
        AccountFailedLogin failedLoginCount = this.accountFailedLoginService.countFailedLoginAttempt(user.getProfileId());
        LOG.info("Failed login attempt. {}", (Object)failedLoginCount.toString());
        this.accountLockService.lockAccountIfNecessary(failedLoginCount);
    }

    public boolean accountMayLogIn(@NotNull String loginNameOrEmail) {
        Intrinsics.checkNotNullParameter((Object)loginNameOrEmail, (String)"loginNameOrEmail");
        JustUser user = this.userDetailService.loadUserByUsername(loginNameOrEmail);
        return this.accountMayLogIn(user);
    }

    public boolean accountMayLogIn(@NotNull UserDetails user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (user instanceof JustUser) {
            return this.accountMayLogIn((JustUser)user);
        }
        String string = user.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUsername(...)");
        return this.accountMayLogIn(string);
    }

    private boolean accountMayLogIn(JustUser user) {
        boolean accountIsLocked = this.accountLockService.isAccountLocked(user.getProfileId());
        String trustedDeviceToken = this.getCurrentTrustedDeviceCookie();
        if (trustedDeviceToken == null || !accountIsLocked) {
            return !accountIsLocked;
        }
        return this.trustedDeviceTokenService.isTokenValidForUser(trustedDeviceToken, user.getProfileId());
    }

    @Nullable
    public String issueTrustedDeviceToken(@NotNull ProfileId profileId, @NotNull Duration lifetime) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        return this.trustedDeviceTokenService.issueToken(profileId, lifetime);
    }

    @Nullable
    public String getCurrentTrustedDeviceCookie() {
        Cookie cookie;
        block3: {
            block2: {
                RequestAttributes it = RequestContextHolder.getRequestAttributes();
                boolean bl = false;
                if (!(it instanceof ServletRequestAttributes)) break block2;
                HttpServletRequest httpServletRequest = ((ServletRequestAttributes)it).getRequest();
                Intrinsics.checkNotNullExpressionValue((Object)httpServletRequest, (String)"getRequest(...)");
                HttpServletRequest userRequest = httpServletRequest;
                cookie = WebUtils.getCookie((HttpServletRequest)userRequest, (String)TRUSTED_DEVICE);
                if (cookie != null) break block3;
            }
            return null;
        }
        return cookie.getValue();
    }

    static {
        Logger logger = LoggerFactory.getLogger(TrustedDeviceService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

