/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller.internal;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.oauth2.client.OauthTokenService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal/token"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lde/justsoftware/authorization/controller/internal/InternalOauthTokenController;", "", "oauthTokenService", "Lde/justsoftware/authorization/oauth2/client/OauthTokenService;", "<init>", "(Lde/justsoftware/authorization/oauth2/client/OauthTokenService;)V", "getOauthTokenService", "()Lde/justsoftware/authorization/oauth2/client/OauthTokenService;", "deleteMobileTokensForProfile", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "countMobileTokensForProfile", "just-authorization-server"})
public class InternalOauthTokenController {
    @NotNull
    private final OauthTokenService oauthTokenService;

    public InternalOauthTokenController(@NotNull OauthTokenService oauthTokenService) {
        Intrinsics.checkNotNullParameter((Object)oauthTokenService, (String)"oauthTokenService");
        this.oauthTokenService = oauthTokenService;
    }

    @NotNull
    public OauthTokenService getOauthTokenService() {
        return this.oauthTokenService;
    }

    @DeleteMapping(value={"/mobile/{profileId}"})
    public int deleteMobileTokensForProfile(@PathVariable @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.getOauthTokenService().deleteMobileTokensForProfile(profileId);
    }

    @GetMapping(value={"/mobile/{profileId}/count"})
    public int countMobileTokensForProfile(@PathVariable @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.getOauthTokenService().countMobileTokensForProfile(profileId);
    }
}

