/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.application.web.drive.DriveSettingsApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.connector.drive.DriveSettings;
import de.justsoftware.admin.graphql.dataFetchers.TenantFetcherKt;
import de.justsoftware.admin.graphql.generated.types.DriveSettingsInput;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/DriveSettingsFetcher;", "", "driveSettingsApplicationService", "Lde/justsoftware/admin/application/web/drive/DriveSettingsApplicationService;", "tenantApplicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "<init>", "(Lde/justsoftware/admin/application/web/drive/DriveSettingsApplicationService;Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "driveSettings", "Lde/justsoftware/admin/connector/drive/DriveSettings;", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "updateDriveSettings", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "input", "Lde/justsoftware/admin/graphql/generated/types/DriveSettingsInput;", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "admin-service"})
public class DriveSettingsFetcher {
    @NotNull
    private final DriveSettingsApplicationService driveSettingsApplicationService;
    @NotNull
    private final TenantApplicationService tenantApplicationService;

    public DriveSettingsFetcher(@NotNull DriveSettingsApplicationService driveSettingsApplicationService, @NotNull TenantApplicationService tenantApplicationService) {
        Intrinsics.checkNotNullParameter((Object)driveSettingsApplicationService, (String)"driveSettingsApplicationService");
        Intrinsics.checkNotNullParameter((Object)tenantApplicationService, (String)"tenantApplicationService");
        this.driveSettingsApplicationService = driveSettingsApplicationService;
        this.tenantApplicationService = tenantApplicationService;
    }

    @DgsData(parentType="Tenant", field="driveSettings")
    @NotNull
    public DriveSettings driveSettings(@NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.driveSettingsApplicationService.getSettings((AuthorizationContext)DgsContext.Companion.getCustomContext(dfe));
    }

    @DgsMutation(field="updateDriveSettings")
    @NotNull
    public Tenant updateDriveSettings(@InputArgument @NotNull DriveSettingsInput input, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.driveSettingsApplicationService.updateSettings(input, authContext);
        return TenantFetcherKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.tenantApplicationService.getOne(authContext));
    }
}

