/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StoreFactory;

public class TableProcessorNode<K, V>
extends GraphNode {
    private final ProcessorParameters<K, V, ?, ?> processorParameters;
    private final StoreFactory storeFactory;
    private final String[] storeNames;

    public TableProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, StoreFactory storeFactory) {
        this(nodeName, processorParameters, storeFactory, null);
    }

    public TableProcessorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, StoreFactory storeFactory, String[] storeNames) {
        super(nodeName);
        this.processorParameters = processorParameters;
        this.storeFactory = storeFactory;
        this.storeNames = storeNames != null ? storeNames : new String[]{};
    }

    public ProcessorParameters<K, V, ?, ?> processorParameters() {
        return this.processorParameters;
    }

    @Override
    public String toString() {
        return "TableProcessorNode{, processorParameters=" + this.processorParameters + ", storeFactory=" + (this.storeFactory == null ? "null" : this.storeFactory.name()) + ", storeNames=" + Arrays.toString(this.storeNames) + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        KTableSource tableSource;
        String processorName = this.processorParameters.processorName();
        topologyBuilder.addProcessor(processorName, this.processorParameters.processorSupplier(), this.parentNodeNames());
        if (this.storeNames.length > 0) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
        }
        KTableSource kTableSource = tableSource = this.processorParameters.processorSupplier() instanceof KTableSource ? (KTableSource)this.processorParameters.processorSupplier() : null;
        if (tableSource != null) {
            if (tableSource.materialized()) {
                topologyBuilder.addStateStore(Objects.requireNonNull(this.storeFactory, "storeFactory was null"), processorName);
            }
        } else if (this.storeFactory != null) {
            topologyBuilder.addStateStore(this.storeFactory, processorName);
        }
    }
}

