/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.drive;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.justsoftware.wikiservice.drive.exceptions.PersistFilesError;
import de.justsoftware.wikiservice.drive.model.InternalFileModel;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.serializer.ProfileIdSerializer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/wikiservice/drive/DriveAPI;", "", "driveInternalUrl", "", "rest", "Lorg/springframework/web/client/RestClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "persistFiles", "", "Lde/justsoftware/wikiservice/drive/model/InternalFileModel;", "tempIds", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "deserializeTmpMove", "input", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nDriveAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveAPI.kt\nde/justsoftware/wikiservice/drive/DriveAPI\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n477#2:65\n423#2:66\n462#2:71\n412#2:72\n1246#3,4:67\n1246#3,4:73\n*S KotlinDebug\n*F\n+ 1 DriveAPI.kt\nde/justsoftware/wikiservice/drive/DriveAPI\n*L\n59#1:65\n59#1:66\n60#1:71\n60#1:72\n59#1:67,4\n60#1:73,4\n*E\n"})
public class DriveAPI {
    @NotNull
    private final String driveInternalUrl;
    @NotNull
    private final RestClient rest;
    @NotNull
    private final ObjectMapper mapper;

    /*
     * WARNING - void declaration
     */
    @Autowired
    public DriveAPI(@Value(value="${drive.internal:localhost:8080/drive/internal}") @NotNull String driveInternalUrl, @NotNull RestClient rest) {
        void $this$mapper_u24lambda_u240;
        ObjectMapper objectMapper;
        Intrinsics.checkNotNullParameter((Object)driveInternalUrl, (String)"driveInternalUrl");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.driveInternalUrl = driveInternalUrl;
        this.rest = rest;
        ObjectMapper objectMapper2 = objectMapper = new ObjectMapper();
        DriveAPI driveAPI = this;
        boolean bl = false;
        $this$mapper_u24lambda_u240.registerModule((Module)new JodaModule());
        $this$mapper_u24lambda_u240.registerModule((Module)new KotlinModule.Builder().build());
        $this$mapper_u24lambda_u240.registerModule((Module)new ProfileIdSerializer());
        $this$mapper_u24lambda_u240.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        driveAPI.mapper = objectMapper;
    }

    public /* synthetic */ DriveAPI(String string, RestClient restClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String[] stringArray = new String[]{"application/json"};
            restClient = RestClient.builder().defaultHeader("Content-Type", stringArray).build();
        }
        this(string, restClient);
    }

    @NotNull
    public Map<String, InternalFileModel> persistFiles(@NotNull Set<String> tempIds, @NotNull ArticleId articleId, @NotNull ProfileId creator) {
        Intrinsics.checkNotNullParameter(tempIds, (String)"tempIds");
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"targetItemId", (Object)articleId.toString()), TuplesKt.to((Object)"tempFileIds", tempIds), TuplesKt.to((Object)"ownerId", (Object)creator.getId())};
        ResponseEntity it = ((RestClient.RequestBodySpec)this.rest.post().uri(this.driveInternalUrl + "/tmp/move", new Object[0])).body((Object)MapsKt.mapOf((Pair[])pairArray)).retrieve().toEntity(String.class);
        boolean bl = false;
        if (it.getStatusCode() != HttpStatus.OK) {
            HttpStatusCode httpStatusCode = it.getStatusCode();
            Intrinsics.checkNotNullExpressionValue((Object)httpStatusCode, (String)"getStatusCode(...)");
            throw new PersistFilesError(tempIds, httpStatusCode);
        }
        return this.deserializeTmpMove((String)it.getBody());
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, InternalFileModel> deserializeTmpMove(String input) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object it;
        Map map;
        Map $this$mapKeysTo$iv$iv;
        Object object2 = this.mapper.readValue(input, Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"readValue(...)");
        Map $this$mapKeys$iv = (Map)object2;
        boolean $i$f$mapKeys = false;
        Map map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object = String.valueOf(it.getKey());
            Map map3 = map;
            boolean bl2 = false;
            it = it$iv$iv.getValue();
            map3.put(object, it);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            object = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl3 = false;
            InternalFileModel internalFileModel = (InternalFileModel)this.mapper.convertValue(it2.getValue(), InternalFileModel.class);
            map.put(k, internalFileModel);
        }
        return destination$iv$iv;
    }
}

