/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.controller;

import de.justsoftware.search.shared.model.TenantId;
import de.justsoftware.wikiservice.application.ArticleApplicationService;
import de.justsoftware.wikiservice.application.ChapterApplicationService;
import de.justsoftware.wikiservice.application.GlobalConfigApplicationService;
import de.justsoftware.wikiservice.application.PermissionApplicationService;
import de.justsoftware.wikiservice.application.SearchApplicationService;
import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.application.TableOfContentsApplicationService;
import de.justsoftware.wikiservice.application.WikiApplicationService;
import de.justsoftware.wikiservice.application.WikiOverviewApplicationService;
import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ArticleHeadingDto;
import de.justsoftware.wikiservice.application.model.ArticleUpdateResultDto;
import de.justsoftware.wikiservice.application.model.ArticleVersionDto;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.ContentCountDto;
import de.justsoftware.wikiservice.application.model.CreateArticleDto;
import de.justsoftware.wikiservice.application.model.CreateOrUpdateChapterDto;
import de.justsoftware.wikiservice.application.model.CreateOrUpdateWikiDto;
import de.justsoftware.wikiservice.application.model.GlobalConfigDto;
import de.justsoftware.wikiservice.application.model.MoveArticleDto;
import de.justsoftware.wikiservice.application.model.PageDto;
import de.justsoftware.wikiservice.application.model.PermissionDto;
import de.justsoftware.wikiservice.application.model.PreviewDto;
import de.justsoftware.wikiservice.application.model.SubscriptionDto;
import de.justsoftware.wikiservice.application.model.TableOfContentsDto;
import de.justsoftware.wikiservice.application.model.UpdateArticleDto;
import de.justsoftware.wikiservice.application.model.UpdatePermissionItemDto;
import de.justsoftware.wikiservice.application.model.UpdateSubscriptionDto;
import de.justsoftware.wikiservice.application.model.UpdateTableOfContentsElementDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.application.model.WikiMoveTargetDto;
import de.justsoftware.wikiservice.application.model.WikiOverviewConfigDto;
import de.justsoftware.wikiservice.application.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.model.UpdateTableOfContentsElement;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.DbWikiOverview;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J0\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010 \u001a\u00020\u00172\b\b\u0001\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J$\u0010#\u001a\u00020$2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010!\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J$\u0010&\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010!\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010(\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J \u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J6\u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u0002002\b\b\u0001\u00101\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u00102\u001a\u00020\u001b2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J,\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001b042\u000e\b\u0001\u00105\u001a\b\u0012\u0004\u0012\u00020\u001d062\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u00107\u001a\u00020\u001b2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u00108\u001a\u00020\u00172\b\b\u0001\u00109\u001a\u00020:2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J&\u0010;\u001a\u00020<2\b\b\u0001\u0010=\u001a\u00020>2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010?\u001a\u00020<2\b\b\u0001\u0010@\u001a\u00020A2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J$\u0010B\u001a\u00020<2\b\b\u0001\u0010=\u001a\u00020>2\b\b\u0001\u0010@\u001a\u00020A2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010C\u001a\u00020<2\b\b\u0001\u0010=\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010D\u001a\u00020E2\b\b\u0001\u0010F\u001a\u00020G2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0010\u0010H\u001a\u00020I2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010J\u001a\u00020K2\b\b\u0001\u0010L\u001a\u00020K2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J>\u0010M\u001a\b\u0012\u0004\u0012\u00020N0-2\b\b\u0001\u0010/\u001a\u0002002\b\b\u0001\u00101\u001a\u0002002\b\b\u0001\u0010O\u001a\u00020P2\b\b\u0001\u0010Q\u001a\u00020R2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J \u0010S\u001a\b\u0012\u0004\u0012\u00020T0*2\b\b\u0001\u0010U\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010V\u001a\u00020W2\b\b\u0001\u0010X\u001a\u00020Y2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J&\u0010Z\u001a\u00020W2\b\b\u0001\u0010[\u001a\u00020\\2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J$\u0010]\u001a\u00020W2\b\b\u0001\u0010[\u001a\u00020\\2\b\b\u0001\u0010^\u001a\u00020Y2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010_\u001a\u00020W2\b\b\u0001\u0010[\u001a\u00020\\2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J \u0010`\u001a\b\u0012\u0004\u0012\u00020a0*2\b\b\u0001\u0010[\u001a\u00020\\2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J0\u0010b\u001a\b\u0012\u0004\u0012\u00020a0*2\b\b\u0001\u0010[\u001a\u00020\\2\u000e\b\u0001\u0010c\u001a\b\u0012\u0004\u0012\u00020d0*2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010e\u001a\u00020f2\b\b\u0001\u0010[\u001a\u00020\\2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J&\u0010g\u001a\u00020h2\b\b\u0001\u0010[\u001a\u00020\\2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J*\u0010i\u001a\u00020h2\b\b\u0001\u0010[\u001a\u00020\\2\u000e\b\u0001\u0010j\u001a\b\u0012\u0004\u0012\u00020k0*2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u001a\u0010l\u001a\u00020f2\b\b\u0001\u0010=\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J0\u0010m\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030n0-2\b\b\u0001\u0010/\u001a\u0002002\b\b\u0001\u00101\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lde/justsoftware/wikiservice/controller/WikiController;", "", "articleApplicationService", "Lde/justsoftware/wikiservice/application/ArticleApplicationService;", "subscriptionApplicationService", "Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "globalConfigApplicationService", "Lde/justsoftware/wikiservice/application/GlobalConfigApplicationService;", "wikiOverviewApplicationService", "Lde/justsoftware/wikiservice/application/WikiOverviewApplicationService;", "wikiApplicationService", "Lde/justsoftware/wikiservice/application/WikiApplicationService;", "permissionApplicationService", "Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "chapterApplicationService", "Lde/justsoftware/wikiservice/application/ChapterApplicationService;", "tableOfContentsApplicationService", "Lde/justsoftware/wikiservice/application/TableOfContentsApplicationService;", "searchApplicationService", "Lde/justsoftware/wikiservice/application/SearchApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/application/ArticleApplicationService;Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;Lde/justsoftware/wikiservice/application/GlobalConfigApplicationService;Lde/justsoftware/wikiservice/application/WikiOverviewApplicationService;Lde/justsoftware/wikiservice/application/WikiApplicationService;Lde/justsoftware/wikiservice/application/PermissionApplicationService;Lde/justsoftware/wikiservice/application/ChapterApplicationService;Lde/justsoftware/wikiservice/application/TableOfContentsApplicationService;Lde/justsoftware/wikiservice/application/SearchApplicationService;)V", "getArticle", "Lde/justsoftware/wikiservice/application/model/ArticleDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "preferDraft", "", "translationLanguage", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "createArticle", "articleInfo", "Lde/justsoftware/wikiservice/application/model/CreateArticleDto;", "updateArticle", "Lde/justsoftware/wikiservice/application/model/ArticleUpdateResultDto;", "Lde/justsoftware/wikiservice/application/model/UpdateArticleDto;", "moveArticle", "Lde/justsoftware/wikiservice/application/model/MoveArticleDto;", "deleteArticle", "getArticleHeadings", "", "Lde/justsoftware/wikiservice/application/model/ArticleHeadingDto;", "getVersionHistoryForArticle", "Lde/justsoftware/wikiservice/application/model/PageDto;", "Lde/justsoftware/wikiservice/application/model/ArticleVersionDto;", "page", "", "pageSize", "updateEditingTokenForArticle", "getLinkStatus", "", "ids", "", "deleteEditingTokenForArticle", "getArticleVersion", "articleVersionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "getChapter", "Lde/justsoftware/wikiservice/application/model/ChapterDto;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "createChapter", "chapter", "Lde/justsoftware/wikiservice/application/model/CreateOrUpdateChapterDto;", "updateChapter", "deleteChapter", "createOrUpdateSubscription", "Lde/justsoftware/wikiservice/application/model/SubscriptionDto;", "subscriptionInfo", "Lde/justsoftware/wikiservice/application/model/UpdateSubscriptionDto;", "getGlobalConfig", "Lde/justsoftware/wikiservice/application/model/GlobalConfigDto;", "changeOverviewConfig", "Lde/justsoftware/wikiservice/application/model/WikiOverviewConfigDto;", "configDto", "getWikiPreviews", "Lde/justsoftware/wikiservice/application/model/WikiPreviewDto;", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Direction;", "getWikiMoveTargets", "Lde/justsoftware/wikiservice/application/model/WikiMoveTargetDto;", "queryString", "createWiki", "Lde/justsoftware/wikiservice/application/model/WikiDto;", "wiki", "Lde/justsoftware/wikiservice/application/model/CreateOrUpdateWikiDto;", "getWiki", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "updateWiki", "updateWikiDto", "deleteWiki", "getWikiPermissions", "Lde/justsoftware/wikiservice/application/model/PermissionDto;", "setWikiPermissions", "updatedPermissions", "Lde/justsoftware/wikiservice/application/model/UpdatePermissionItemDto;", "getWikiContentCount", "Lde/justsoftware/wikiservice/application/model/ContentCountDto;", "getWikiTableOfContents", "Lde/justsoftware/wikiservice/application/model/TableOfContentsDto;", "updateWikiTableOfContents", "updatedItems", "Lde/justsoftware/wikiservice/application/model/UpdateTableOfContentsElementDto;", "getChapterContentCount", "getSubscribedItems", "Lde/justsoftware/wikiservice/application/model/PreviewDto;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiController.kt\nde/justsoftware/wikiservice/controller/WikiController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,364:1\n1557#2:365\n1628#2,3:366\n*S KotlinDebug\n*F\n+ 1 WikiController.kt\nde/justsoftware/wikiservice/controller/WikiController\n*L\n341#1:365\n341#1:366,3\n*E\n"})
public class WikiController {
    @NotNull
    private final ArticleApplicationService articleApplicationService;
    @NotNull
    private final SubscriptionApplicationService subscriptionApplicationService;
    @NotNull
    private final GlobalConfigApplicationService globalConfigApplicationService;
    @NotNull
    private final WikiOverviewApplicationService wikiOverviewApplicationService;
    @NotNull
    private final WikiApplicationService wikiApplicationService;
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final ChapterApplicationService chapterApplicationService;
    @NotNull
    private final TableOfContentsApplicationService tableOfContentsApplicationService;
    @NotNull
    private final SearchApplicationService searchApplicationService;

    public WikiController(@NotNull ArticleApplicationService articleApplicationService, @NotNull SubscriptionApplicationService subscriptionApplicationService, @NotNull GlobalConfigApplicationService globalConfigApplicationService, @NotNull WikiOverviewApplicationService wikiOverviewApplicationService, @NotNull WikiApplicationService wikiApplicationService, @NotNull PermissionApplicationService permissionApplicationService, @NotNull ChapterApplicationService chapterApplicationService, @NotNull TableOfContentsApplicationService tableOfContentsApplicationService, @NotNull SearchApplicationService searchApplicationService) {
        Intrinsics.checkNotNullParameter((Object)articleApplicationService, (String)"articleApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionApplicationService, (String)"subscriptionApplicationService");
        Intrinsics.checkNotNullParameter((Object)globalConfigApplicationService, (String)"globalConfigApplicationService");
        Intrinsics.checkNotNullParameter((Object)wikiOverviewApplicationService, (String)"wikiOverviewApplicationService");
        Intrinsics.checkNotNullParameter((Object)wikiApplicationService, (String)"wikiApplicationService");
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)chapterApplicationService, (String)"chapterApplicationService");
        Intrinsics.checkNotNullParameter((Object)tableOfContentsApplicationService, (String)"tableOfContentsApplicationService");
        Intrinsics.checkNotNullParameter((Object)searchApplicationService, (String)"searchApplicationService");
        this.articleApplicationService = articleApplicationService;
        this.subscriptionApplicationService = subscriptionApplicationService;
        this.globalConfigApplicationService = globalConfigApplicationService;
        this.wikiOverviewApplicationService = wikiOverviewApplicationService;
        this.wikiApplicationService = wikiApplicationService;
        this.permissionApplicationService = permissionApplicationService;
        this.chapterApplicationService = chapterApplicationService;
        this.tableOfContentsApplicationService = tableOfContentsApplicationService;
        this.searchApplicationService = searchApplicationService;
    }

    @GetMapping(value={"/articles/{articleId}"})
    @NotNull
    public ArticleDto getArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestParam(value="preferDraft", required=false) boolean preferDraft, @RequestParam(value="translationLanguage", required=false) @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.read(articleId, preferDraft, authContext, translationLanguage);
    }

    @PostMapping(value={"/articles"})
    @NotNull
    public ArticleDto createArticle(@RequestBody @NotNull CreateArticleDto articleInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleInfo, (String)"articleInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.create(IdUtilsKt.parentIdOf((String)articleInfo.getParentId()), articleInfo.getTitle(), articleInfo.getContent(), articleInfo.getTextContent(), articleInfo.isDraft(), authContext);
    }

    @PutMapping(value={"/articles/{articleId}"})
    @NotNull
    public ArticleUpdateResultDto updateArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestBody @NotNull UpdateArticleDto articleInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)articleInfo, (String)"articleInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.update(articleId, articleInfo.getTitle(), articleInfo.getContent(), articleInfo.getTextContent(), articleInfo.isDraft(), authContext);
    }

    @PutMapping(value={"/articles/{articleId}/move"})
    @NotNull
    public ArticleDto moveArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestBody @NotNull MoveArticleDto articleInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)articleInfo, (String)"articleInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.move(articleId, IdUtilsKt.parentIdOf((String)articleInfo.getParentId()), authContext);
    }

    @DeleteMapping(value={"/articles/{articleId}"})
    @NotNull
    public ArticleDto deleteArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.delete(articleId, authContext);
    }

    @GetMapping(value={"/articleHeadings/{articleId}"})
    @NotNull
    public List<ArticleHeadingDto> getArticleHeadings(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readHeadingsOfArticle(articleId, authContext);
    }

    @GetMapping(value={"/articles/{articleId}/versionHistory"})
    @Nullable
    public PageDto<ArticleVersionDto> getVersionHistoryForArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readArticleVersions(articleId, page, pageSize, authContext);
    }

    @PutMapping(value={"/articles/{articleId}/token"})
    public boolean updateEditingTokenForArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.updateEditingToken(articleId, authContext);
    }

    @PostMapping(value={"/prosemirror/linkStatus/"})
    @NotNull
    public Map<String, Boolean> getLinkStatus(@RequestBody @NotNull Set<String> ids, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.searchApplicationService.prosemirrorLinkStatus(ids, new TenantId(authContext.getTenantId().getId()));
    }

    @DeleteMapping(value={"/articles/{articleId}/token"})
    public boolean deleteEditingTokenForArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.deleteEditingToken(articleId, authContext);
    }

    @GetMapping(value={"/articleVersions/{articleVersionId}"})
    @NotNull
    public ArticleDto getArticleVersion(@PathVariable(value="articleVersionId") @NotNull ArticleVersionId articleVersionId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleVersionId, (String)"articleVersionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readArticleByVersionId(articleVersionId, authContext);
    }

    @GetMapping(value={"/chapters/{chapterId}"})
    @NotNull
    public ChapterDto getChapter(@PathVariable(value="chapterId") @NotNull ChapterId chapterId, @RequestParam(value="translationLanguage", required=false) @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chapterApplicationService.read(chapterId, translationLanguage, authContext);
    }

    @PostMapping(value={"/chapters"})
    @NotNull
    public ChapterDto createChapter(@RequestBody @NotNull CreateOrUpdateChapterDto chapter, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chapterApplicationService.create(chapter, authContext);
    }

    @PutMapping(value={"/chapters/{chapterId}"})
    @NotNull
    public ChapterDto updateChapter(@PathVariable(value="chapterId") @NotNull ChapterId chapterId, @RequestBody @NotNull CreateOrUpdateChapterDto chapter, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chapterApplicationService.update(chapterId, chapter, authContext);
    }

    @DeleteMapping(value={"/chapters/{chapterId}"})
    @NotNull
    public ChapterDto deleteChapter(@PathVariable(value="chapterId") @NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chapterApplicationService.delete(chapterId, authContext);
    }

    @PutMapping(value={"/subscriptions"})
    @NotNull
    public SubscriptionDto createOrUpdateSubscription(@RequestBody @NotNull UpdateSubscriptionDto subscriptionInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)subscriptionInfo, (String)"subscriptionInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.subscriptionApplicationService.setSubscription(IdUtilsKt.itemIdOf((String)subscriptionInfo.getItemId()), subscriptionInfo.isSubscribed(), authContext);
    }

    @GetMapping(value={"/globalConfig"})
    @NotNull
    public GlobalConfigDto getGlobalConfig(@NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.globalConfigApplicationService.getGlobalConfig(authContext);
    }

    @PutMapping(value={"/overviewConfig"})
    @NotNull
    public WikiOverviewConfigDto changeOverviewConfig(@RequestBody @NotNull WikiOverviewConfigDto configDto, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)configDto, (String)"configDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiOverviewApplicationService.setWikiOverviewConfig(configDto.getKey(), configDto.getDirection(), configDto.getDisplay(), authContext);
    }

    @GetMapping(value={"/wikiPreviews"})
    @NotNull
    public PageDto<WikiPreviewDto> getWikiPreviews(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @RequestParam(value="sortKey", required=false, defaultValue="TITLE") @NotNull DbWikiOverview.Companion.Sort sortKey, @RequestParam(value="sortDirection", required=false, defaultValue="ASCENDING") @NotNull DbWikiOverview.Companion.Direction sortDirection, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.getWikiList(page, pageSize, sortKey, sortDirection, authContext);
    }

    @GetMapping(value={"/wikiMoveTargets"})
    @NotNull
    public List<WikiMoveTargetDto> getWikiMoveTargets(@RequestParam(value="queryString", required=false, defaultValue="") @NotNull String queryString, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)queryString, (String)"queryString");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.getWikiMoveTargetList(queryString, authContext);
    }

    @PostMapping(value={"/wikis"})
    @NotNull
    public WikiDto createWiki(@RequestBody @NotNull CreateOrUpdateWikiDto wiki, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.create(wiki, authContext);
    }

    @GetMapping(value={"/wikis/{wikiId}"})
    @NotNull
    public WikiDto getWiki(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @RequestParam(value="translationLanguage", required=false) @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.read(wikiId, translationLanguage, authContext);
    }

    @PutMapping(value={"/wikis/{wikiId}"})
    @NotNull
    public WikiDto updateWiki(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @RequestBody @NotNull CreateOrUpdateWikiDto updateWikiDto, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)updateWikiDto, (String)"updateWikiDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.update(wikiId, updateWikiDto, authContext);
    }

    @DeleteMapping(value={"/wikis/{wikiId}"})
    @NotNull
    public WikiDto deleteWiki(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.delete(wikiId, authContext);
    }

    @GetMapping(value={"/wikis/{wikiId}/permissions"})
    @NotNull
    public List<PermissionDto> getWikiPermissions(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.permissionApplicationService.getWikiPermissions(wikiId, authContext);
    }

    @PutMapping(value={"/wikis/{wikiId}/permissions"})
    @NotNull
    public List<PermissionDto> setWikiPermissions(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @RequestBody @NotNull List<UpdatePermissionItemDto> updatedPermissions, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(updatedPermissions, (String)"updatedPermissions");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.permissionApplicationService.setWikiPermissions(wikiId, updatedPermissions, authContext);
    }

    @GetMapping(value={"/wikis/{wikiId}/contentCount"})
    @NotNull
    public ContentCountDto getWikiContentCount(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.getContentCount(wikiId, authContext);
    }

    @GetMapping(value={"/wikis/{wikiId}/tableOfContents"})
    @NotNull
    public TableOfContentsDto getWikiTableOfContents(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @RequestParam(value="translationLanguage", required=false) @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.tableOfContentsApplicationService.read(wikiId, translationLanguage, authContext);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/wikis/{wikiId}/tableOfContents"})
    @NotNull
    public TableOfContentsDto updateWikiTableOfContents(@PathVariable(value="wikiId") @NotNull WikiId wikiId, @RequestBody @NotNull List<UpdateTableOfContentsElementDto> updatedItems, @NotNull AuthContext authContext) {
        Collection<UpdateTableOfContentsElement> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(updatedItems, (String)"updatedItems");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Iterable iterable = updatedItems;
        WikiId wikiId2 = wikiId;
        TableOfContentsApplicationService tableOfContentsApplicationService = this.tableOfContentsApplicationService;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateTableOfContentsElementDto updateTableOfContentsElementDto = (UpdateTableOfContentsElementDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UpdateTableOfContentsElement(IdUtilsKt.itemIdOf((String)it.getId()), IdUtilsKt.parentIdOf((String)it.getParentId())));
        }
        collection = (List)destination$iv$iv;
        return tableOfContentsApplicationService.update(wikiId2, (List)collection, authContext);
    }

    @GetMapping(value={"/chapters/{chapterId}/contentCount"})
    @NotNull
    public ContentCountDto getChapterContentCount(@PathVariable(value="chapterId") @NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.chapterApplicationService.getContentCount(chapterId, authContext);
    }

    @GetMapping(value={"/subscribedItems"})
    @NotNull
    public PageDto<? extends PreviewDto<?>> getSubscribedItems(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.subscriptionApplicationService.getSubscribedItems(page, pageSize, authContext);
    }
}

