/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.UserInfoApplicationService;
import de.justsoftware.wikiservice.application.model.ChapterContentDto;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.ContentCountDto;
import de.justsoftware.wikiservice.application.model.CreateOrUpdateChapterDto;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.TableOfContentsService;
import de.justsoftware.wikiservice.business.model.Chapter;
import de.justsoftware.wikiservice.business.model.Profile;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.translation.Translatable;
import de.justsoftware.wikiservice.translation.TranslationService;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0001\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J$\u0010'\u001a\u00020\u00192\u0006\u0010#\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/wikiservice/application/ChapterApplicationService;", "", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "userInfoApplicationService", "Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "tableOfContentsService", "Lde/justsoftware/wikiservice/business/TableOfContentsService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "translationService", "Lde/justsoftware/wikiservice/translation/TranslationService;", "maxChapterDepth", "", "<init>", "(Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/application/UserInfoApplicationService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/TableOfContentsService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/DeletionService;Lde/justsoftware/wikiservice/translation/TranslationService;I)V", "read", "Lde/justsoftware/wikiservice/application/model/ChapterDto;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "translationLanguage", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getContentCount", "Lde/justsoftware/wikiservice/application/model/ContentCountDto;", "create", "chapter", "Lde/justsoftware/wikiservice/application/model/CreateOrUpdateChapterDto;", "update", "delete", "toChapterDto", "Lde/justsoftware/wikiservice/business/model/Chapter;", "wiki-service"})
public class ChapterApplicationService {
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserInfoApplicationService userInfoApplicationService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final TableOfContentsService tableOfContentsService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final DeletionService deletionService;
    @NotNull
    private final TranslationService translationService;
    private final int maxChapterDepth;

    public ChapterApplicationService(@NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull ProfileService profileService, @NotNull UserInfoApplicationService userInfoApplicationService, @NotNull SubscriptionService subscriptionService, @NotNull TableOfContentsService tableOfContentsService, @NotNull AncestorService ancestorService, @NotNull DeletionService deletionService, @NotNull TranslationService translationService, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth) {
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userInfoApplicationService, (String)"userInfoApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)tableOfContentsService, (String)"tableOfContentsService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        Intrinsics.checkNotNullParameter((Object)translationService, (String)"translationService");
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.profileService = profileService;
        this.userInfoApplicationService = userInfoApplicationService;
        this.subscriptionService = subscriptionService;
        this.tableOfContentsService = tableOfContentsService;
        this.ancestorService = ancestorService;
        this.deletionService = deletionService;
        this.translationService = translationService;
        this.maxChapterDepth = maxChapterDepth;
    }

    @NotNull
    public ChapterDto read(@NotNull ChapterId chapterId, @Nullable String translationLanguage, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Chapter chapter = this.chapterService.read(chapterId);
        authContext.checkReadWiki(chapter.getWikiId());
        return this.toChapterDto(chapter, authContext, translationLanguage);
    }

    @NotNull
    public ContentCountDto getContentCount(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Chapter chapter = this.chapterService.read(chapterId);
        authContext.checkReadWiki(chapter.getWikiId());
        Set chapterIds = this.chapterService.findDescendantChapterIdsByChapterId(chapterId);
        long articleCount = this.articleService.countByParentIds(CollectionsKt.union((Iterable)chapterIds, (Iterable)SetsKt.setOf((Object)chapterId)));
        return new ContentCountDto((long)chapterIds.size(), articleCount);
    }

    @NotNull
    public ChapterDto create(@NotNull CreateOrUpdateChapterDto chapter, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ParentId parentId = chapter.getParentId();
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        authContext.checkWriteWiki(wikiId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        this.ancestorService.checkMaxNestingDepthOfNewChapter(parentId);
        return ChapterApplicationService.toChapterDto$default((ChapterApplicationService)this, (Chapter)this.chapterService.create(wikiId, parentId, chapter.getTitle(), authContext.getUser(), position), (AuthContext)authContext, null, (int)4, null);
    }

    @NotNull
    public ChapterDto update(@NotNull ChapterId chapterId, @NotNull CreateOrUpdateChapterDto chapter, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.ancestorService.getAncestorWikiId((ParentId)chapterId);
        WikiId toWikiId = this.ancestorService.getAncestorWikiId(chapter.getParentId());
        if (!Intrinsics.areEqual((Object)toWikiId, (Object)wikiId)) {
            authContext.checkMoveWikiContent(wikiId, toWikiId);
        } else {
            authContext.checkWriteWiki(wikiId);
        }
        boolean chapterWasMoved = this.ancestorService.moveChapter(chapterId, chapter.getParentId(), authContext.getUser());
        return ChapterApplicationService.toChapterDto$default((ChapterApplicationService)this, (Chapter)this.chapterService.update(chapterId, chapter.getTitle(), authContext.getUser(), chapterWasMoved), (AuthContext)authContext, null, (int)4, null);
    }

    @NotNull
    public ChapterDto delete(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Chapter chapter = this.chapterService.read(chapterId);
        authContext.checkWriteWiki(chapter.getWikiId());
        DeletionId deletionId = DeletionService.create$default((DeletionService)this.deletionService, (ItemId)((ItemId)chapterId), (ProfileId)authContext.getUser(), null, (int)4, null);
        this.chapterService.delete(chapterId, deletionId, authContext.getUser());
        return ChapterApplicationService.toChapterDto$default((ChapterApplicationService)this, (Chapter)chapter, (AuthContext)authContext, null, (int)4, null);
    }

    private ChapterDto toChapterDto(Chapter chapter, AuthContext authContext, String translationLanguage) {
        boolean isSubscribed = this.subscriptionService.readChapter(chapter.getId(), authContext.getUser()).isSubscribed();
        Map profiles = this.profileService.readByIds(SetsKt.setOfNotNull((Object)chapter.getModifiedBy()));
        ChapterContentDto chapterContent = new ChapterContentDto(chapter.getWikiId(), (ParentId)chapter.getId(), this.maxChapterDepth, this.tableOfContentsService.getSortedTOCElements((ParentId)chapter.getId(), chapter.getWikiId(), translationLanguage, authContext));
        Object v = profiles.get(chapter.getModifiedBy());
        if (v == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return ChapterDto.Companion.toDto((Chapter)this.translationService.translate((Translatable)chapter, translationLanguage, authContext.getTenantId()), chapterContent, ProfileDto.Companion.toDto((Profile)v), this.userInfoApplicationService.getUserInfo(chapter.getWikiId(), authContext), isSubscribed);
    }

    static /* synthetic */ ChapterDto toChapterDto$default(ChapterApplicationService chapterApplicationService, Chapter chapter, AuthContext authContext, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toChapterDto");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return chapterApplicationService.toChapterDto(chapter, authContext, string);
    }
}

