<#include "macros.ftl">
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
        <!-- We're using Font Awesome - http://fortawesome.github.com/Font-Awesome -->
        <meta name="gwt:property" content="locale=${locale}">
        <title>${defaultTitle}</title>

        <#-- insert point for JSS generated CSS -->
        <!-- jss -->
        <link rel="stylesheet" href="${jucoDesignResource}" id="juco-css"/>
        <link rel="stylesheet" href="${defaultThemeResourceUri}" id="${defaultThemeResource.groupName}-css"/>

        <script type="text/javascript">
        /* <![CDATA[ */
            var Toro = ${startConfig};
            window.just = window.just || {};
            window.just.context = window.just.context || {};
            window.just.context.config = ${justContext};
            window.just.context.cookieBannerEnabled = ${cookieBannerEnabled?c};
            <#if collectRequests!true>
                window.collectRequests = true;
            </#if>
            <#if profileRequests!false>
                window.profileRequests = true;
            </#if>
            <#if featureToggleJson?has_content>
                var FEATURE_TOGGLE = ${featureToggleJson};
            </#if>
        /* ]]> */
        </script>

        <@dumpOldBrowsers />

        <@includes />

        <link rel="shortcut icon" href="${favIconUrl}" type="${favIconImageType}">
        <link rel="icon" href="${favIconUrl}" type="${favIconImageType}">
        <link rel="apple-touch-icon" href="/apple-touch-icon.png">
        <link rel="apple-touch-icon" sizes="76x76" href="/apple-touch-icon-76x76.png">
        <link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon-120x120.png">
        <link rel="apple-touch-icon" sizes="152x152" href="/apple-touch-icon-152x152.png">

        <script type="text/javascript" src="${dynamicResourcePrefix}i18ndict?${i18nParams}"></script>

        <#-- Javascript am Ende laden, um Seiteneffekte durch Laden von Styles nach dem Aufbau der Seite zu vermeiden -->
        <script type="text/javascript" src="${staticResourcePrefix}com.freiheit.toro.Toro${nocacheSuffix}.nocache.js"></script>

        <script type="text/javascript">
            if (typeof justConnect == "undefined") {
                var justConnect = new Object();
            }
        </script>
        <script type="text/javascript" src="${staticResourcePrefix}colorpicker.js"></script>
    </head>

    <body class="just-loading ${(currentLayoutThemeResource.groupName)!}">
        <div id="loading-screen">
            <div id="just-loading-animation">
                <div class="just-heart">
                    <div class="just-heart-cube-invisible just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                    <div class="just-heart-cube"></div>
                </div>
             </div>
        </div>

        <div id="just-context"></div>
        <div id="notifications-list"></div>


<#if matomoURL != "" && matomoSiteId != "">
        <script>
           var _paq = _paq || [];
           _paq.push(['enableLinkTracking']);
           (function() {
             var u='${matomoURL}/';
             _paq.push(['setTrackerUrl', u+'matomo.php']);
             var userId = window.localStorage.getItem('_matomoUserId');
             if(userId===null){
                 function guid() {
                   function s4() {return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);}
                   return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
                 }
                 userId = guid();
                 window.localStorage.setItem('_matomoUserId', userId);
             }
             _paq.push(['setUserId', userId]);
             _paq.push(['setSiteId', ${matomoSiteId}]);
             var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
             g.type='text/javascript'; g.async=true; g.defer=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
           })();

           jQuery(window).on("juco.HISTORY_CHANGED",function(event,title){
             if (window.just.context.cookieBannerEnabled) {
               var tracking_allowed = /(^|; )just_tracking_v2=true(;|$)/.test(document.cookie);
               if (!tracking_allowed) {
                 return;
               }
             }
             _paq.push(['setDocumentTitle', title]);
             _paq.push(['setCustomUrl', document.location.href]);
             _paq.push(["trackPageView"]);
           });
        </script>
</#if>

        <script>
            window.just.context.init();
        </script>
    </body>
</html>
