/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.user.rebind;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import de.justsoftware.gwt.user.client.AsyncProxy;
import de.justsoftware.gwt.user.client.impl.AsyncProxyBase;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AsyncProxyGenerator
extends Generator {
    public String generate(TreeLogger logger, GeneratorContext generatorContext, String typeName) throws UnableToCompleteException {
        TypeOracle typeOracle = generatorContext.getTypeOracle();
        JClassType asyncProxyType = typeOracle.findType(AsyncProxy.class.getName());
        JClassType asyncProxyBaseType = typeOracle.findType(AsyncProxyBase.class.getName());
        JClassType sourceType = typeOracle.findType(typeName);
        this.ensureTypeExists(logger, sourceType);
        JClassType concreteType = this.getConcreteType(logger, typeOracle, sourceType);
        JClassType paramType = this.getParamType(logger, asyncProxyType, sourceType);
        this.validate(logger, sourceType, concreteType, paramType);
        String generatedSimpleSourceName = sourceType.getQualifiedSourceName().replace('.', '_').replace('$', '_') + "Impl";
        ClassSourceFileComposerFactory f = new ClassSourceFileComposerFactory(sourceType.getPackage().getName(), generatedSimpleSourceName);
        f.addImport(GWT.class.getName());
        f.addImport(RunAsyncCallback.class.getName());
        f.setSuperclass(asyncProxyBaseType.getQualifiedSourceName() + "<" + paramType.getQualifiedSourceName() + ">");
        f.addImplementedInterface(sourceType.getQualifiedSourceName());
        PrintWriter out = generatorContext.tryCreate(logger, sourceType.getPackage().getName(), generatedSimpleSourceName);
        if (out != null) {
            SourceWriter sw = f.createSourceWriter(generatorContext, out);
            sw.println("protected void doAsync0() {");
            sw.indentln("setInstance0(doCreate0());");
            sw.println("}");
            sw.println("private " + paramType.getQualifiedSourceName() + " doCreate0() {return GWT.create(" + concreteType.getQualifiedSourceName() + ".class);}");
            for (JMethod method : paramType.getOverridableMethods()) {
                if (method.getReturnType() != JPrimitiveType.VOID) {
                    logger.log(TreeLogger.ERROR, "The method " + sourceType.getQualifiedSourceName() + "." + method.getName() + " returns a type other than void.");
                    throw new UnableToCompleteException();
                }
                sw.print("public " + method.getReturnType().getQualifiedSourceName() + " " + method.getName() + "(");
                String comma = "";
                for (JParameter param : method.getParameters()) {
                    sw.print(comma + "final " + param.getType().getQualifiedSourceName() + " " + param.getName());
                    comma = ", ";
                }
                sw.println(") {");
                sw.println("if (getProxiedInstance() != null) {");
                this.writeInvocation(sw, "getProxiedInstance()", method);
                sw.println("} else {");
                sw.println("enqueue0(new ParamCommand<" + paramType.getQualifiedSourceName() + ">() {");
                sw.println("public void execute(" + paramType.getQualifiedSourceName() + " t) {");
                this.writeInvocation(sw, "t", method);
                sw.println("}});");
                sw.println("}}");
            }
            sw.commit(logger);
        }
        return f.getCreatedClassName();
    }

    private void ensureTypeExists(TreeLogger logger, JClassType sourceType) throws UnableToCompleteException {
        if (sourceType == null) {
            logger.log(TreeLogger.ERROR, "Could not find requested typeName");
            throw new UnableToCompleteException();
        }
        if (sourceType.isInterface() == null) {
            logger.log(TreeLogger.ERROR, sourceType.getQualifiedSourceName() + " is not an interface.", null);
            throw new UnableToCompleteException();
        }
    }

    @Nonnull
    private JClassType getConcreteType(TreeLogger logger, TypeOracle typeOracle, JClassType sourceType) throws UnableToCompleteException {
        AsyncProxy.ConcreteType concreteTypeAnnotation = (AsyncProxy.ConcreteType)sourceType.getAnnotation(AsyncProxy.ConcreteType.class);
        if (concreteTypeAnnotation == null) {
            logger.log(TreeLogger.ERROR, "AsnycProxy subtypes must specify a " + AsyncProxy.ConcreteType.class.getSimpleName() + " annotation.");
            throw new UnableToCompleteException();
        }
        String concreteTypeName = concreteTypeAnnotation.value().getName().replace('$', '.');
        JClassType concreteType = typeOracle.findType(concreteTypeName);
        if (concreteType == null) {
            logger.log(TreeLogger.ERROR, "Unable to find concrete type; is it in the GWT source path?");
            throw new UnableToCompleteException();
        }
        return concreteType;
    }

    @Nonnull
    private JClassType getParamType(TreeLogger logger, JClassType asyncProxyType, JClassType sourceType) throws UnableToCompleteException {
        JClassType paramType = this.getParamTypeUnchecked(asyncProxyType, sourceType);
        if (paramType == null) {
            logger.log(TreeLogger.ERROR, "Unable to determine parameterization type.");
            throw new UnableToCompleteException();
        }
        return paramType;
    }

    @CheckForNull
    private JClassType getParamTypeUnchecked(JClassType asyncProxyType, JClassType sourceType) {
        for (JClassType intr : sourceType.getImplementedInterfaces()) {
            JParameterizedType isParameterized = intr.isParameterized();
            if (isParameterized == null || !isParameterized.getBaseType().equals(asyncProxyType)) continue;
            return isParameterized.getTypeArgs()[0];
        }
        return null;
    }

    private void validate(TreeLogger logger, JClassType sourceType, JClassType concreteType, JClassType paramType) throws UnableToCompleteException {
        if (sourceType.getMethods().length > 0) {
            logger.log(TreeLogger.ERROR, "AsyncProxy subtypes may not define any additional methods");
            throw new UnableToCompleteException();
        }
        if (!sourceType.isAssignableTo(paramType)) {
            logger.log(TreeLogger.ERROR, "Expecting " + sourceType.getQualifiedSourceName() + " to implement " + paramType.getQualifiedSourceName());
            throw new UnableToCompleteException();
        }
        if (!concreteType.isAssignableTo(paramType)) {
            logger.log(TreeLogger.ERROR, "Expecting concrete type" + concreteType.getQualifiedSourceName() + " to implement " + paramType.getQualifiedSourceName());
            throw new UnableToCompleteException();
        }
        if (concreteType.isMemberType() && !concreteType.isStatic()) {
            logger.log(TreeLogger.ERROR, "Expecting concrete type " + concreteType.getQualifiedSourceName() + " to be static.");
            throw new UnableToCompleteException();
        }
    }

    private void writeInvocation(SourceWriter sw, String qualifier, JMethod method) {
        sw.print(qualifier + "." + method.getName() + "(");
        Iterator<JParameter> i = Arrays.asList(method.getParameters()).iterator();
        while (i.hasNext()) {
            JParameter param = i.next();
            sw.print(param.getName());
            if (!i.hasNext()) continue;
            sw.print(", ");
        }
        sw.println(");");
    }
}

