/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.deepl.DeepLConnector;
import de.justsoftware.news.connector.deepl.TranslationResult;
import de.justsoftware.news.connector.superoperty.SuperopertyConnector;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.PostTranslationService;
import de.justsoftware.news.domain.post.TranslatablePostData;
import de.justsoftware.news.domain.tenant.Tenant;
import de.justsoftware.news.domain.tenant.TenantService;
import de.justsoftware.news.domain.translation.TranslationRepo;
import de.justsoftware.news.domain.translation.model.TranslationContext;
import de.justsoftware.news.domain.translation.model.TranslationContextKt;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J-\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0012\u00a2\u0006\u0004\b\u0019\u0010\u001aJ,\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001dH\u0012J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/news/domain/post/PostTranslationService;", "", "superopertyConnector", "Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;", "tenantService", "Lde/justsoftware/news/domain/tenant/TenantService;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "translationRepo", "Lde/justsoftware/news/domain/translation/TranslationRepo;", "deepLConnector", "Lde/justsoftware/news/connector/deepl/DeepLConnector;", "<init>", "(Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;Lde/justsoftware/news/domain/tenant/TenantService;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/translation/TranslationRepo;Lde/justsoftware/news/connector/deepl/DeepLConnector;)V", "translate", "Lde/justsoftware/news/domain/post/Post;", "post", "targetLanguage", "", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "doTranslate", "Lkotlin/Result;", "tenantId", "Lde/justsoftware/news/id/TenantId;", "doTranslate-0E7RQCE", "(Lde/justsoftware/news/domain/post/Post;Ljava/lang/String;Lde/justsoftware/news/id/TenantId;)Ljava/lang/Object;", "translatePostData", "Lkotlin/Pair;", "Lde/justsoftware/news/domain/post/TranslatablePostData;", "deepLApiKey", "postData", "deleteTranslations", "", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostTranslationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostTranslationService.kt\nde/justsoftware/news/domain/post/PostTranslationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
public class PostTranslationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final TranslationRepo translationRepo;
    @NotNull
    private final DeepLConnector deepLConnector;
    @NotNull
    private static final Logger log;

    public PostTranslationService(@NotNull SuperopertyConnector superopertyConnector, @NotNull TenantService tenantService, @NotNull PostRepo postRepo, @NotNull TranslationRepo translationRepo, @NotNull DeepLConnector deepLConnector) {
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)translationRepo, (String)"translationRepo");
        Intrinsics.checkNotNullParameter((Object)deepLConnector, (String)"deepLConnector");
        this.superopertyConnector = superopertyConnector;
        this.tenantService = tenantService;
        this.postRepo = postRepo;
        this.translationRepo = translationRepo;
        this.deepLConnector = deepLConnector;
    }

    @Transactional
    @NotNull
    public Post translate(@NotNull Post post, @Nullable String targetLanguage, @NotNull AuthorizationContext authContext) {
        Post post2;
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (targetLanguage != null && !Intrinsics.areEqual((Object)targetLanguage, (Object)post.getSourceLanguage()) && this.superopertyConnector.getBackendTranslationEnabled()) {
            Object object;
            Object object2 = this.doTranslate-0E7RQCE(post, targetLanguage, authContext.getTenantId());
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                TranslationContextKt.logTranslationException((Logger)log, (Throwable)it);
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 == null) {
                object = object2;
            } else {
                Throwable it = throwable3;
                boolean bl = false;
                object = Post.copy$default((Post)post, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, null, (TranslationContext)TranslationContextKt.untranslatedWithError((Object)post, (String)post.getSourceLanguage(), (String)targetLanguage, (Throwable)it), (int)524287, null);
            }
            post2 = (Post)object;
        } else {
            post2 = Post.copy$default((Post)post, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, null, (TranslationContext)TranslationContextKt.untranslated((Object)post, (String)post.getSourceLanguage(), (String)targetLanguage), (int)524287, null);
        }
        return post2;
    }

    private Object doTranslate-0E7RQCE(Post post, String targetLanguage, TenantId tenantId) {
        Object object;
        PostTranslationService postTranslationService = this;
        try {
            Post post2;
            PostTranslationService $this$doTranslate_0E7RQCE_u24lambda_u242 = postTranslationService;
            boolean bl = false;
            Map existingTranslations = $this$doTranslate_0E7RQCE_u24lambda_u242.translationRepo.getTranslations((ItemId)post.getId(), targetLanguage);
            if (!existingTranslations.isEmpty()) {
                String string;
                String string2 = (String)existingTranslations.get("title");
                if (string2 == null) {
                    string2 = post.getTitle();
                }
                if ((string = (String)existingTranslations.get("jsonContent")) == null) {
                    string = post.getJsonContent();
                }
                post2 = Post.copy$default((Post)post, null, null, null, null, null, (String)string2, null, (String)string, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, null, (TranslationContext)TranslationContextKt.translated((Object)post, (String)post.getSourceLanguage(), (String)targetLanguage), (int)524127, null);
            } else {
                String deepLApiKey;
                Tenant tenant = $this$doTranslate_0E7RQCE_u24lambda_u242.tenantService.findById(tenantId);
                String string = deepLApiKey = tenant != null ? tenant.getDeeplKey() : null;
                if (deepLApiKey == null) {
                    post2 = Post.copy$default((Post)post, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, null, (TranslationContext)TranslationContextKt.untranslated((Object)post, (String)post.getSourceLanguage(), (String)targetLanguage), (int)524287, null);
                } else {
                    String sourceLanguage;
                    String string3;
                    Pair pair = $this$doTranslate_0E7RQCE_u24lambda_u242.translatePostData(targetLanguage, deepLApiKey, new TranslatablePostData(post.getTitle(), post.getJsonContent()));
                    String detectedSourceLanguage = (String)pair.component1();
                    TranslatablePostData translatedPostData = (TranslatablePostData)pair.component2();
                    if (post.getSourceLanguage() == null) {
                        $this$doTranslate_0E7RQCE_u24lambda_u242.postRepo.setSourceLanguage(post.getId(), detectedSourceLanguage);
                    }
                    if ((string3 = post.getSourceLanguage()) == null) {
                        string3 = detectedSourceLanguage;
                    }
                    if (!Intrinsics.areEqual((Object)(sourceLanguage = string3), (Object)targetLanguage)) {
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"title", (Object)translatedPostData.getTitle()), TuplesKt.to((Object)"jsonContent", (Object)translatedPostData.getJsonContent())};
                        $this$doTranslate_0E7RQCE_u24lambda_u242.translationRepo.insertTranslations((ItemId)post.getId(), targetLanguage, MapsKt.mapOf((Pair[])pairArray));
                        post2 = Post.copy$default((Post)post, null, null, null, null, null, (String)translatedPostData.getTitle(), null, (String)translatedPostData.getJsonContent(), null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, null, (TranslationContext)TranslationContextKt.translated((Object)post, (String)sourceLanguage, (String)targetLanguage), (int)524127, null);
                    } else {
                        post2 = Post.copy$default((Post)post, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, null, (boolean)false, null, null, (boolean)false, null, (TranslationContext)TranslationContextKt.untranslated((Object)post, (String)sourceLanguage, (String)targetLanguage), (int)524287, null);
                    }
                }
            }
            object = Result.constructor-impl((Object)post2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private Pair<String, TranslatablePostData> translatePostData(String targetLanguage, String deepLApiKey, TranslatablePostData postData) {
        TranslationResult translatedTitle = this.deepLConnector.translateText(postData.getTitle(), null, targetLanguage, deepLApiKey);
        TranslationResult translatedJsonContent = this.deepLConnector.translateQuillDelta(postData.getJsonContent(), null, targetLanguage, deepLApiKey);
        return TuplesKt.to((Object)translatedJsonContent.getDetectedSourceLanguage(), (Object)new TranslatablePostData(translatedTitle.getText(), translatedJsonContent.getText()));
    }

    public void deleteTranslations(@NotNull Post post) {
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        this.translationRepo.deleteTranslations((ItemId)post.getId());
    }

    static {
        Logger logger = LoggerFactory.getLogger(PostTranslationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

