/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.connector.deepl.DeepLConnector;
import de.justsoftware.news.connector.deepl.TranslationResult;
import de.justsoftware.news.connector.superoperty.SuperopertyConnector;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.comment.PostCommentTranslationService;
import de.justsoftware.news.domain.tenant.Tenant;
import de.justsoftware.news.domain.tenant.TenantService;
import de.justsoftware.news.domain.translation.TranslationRepo;
import de.justsoftware.news.domain.translation.model.TranslationContext;
import de.justsoftware.news.domain.translation.model.TranslationContextKt;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.TenantId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J-\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentTranslationService;", "", "superopertyConnector", "Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;", "tenantService", "Lde/justsoftware/news/domain/tenant/TenantService;", "postCommentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "deepLConnector", "Lde/justsoftware/news/connector/deepl/DeepLConnector;", "translationRepo", "Lde/justsoftware/news/domain/translation/TranslationRepo;", "<init>", "(Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;Lde/justsoftware/news/domain/tenant/TenantService;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/connector/deepl/DeepLConnector;Lde/justsoftware/news/domain/translation/TranslationRepo;)V", "translate", "Lde/justsoftware/news/domain/comment/PostComment;", "comment", "targetLanguage", "", "tenantId", "Lde/justsoftware/news/id/TenantId;", "doTranslate", "Lkotlin/Result;", "doTranslate-0E7RQCE", "(Lde/justsoftware/news/domain/comment/PostComment;Ljava/lang/String;Lde/justsoftware/news/id/TenantId;)Ljava/lang/Object;", "deleteTranslations", "", "needsTranslation", "", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nPostCommentTranslationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PostCommentTranslationService.kt\nde/justsoftware/news/domain/comment/PostCommentTranslationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public class PostCommentTranslationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final PostCommentRepo postCommentRepo;
    @NotNull
    private final DeepLConnector deepLConnector;
    @NotNull
    private final TranslationRepo translationRepo;
    @NotNull
    private static final Logger log;

    public PostCommentTranslationService(@NotNull SuperopertyConnector superopertyConnector, @NotNull TenantService tenantService, @NotNull PostCommentRepo postCommentRepo, @NotNull DeepLConnector deepLConnector, @NotNull TranslationRepo translationRepo) {
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)postCommentRepo, (String)"postCommentRepo");
        Intrinsics.checkNotNullParameter((Object)deepLConnector, (String)"deepLConnector");
        Intrinsics.checkNotNullParameter((Object)translationRepo, (String)"translationRepo");
        this.superopertyConnector = superopertyConnector;
        this.tenantService = tenantService;
        this.postCommentRepo = postCommentRepo;
        this.deepLConnector = deepLConnector;
        this.translationRepo = translationRepo;
    }

    @Transactional
    @NotNull
    public PostComment translate(@NotNull PostComment comment, @Nullable String targetLanguage, @NotNull TenantId tenantId) {
        PostComment postComment;
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (this.superopertyConnector.getBackendTranslationEnabled() && targetLanguage != null && this.needsTranslation(comment, targetLanguage)) {
            Object object;
            Object object2 = this.doTranslate-0E7RQCE(comment, targetLanguage, tenantId);
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                TranslationContextKt.logTranslationException((Logger)log, (Throwable)it);
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 == null) {
                object = object2;
            } else {
                Throwable it = throwable3;
                boolean bl = false;
                object = PostComment.copy$default((PostComment)comment, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, (TranslationContext)TranslationContextKt.untranslatedWithError((Object)comment, (String)comment.getSourceLanguage(), (String)targetLanguage, (Throwable)it), (int)16383, null);
            }
            postComment = (PostComment)object;
        } else {
            postComment = PostComment.copy$default((PostComment)comment, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, (TranslationContext)TranslationContextKt.untranslated((Object)comment, (String)comment.getSourceLanguage(), (String)targetLanguage), (int)16383, null);
        }
        return postComment;
    }

    private Object doTranslate-0E7RQCE(PostComment comment, String targetLanguage, TenantId tenantId) {
        Object object;
        PostCommentTranslationService postCommentTranslationService = this;
        try {
            PostComment postComment;
            PostCommentTranslationService $this$doTranslate_0E7RQCE_u24lambda_u242 = postCommentTranslationService;
            boolean bl = false;
            if (comment.getJsonContent() == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Map existingTranslations = $this$doTranslate_0E7RQCE_u24lambda_u242.translationRepo.getTranslations((ItemId)comment.getId(), targetLanguage);
            if (!existingTranslations.isEmpty()) {
                String string = (String)existingTranslations.get("jsonContent");
                if (string == null) {
                    string = comment.getJsonContent();
                }
                postComment = PostComment.copy$default((PostComment)comment, null, null, null, null, null, null, null, null, (String)string, null, (boolean)false, null, null, null, (TranslationContext)TranslationContextKt.translated((Object)comment, (String)comment.getSourceLanguage(), (String)targetLanguage), (int)16127, null);
            } else {
                String deepLApiKey;
                Tenant tenant = $this$doTranslate_0E7RQCE_u24lambda_u242.tenantService.findById(tenantId);
                String string = deepLApiKey = tenant != null ? tenant.getDeeplKey() : null;
                if (deepLApiKey == null) {
                    postComment = PostComment.copy$default((PostComment)comment, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, (TranslationContext)TranslationContextKt.untranslated((Object)comment, (String)comment.getSourceLanguage(), (String)targetLanguage), (int)16383, null);
                } else {
                    String sourceLanguage;
                    String string2;
                    TranslationResult translationResult = $this$doTranslate_0E7RQCE_u24lambda_u242.deepLConnector.translateQuillDelta(comment.getJsonContent(), null, targetLanguage, deepLApiKey);
                    String translatedJsonContent = translationResult.component1();
                    String detectedSourceLanguage = translationResult.component2();
                    if (comment.getSourceLanguage() == null) {
                        $this$doTranslate_0E7RQCE_u24lambda_u242.postCommentRepo.updateSourceLanguage(comment.getId(), detectedSourceLanguage);
                    }
                    if ((string2 = comment.getSourceLanguage()) == null) {
                        string2 = detectedSourceLanguage;
                    }
                    if (!Intrinsics.areEqual((Object)(sourceLanguage = string2), (Object)targetLanguage)) {
                        $this$doTranslate_0E7RQCE_u24lambda_u242.translationRepo.insertTranslations((ItemId)comment.getId(), targetLanguage, MapsKt.mapOf((Pair)TuplesKt.to((Object)"jsonContent", (Object)translatedJsonContent)));
                        postComment = PostComment.copy$default((PostComment)comment, null, null, null, null, null, null, null, null, (String)translatedJsonContent, null, (boolean)false, null, null, null, (TranslationContext)TranslationContextKt.translated((Object)comment, (String)sourceLanguage, (String)targetLanguage), (int)16127, null);
                    } else {
                        postComment = PostComment.copy$default((PostComment)comment, null, null, null, null, null, null, null, null, null, null, (boolean)false, null, null, null, (TranslationContext)TranslationContextKt.untranslated((Object)comment, (String)sourceLanguage, (String)targetLanguage), (int)16383, null);
                    }
                }
            }
            object = Result.constructor-impl((Object)postComment);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    public void deleteTranslations(@NotNull PostComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.translationRepo.deleteTranslations((ItemId)comment.getId());
    }

    private boolean needsTranslation(PostComment $this$needsTranslation, String targetLanguage) {
        Object object;
        return !Intrinsics.areEqual((Object)$this$needsTranslation.getSourceLanguage(), (Object)targetLanguage) && !$this$needsTranslation.getDeleted() && ((object = $this$needsTranslation.getText()) != null && (object = ((String)object).codePoints()) != null ? object.anyMatch(PostCommentTranslationService::needsTranslation$lambda$3) : false);
    }

    private static final boolean needsTranslation$lambda$3(int codePoint) {
        return Character.isLetter(codePoint);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PostCommentTranslationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

