/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.notification;

import de.justsoftware.news.connector.notification.MailInfo;
import de.justsoftware.news.connector.notification.NewsNotificationProducer;
import de.justsoftware.news.connector.notification.NotificationConnector;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsReceivers;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.domain.settings.SettingsRepo;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.events.PostCommentCreatedEvent;
import de.justsoftware.news.events.PostCommentUpdatedMentionsEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostReadEvent;
import de.justsoftware.news.events.PostUpdatedMentions;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.LikeableId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.util.QuillUtils;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Observed
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0017J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001fH\u0017J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!H\u0017J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020#H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00158\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/news/connector/notification/NotificationConnector;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "commentNotificationsRepo", "Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "settingsRepo", "Lde/justsoftware/news/domain/settings/SettingsRepo;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/domain/settings/SettingsRepo;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lde/justsoftware/news/domain/reaction/ReactionRepo;)V", "notificationProducer", "Lde/justsoftware/news/connector/notification/NewsNotificationProducer;", "postPublished", "", "event", "Lde/justsoftware/news/events/PostPublishedEvent;", "postRead", "Lde/justsoftware/news/events/PostReadEvent;", "postDeleted", "Lde/justsoftware/news/events/PostDeletedEvent;", "postUpdatedMentions", "Lde/justsoftware/news/events/PostUpdatedMentions;", "postCommentCreated", "Lde/justsoftware/news/events/PostCommentCreatedEvent;", "postCommentUpdatedMentions", "Lde/justsoftware/news/events/PostCommentUpdatedMentionsEvent;", "Companion", "news-service"})
@SourceDebugExtension(value={"SMAP\nNotificationConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationConnector.kt\nde/justsoftware/news/connector/notification/NotificationConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,407:1\n1#2:408\n774#3:409\n865#3,2:410\n774#3:412\n865#3,2:413\n1563#3:415\n1634#3,3:416\n1563#3:419\n1634#3,3:420\n1563#3:423\n1634#3,3:424\n*S KotlinDebug\n*F\n+ 1 NotificationConnector.kt\nde/justsoftware/news/connector/notification/NotificationConnector\n*L\n71#1:409\n71#1:410,2\n96#1:412\n96#1:413,2\n163#1:415\n163#1:416,3\n180#1:419\n180#1:420,3\n184#1:423\n184#1:424,3\n*E\n"})
public class NotificationConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final CommentNotificationsRepo commentNotificationsRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final SettingsRepo settingsRepo;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final ReactionRepo reactionRepo;
    @Autowired
    private NewsNotificationProducer notificationProducer;
    @NotNull
    private static final Logger log;

    public NotificationConnector(@NotNull ChannelRepo channelRepo, @NotNull PostCommentRepo commentRepo, @NotNull CommentNotificationsRepo commentNotificationsRepo, @NotNull PostRepo postRepo, @NotNull ProfileRepo profileRepo, @NotNull SettingsRepo settingsRepo, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull ReactionRepo reactionRepo) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        Intrinsics.checkNotNullParameter((Object)commentNotificationsRepo, (String)"commentNotificationsRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)settingsRepo, (String)"settingsRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        this.channelRepo = channelRepo;
        this.commentRepo = commentRepo;
        this.commentNotificationsRepo = commentNotificationsRepo;
        this.postRepo = postRepo;
        this.profileRepo = profileRepo;
        this.settingsRepo = settingsRepo;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.reactionRepo = reactionRepo;
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener(value={PostPublishedEvent.class})
    public void postPublished(@NotNull PostPublishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ProfileId it;
            void $this$filterTo$iv$iv2;
            boolean it2 = event.getHasBeenMovedToAnotherChannel();
            boolean bl = false;
            NewsNotificationProducer newsNotificationProducer = this.notificationProducer;
            if (newsNotificationProducer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                newsNotificationProducer = null;
            }
            newsNotificationProducer.deleteAll(event.getPost().getId());
            if (!event.getCreateNotification()) {
                return;
            }
            Iterable $this$filter$iv2 = this.subscriptionRepoWrapper.getNotificationSubscribers(event.getPost().getChannelId());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ProfileId)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)event.getPost().getAuthorId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List channelSubscribers = (List)destination$iv$iv;
            Profile author = this.profileRepo.getById(event.getPost().getAuthorId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(event.getPost().getChannelId());
            boolean allowAdditionalInfoInMailNotification = this.settingsRepo.getByTenantId(event.getTenantId()).getAllowAdditionalInfoInMailNotification();
            MailInfo additionalMailInfo = allowAdditionalInfoInMailNotification ? new MailInfo(author.getName(), event.getPost().getText()) : null;
            NewsNotificationProducer newsNotificationProducer2 = this.notificationProducer;
            if (newsNotificationProducer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                newsNotificationProducer2 = null;
            }
            newsNotificationProducer2.sendForPublishedPost(event.getTenantId(), channel.getTitle(), event.getPost(), author, (Collection)channelSubscribers, additionalMailInfo);
            Iterable iterable2 = QuillUtils.INSTANCE.extractMentions(event.getPost().getJsonContent());
            boolean $i$f$filter2 = false;
            it = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UserId it3 = (UserId)element$iv$iv;
                boolean bl3 = false;
                if (!(!CollectionsKt.contains((Iterable)channelSubscribers, (Object)it3))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List mentions = (List)destination$iv$iv2;
            NewsNotificationProducer newsNotificationProducer3 = this.notificationProducer;
            if (newsNotificationProducer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                newsNotificationProducer3 = null;
            }
            newsNotificationProducer3.sendForMentionedInPost(event.getTenantId(), channel.getTitle(), event.getPost(), author, (Collection)mentions);
        }
        catch (Exception exception) {
            log.error("Error sending notifications for published Post.", (Throwable)exception);
        }
    }

    @Async
    @EventListener(value={PostReadEvent.class})
    public void postRead(@NotNull PostReadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NewsNotificationProducer newsNotificationProducer = this.notificationProducer;
        if (newsNotificationProducer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
            newsNotificationProducer = null;
        }
        newsNotificationProducer.archiveAll(event.getPostId(), event.getProfileId());
    }

    @Async
    @EventListener(value={PostDeletedEvent.class})
    public void postDeleted(@NotNull PostDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        NewsNotificationProducer newsNotificationProducer = this.notificationProducer;
        if (newsNotificationProducer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
            newsNotificationProducer = null;
        }
        newsNotificationProducer.deleteAll(event.getPostId());
    }

    @Async
    @EventListener(value={PostUpdatedMentions.class})
    public void postUpdatedMentions(@NotNull PostUpdatedMentions event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Profile author = this.profileRepo.getById(event.getPost().getAuthorId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(event.getPost().getChannelId());
            NewsNotificationProducer newsNotificationProducer = this.notificationProducer;
            if (newsNotificationProducer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                newsNotificationProducer = null;
            }
            newsNotificationProducer.sendForMentionedInPost(event.getTenantId(), channel.getTitle(), event.getPost(), author, event.getNewMentions());
        }
        catch (Exception exception) {
            log.error("Error sending notifications for new mentions in updated Comment.", (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener(value={PostCommentCreatedEvent.class})
    public void postCommentCreated(@NotNull PostCommentCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Post post = this.postRepo.getByIdAndDeletedFalse(event.getPostId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(post.getChannelId());
            Profile commentAuthor = this.profileRepo.getById(event.getAuthorId());
            CommentNotificationsReceivers commentNotificationsReceivers = this.commentNotificationsRepo.getProfileIds(post.getId());
            Set profilesNotificationOn = commentNotificationsReceivers.component1();
            Set profilesNotificationOff = commentNotificationsReceivers.component2();
            Set mentions = QuillUtils.INSTANCE.extractMentions(event.getJsonContent());
            NewsNotificationProducer newsNotificationProducer = this.notificationProducer;
            if (newsNotificationProducer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                newsNotificationProducer = null;
            }
            newsNotificationProducer.sendForMentionedInComment(event.getTenantId(), channel.getTitle(), post, commentAuthor, (Collection)mentions);
            Set noReceivers = SetsKt.plus((Set)SetsKt.plus((Set)profilesNotificationOff, (Object)event.getAuthorId()), (Iterable)mentions);
            if (event.getParentId() instanceof CommentId) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ProfileId initialCommentAuthor = this.commentRepo.getById((CommentId)event.getParentId()).getAuthorId();
                Iterable iterable = this.commentRepo.findAllByParentIdOrderByCreatedAtAsc((ItemId)event.getParentId());
                boolean $i$f$map = false;
                void var14_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    PostComment postComment = (PostComment)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getAuthorId());
                }
                Set otherAnsweringAuthors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Set receivers = SetsKt.minus((Set)SetsKt.plus((Set)SetsKt.plus((Set)profilesNotificationOn, (Iterable)otherAnsweringAuthors), (Object)initialCommentAuthor), (Iterable)noReceivers);
                NewsNotificationProducer newsNotificationProducer2 = this.notificationProducer;
                if (newsNotificationProducer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                    newsNotificationProducer2 = null;
                }
                newsNotificationProducer2.sendForNewCommentResponse(event.getTenantId(), channel.getTitle(), post, commentAuthor, (Collection)receivers);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable otherAnsweringAuthors = this.reactionRepo.findAllByItemId((LikeableId)event.getPostId());
                boolean $i$f$map22 = false;
                void $i$f$map = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Object item$iv$iv2 = (Reaction)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getProfileId());
                }
                Set likers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Iterable $i$f$map22 = this.commentRepo.findAllByParentIdOrderByCreatedAtAsc((ItemId)event.getPostId());
                boolean $i$f$map3 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    PostComment bl = (PostComment)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getAuthorId());
                }
                Set commentators = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                Set receivers = SetsKt.minus((Set)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)profilesNotificationOn, (Iterable)likers), (Iterable)commentators), (Object)post.getAuthorId()), (Iterable)noReceivers);
                NewsNotificationProducer newsNotificationProducer3 = this.notificationProducer;
                if (newsNotificationProducer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                    newsNotificationProducer3 = null;
                }
                newsNotificationProducer3.sendForNewComment(event.getTenantId(), channel.getTitle(), post, commentAuthor, (Collection)receivers);
            }
        }
        catch (Exception exception) {
            log.error("Error sending notifications for new Comment.", (Throwable)exception);
        }
    }

    @Async
    @EventListener(value={PostCommentUpdatedMentionsEvent.class})
    public void postCommentUpdatedMentions(@NotNull PostCommentUpdatedMentionsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Post post = this.postRepo.getByIdAndDeletedFalse(event.getPostId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(post.getChannelId());
            Profile author = this.profileRepo.getById(post.getAuthorId());
            NewsNotificationProducer newsNotificationProducer = this.notificationProducer;
            if (newsNotificationProducer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProducer");
                newsNotificationProducer = null;
            }
            newsNotificationProducer.sendForMentionedInComment(event.getTenantId(), channel.getTitle(), post, author, event.getNewMentions());
        }
        catch (Exception exception) {
            log.error("Error sending notifications for mentions in updated Comment.", (Throwable)exception);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(NotificationConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

