/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.auth;

import de.justsoftware.news.auth.AuthSettingsService;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.auth.exceptions.NotAuthorizedException;
import de.justsoftware.news.connector.permission.PermissionConnector;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentAction;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.permission.client.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ6\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016J6\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016JD\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00130\u00112\u0006\u0010 \u001a\u00020\u00122\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050\u00112\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0014\u0010&\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u0016J\u001c\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0016J\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016J\u0016\u0010-\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0014J\u0016\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u001aJ\u001e\u00101\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00122\u0006\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020\u001fJ\u000e\u00104\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u00105\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u00106\u001a\u0002072\u0006\u0010 \u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0014J\u0006\u00108\u001a\u000207J\u000e\u00109\u001a\u0002072\u0006\u0010$\u001a\u00020%J\u000e\u0010:\u001a\u0002072\u0006\u0010$\u001a\u00020%J\u0014\u0010;\u001a\u0002072\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u0016J\u0006\u0010<\u001a\u000207J\u0006\u0010=\u001a\u00020#J\u000e\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/justsoftware/news/auth/AuthorizationContext;", "", "tenantId", "Lde/justsoftware/news/id/TenantId;", "user", "Lde/justsoftware/news/id/ProfileId;", "authSettingsService", "Lde/justsoftware/news/auth/AuthSettingsService;", "permissionConnector", "Lde/justsoftware/news/connector/permission/PermissionConnector;", "<init>", "(Lde/justsoftware/news/id/TenantId;Lde/justsoftware/news/id/ProfileId;Lde/justsoftware/news/auth/AuthSettingsService;Lde/justsoftware/news/connector/permission/PermissionConnector;)V", "getTenantId", "()Lde/justsoftware/news/id/TenantId;", "getUser", "()Lde/justsoftware/news/id/ProfileId;", "getChannelActions", "", "Lde/justsoftware/news/id/ChannelId;", "", "Lde/justsoftware/news/domain/channel/ChannelAction;", "channelIds", "", "actions", "getPostActions", "Lde/justsoftware/news/id/PostId;", "Lde/justsoftware/news/domain/post/model/PostAction;", "posts", "Lde/justsoftware/news/domain/post/Post;", "getPostCommentActions", "Lde/justsoftware/news/id/CommentId;", "Lde/justsoftware/news/domain/comment/PostCommentAction;", "channelId", "commentIdToAuthorId", "checkRead", "", "itemId", "Lde/justsoftware/news/id/ItemId;", "checkReadAll", "itemIds", "checkAllReader", "granteeIds", "Lde/justsoftware/news/id/UserId;", "filterReadable", "", "checkChannelAction", "action", "checkPostAction", "post", "checkPostCommentAction", "comment", "Lde/justsoftware/news/domain/comment/PostComment;", "checkManage", "checkWrite", "mayChannelAction", "", "isSuperAdmin", "mayRead", "mayManage", "mayManageAll", "mayCreateChannel", "checkCreateChannel", "checkUserEqual", "profileId", "news-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContext.kt\nde/justsoftware/news/auth/AuthorizationContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,222:1\n1563#2:223\n1634#2,3:224\n1563#2:227\n1634#2,3:228\n1285#2,2:231\n1299#2,2:233\n774#2:235\n865#2,2:236\n1302#2:238\n1563#2:239\n1634#2,3:240\n1563#2:243\n1634#2,3:244\n1563#2:247\n1634#2,3:248\n1563#2:251\n1634#2,3:252\n1285#2,2:255\n1299#2,2:257\n774#2:259\n865#2,2:260\n1302#2:262\n1252#2,4:265\n1252#2,2:271\n774#2:273\n865#2,2:274\n1255#2:276\n480#3:263\n426#3:264\n465#3:269\n415#3:270\n538#3:277\n523#3,6:278\n126#4:284\n153#4,3:285\n*S KotlinDebug\n*F\n+ 1 AuthorizationContext.kt\nde/justsoftware/news/auth/AuthorizationContext\n*L\n36#1:223\n36#1:224,3\n37#1:227\n37#1:228,3\n55#1:231,2\n55#1:233,2\n59#1:235\n59#1:236,2\n55#1:238\n83#1:239\n83#1:240,3\n84#1:243\n84#1:244,3\n89#1:247\n89#1:248,3\n94#1:251\n94#1:252,3\n104#1:255,2\n104#1:257,2\n108#1:259\n108#1:260,2\n104#1:262\n125#1:265,4\n147#1:271,2\n150#1:273\n150#1:274,2\n147#1:276\n125#1:263\n125#1:264\n147#1:269\n147#1:270\n169#1:277\n169#1:278,6\n170#1:284\n170#1:285,3\n*E\n"})
public final class AuthorizationContext {
    @NotNull
    private final TenantId tenantId;
    @NotNull
    private final ProfileId user;
    @NotNull
    private final AuthSettingsService authSettingsService;
    @NotNull
    private final PermissionConnector permissionConnector;

    public AuthorizationContext(@NotNull TenantId tenantId, @NotNull ProfileId user, @NotNull AuthSettingsService authSettingsService, @NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)authSettingsService, (String)"authSettingsService");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.tenantId = tenantId;
        this.user = user;
        this.authSettingsService = authSettingsService;
        this.permissionConnector = permissionConnector;
    }

    @NotNull
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public final ProfileId getUser() {
        return this.user;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ChannelId, Set<ChannelAction>> getChannelActions(@NotNull Collection<ChannelId> channelIds, @NotNull Collection<? extends ChannelAction> actions) {
        void $this$associateWith$iv;
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Iterable $this$map$iv = channelIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ChannelId channelId = (ChannelId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(Role.write((String)it.toTypedString()));
        }
        List writeChannels = (List)destination$iv$iv;
        Iterable $this$map$iv2 = channelIds;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelId bl = (ChannelId)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(Role.manage((String)it.toTypedString()));
        }
        List manageChannels = (List)destination$iv$iv2;
        Role role = Role.manage((String)this.tenantId.toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"manage(...)");
        Role manageTenant = role;
        Role role2 = Role.noInteract((String)this.tenantId.toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role2, (String)"noInteract(...)");
        Role noInteract = role2;
        Set onlyChannelManagersMayPin = actions.contains(ChannelAction.PIN_POST) ? this.authSettingsService.filterOnlyManagersMayPin(channelIds) : SetsKt.emptySet();
        List rolesToCheckPermission = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)writeChannels, (Iterable)manageChannels), (Object)manageTenant), (Object)noInteract);
        Set usersRoles = this.permissionConnector.filterUsersRoles((Collection)rolesToCheckPermission, (UserId)this.user);
        boolean mayInteractTenant = !usersRoles.contains(noInteract);
        boolean mayManageTenant = usersRoles.contains(manageTenant);
        Iterable it = channelIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void channelId;
            ChannelId channelId2 = (ChannelId)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            boolean mayWriteChannel = usersRoles.contains(Role.write((String)channelId.toTypedString()));
            boolean mayManageChannel = usersRoles.contains(Role.manage((String)channelId.toTypedString()));
            Iterable $this$filter$iv = actions;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ChannelAction action = (ChannelAction)element$iv$iv2;
                boolean bl3 = false;
                if (!(switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                    case 1 -> mayManageChannel;
                    case 2 -> mayManageChannel;
                    case 3 -> mayManageChannel;
                    case 4 -> mayWriteChannel;
                    case 5 -> {
                        if (mayManageTenant || this.authSettingsService.allMayReadSubscribers(this.tenantId)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 6 -> mayManageChannel;
                    case 7 -> {
                        if (mayInteractTenant && mayWriteChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    case 8 -> {
                        if (mayInteractTenant && mayWriteChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    case 9 -> {
                        if (onlyChannelManagersMayPin.contains(channelId)) {
                            yield mayManageChannel;
                        }
                        if (mayInteractTenant && mayWriteChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                })) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            object.put(t, set);
        }
        return result$iv;
    }

    public static /* synthetic */ Map getChannelActions$default(AuthorizationContext authorizationContext, Collection collection, Collection collection2, int n, Object object) {
        if ((n & 2) != 0) {
            collection2 = CollectionsKt.toSet((Iterable)((Iterable)ChannelAction.getEntries()));
        }
        return authorizationContext.getChannelActions(collection, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<PostId, Set<PostAction>> getPostActions(@NotNull Collection<Post> posts2, @NotNull Collection<? extends PostAction> actions) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Object object;
        Object $this$filter$iv;
        Map $this$associateWith$iv;
        void $this$mapTo$iv$iv;
        Set set;
        Iterable iterable;
        Iterable destination$iv$iv;
        Iterable $this$mapTo$iv$iv2;
        Object object2;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(posts2, (String)"posts");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Iterable $this$map$iv = posts2;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            Post post = (Post)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add(Role.read((String)it.getChannelId().toTypedString()));
        }
        List readChannels = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = posts2;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Post bl = (Post)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl2 = false;
            object2.add(Role.manage((String)it.getId().toTypedString()));
        }
        List managePosts = (List)destination$iv$iv3;
        Role role = Role.noInteract((String)this.tenantId.toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"noInteract(...)");
        Role noInteract = role;
        if (actions.contains(PostAction.PIN)) {
            void $this$mapTo$iv$iv4;
            void $this$map$iv3;
            $this$mapTo$iv$iv2 = posts2;
            object2 = this.authSettingsService;
            boolean $i$f$map3 = false;
            void $i$f$mapTo22 = $this$map$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                void it;
                Post post = (Post)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl = false;
                iterable.add(it.getChannelId());
            }
            set = object2.filterOnlyManagersMayPin((Collection)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        Set onlyChannelManagersMayPin = set;
        Iterable $this$map$iv4 = onlyChannelManagersMayPin;
        boolean $i$f$map4 = false;
        destination$iv$iv = $this$map$iv4;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void channelId;
            ChannelId bl = (ChannelId)item$iv$iv;
            object2 = destination$iv$iv4;
            boolean bl3 = false;
            object2.add(Role.manage((String)channelId.toTypedString()));
        }
        List manageChannels = (List)destination$iv$iv4;
        List rolesToCheckPermission = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)readChannels, (Iterable)managePosts), (Object)noInteract), (Iterable)manageChannels);
        Set usersRoles = this.permissionConnector.filterUsersRoles((Collection)rolesToCheckPermission, (UserId)this.user);
        boolean mayInteractTenant = !usersRoles.contains(noInteract);
        destination$iv$iv4 = posts2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void post;
            Post post2 = (Post)element$iv$iv;
            iterable = element$iv$iv;
            object2 = result$iv;
            boolean bl = false;
            boolean mayReadChannel = usersRoles.contains(Role.read((String)post.getChannelId().toTypedString()));
            boolean mayManagePost = usersRoles.contains(Role.manage((String)post.getId().toTypedString()));
            $this$filter$iv = actions;
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                PostAction action = (PostAction)element$iv$iv2;
                boolean bl4 = false;
                if (!(switch (WhenMappings.$EnumSwitchMapping$1[action.ordinal()]) {
                    case 1 -> {
                        if (mayInteractTenant && mayReadChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> mayManagePost;
                    case 3 -> mayManagePost;
                    case 4 -> mayReadChannel;
                    case 5 -> {
                        if (onlyChannelManagersMayPin.contains(post.getChannelId())) {
                            boolean mayManageChannel;
                            yield mayManageChannel = usersRoles.contains(Role.manage((String)post.getChannelId().toTypedString()));
                        }
                        yield mayManagePost;
                    }
                    case 6 -> mayManagePost;
                    case 7 -> {
                        if (mayInteractTenant && mayReadChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    case 8 -> {
                        if (mayInteractTenant && mayReadChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                })) continue;
                destination$iv$iv5.add(element$iv$iv2);
            }
            Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv5));
            object2.put(iterable, set2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv6 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry mayReadChannel = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv6;
            boolean bl = false;
            $this$filter$iv = (Map.Entry)element$iv$iv$iv;
            PostId postId = ((Post)it.getKey()).getId();
            object = object2;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            object.put(postId, v);
        }
        return destination$iv$iv6;
    }

    public static /* synthetic */ Map getPostActions$default(AuthorizationContext authorizationContext, Collection collection, Collection collection2, int n, Object object) {
        if ((n & 2) != 0) {
            collection2 = CollectionsKt.toSet((Iterable)((Iterable)PostAction.getEntries()));
        }
        return authorizationContext.getPostActions(collection, collection2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<CommentId, Set<PostCommentAction>> getPostCommentActions(@NotNull ChannelId channelId, @NotNull Map<CommentId, ProfileId> commentIdToAuthorId, @NotNull Collection<? extends PostCommentAction> actions) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter(commentIdToAuthorId, (String)"commentIdToAuthorId");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Role role = Role.read((String)channelId.toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"read(...)");
        Role readChannel = role;
        Role role2 = Role.manage((String)channelId.toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role2, (String)"manage(...)");
        Role manageChannel = role2;
        Role role3 = Role.noInteract((String)this.tenantId.toTypedString());
        Intrinsics.checkNotNullExpressionValue((Object)role3, (String)"noInteract(...)");
        Role noInteract = role3;
        Object[] objectArray = new Role[]{readChannel, manageChannel, noInteract};
        Set rolesToCheckPermission = SetsKt.setOf((Object[])objectArray);
        Set usersRoles = this.permissionConnector.filterUsersRoles((Collection)rolesToCheckPermission, (UserId)this.user);
        boolean mayInteractTenant = !usersRoles.contains(noInteract);
        boolean mayReadChannel = usersRoles.contains(readChannel);
        boolean mayManageChannel = usersRoles.contains(manageChannel);
        Map<CommentId, ProfileId> $this$mapValues$iv = commentIdToAuthorId;
        boolean $i$f$mapValues = false;
        Map<CommentId, ProfileId> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            boolean isAuthor = Intrinsics.areEqual(entry.getValue(), (Object)this.user);
            Iterable $this$filter$iv = actions;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PostCommentAction action = (PostCommentAction)element$iv$iv;
                boolean bl3 = false;
                if (!(switch (WhenMappings.$EnumSwitchMapping$2[action.ordinal()]) {
                    case 1 -> isAuthor;
                    case 2 -> {
                        if (isAuthor || mayManageChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        if (mayInteractTenant && mayReadChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> {
                        if (mayInteractTenant && mayReadChannel) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                })) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            map3.put(k, set);
        }
        return destination$iv$iv;
    }

    public static /* synthetic */ Map getPostCommentActions$default(AuthorizationContext authorizationContext, ChannelId channelId, Map map, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            collection = CollectionsKt.toSet((Iterable)((Iterable)PostCommentAction.getEntries()));
        }
        return authorizationContext.getPostCommentActions(channelId, map, collection);
    }

    public final void checkRead(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.permissionConnector.checkRead(itemId, (UserId)this.user);
    }

    public final void checkReadAll(@NotNull Collection<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        this.permissionConnector.checkReadAll(itemIds, (UserId)this.user);
    }

    public final void checkAllReader(@NotNull ItemId itemId, @NotNull Collection<? extends UserId> granteeIds) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter(granteeIds, (String)"granteeIds");
        this.permissionConnector.checkAllReader(itemId, granteeIds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChannelId> filterReadable(@NotNull Collection<ChannelId> channelIds) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Map $this$filter$iv = this.permissionConnector.mayRead(channelIds, (UserId)this.user);
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type de.justsoftware.news.id.ChannelId");
            object.add((ChannelId)k);
        }
        return (List)destination$iv$iv;
    }

    public final void checkChannelAction(@NotNull ChannelId channelId, @NotNull ChannelAction action) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Set allowedActions = (Set)this.getChannelActions((Collection)SetsKt.setOf((Object)channelId), (Collection)SetsKt.setOf((Object)action)).get(channelId);
        Collection collection = allowedActions;
        if (collection == null || collection.isEmpty()) {
            throw new NotAuthorizedException(null, 1, null);
        }
    }

    public final void checkPostAction(@NotNull Post post, @NotNull PostAction action) {
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Set allowedActions = (Set)this.getPostActions((Collection)SetsKt.setOf((Object)post), (Collection)SetsKt.setOf((Object)action)).get(post.getId());
        Collection collection = allowedActions;
        if (collection == null || collection.isEmpty()) {
            throw new NotAuthorizedException(null, 1, null);
        }
    }

    public final void checkPostCommentAction(@NotNull ChannelId channelId, @NotNull PostComment comment, @NotNull PostCommentAction action) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Set allowedActions = (Set)this.getPostCommentActions(channelId, MapsKt.mapOf((Pair)TuplesKt.to((Object)comment.getId(), (Object)comment.getAuthorId())), (Collection)SetsKt.setOf((Object)action)).get(comment.getId());
        Collection collection = allowedActions;
        if (collection == null || collection.isEmpty()) {
            throw new NotAuthorizedException(null, 1, null);
        }
    }

    public final void checkManage(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.permissionConnector.checkManage(itemId, (UserId)this.user);
    }

    public final void checkWrite(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.permissionConnector.checkWrite(itemId, (UserId)this.user);
    }

    public final boolean mayChannelAction(@NotNull ChannelId channelId, @NotNull ChannelAction action) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Set set = (Set)this.getChannelActions((Collection)SetsKt.setOf((Object)channelId), (Collection)SetsKt.setOf((Object)action)).get(channelId);
        return set != null ? !((Collection)set).isEmpty() : false;
    }

    public final boolean isSuperAdmin() {
        return this.permissionConnector.isSuperAdmin((UserId)this.user);
    }

    public final boolean mayRead(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return (Boolean)CollectionsKt.first((Iterable)this.permissionConnector.mayRead((Collection)SetsKt.setOf((Object)itemId), (UserId)this.user).values());
    }

    public final boolean mayManage(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.permissionConnector.mayManage(itemId, (UserId)this.user);
    }

    public final boolean mayManageAll(@NotNull Collection<? extends ItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        return this.permissionConnector.mayManageAll(itemIds, (UserId)this.user);
    }

    public final boolean mayCreateChannel() {
        return this.permissionConnector.mayWriteAppNews(this.tenantId, (UserId)this.user);
    }

    public final void checkCreateChannel() {
        this.permissionConnector.checkAppWriterNews(this.tenantId, (UserId)this.user);
    }

    public final void checkUserEqual(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (!Intrinsics.areEqual((Object)profileId, (Object)this.user)) {
            throw new NotAuthorizedException("User '" + this.user + "' is not allowed to perform operations for user '" + profileId + "'!");
        }
    }
}

