/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.settings.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.settings.model.PlatformInfo;
import de.justsoftware.mobile.gateway.settings.model.PlatformSettings;
import de.justsoftware.mobile.gateway.settings.model.User;
import de.justsoftware.mobile.gateway.settings.service.SettingsService;
import de.justsoftware.mobile.gateway.toro.model.local.TranslationLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/settings"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017J\u001c\u0010\f\u001a\u00020\u000b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/mobile/gateway/settings/controller/SettingsController;", "", "settingsService", "Lde/justsoftware/mobile/gateway/settings/service/SettingsService;", "<init>", "(Lde/justsoftware/mobile/gateway/settings/service/SettingsService;)V", "getPlatformInfo", "Lde/justsoftware/mobile/gateway/settings/model/PlatformInfo;", "getPlatformSettings", "Lde/justsoftware/mobile/gateway/settings/model/PlatformSettings;", "getUser", "Lde/justsoftware/mobile/gateway/settings/model/User;", "updateTranslationLanguage", "translationLanguage", "Lde/justsoftware/mobile/gateway/toro/model/local/TranslationLanguage;", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "mobile-gateway"})
public class SettingsController {
    @NotNull
    private final SettingsService settingsService;

    public SettingsController(@NotNull SettingsService settingsService) {
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        this.settingsService = settingsService;
    }

    @GetMapping
    @NotNull
    public PlatformInfo getPlatformInfo() {
        return this.settingsService.getPlatformInfo();
    }

    @GetMapping(value={"/platform"})
    @NotNull
    public PlatformSettings getPlatformSettings() {
        return this.settingsService.getPlatformSettings();
    }

    @GetMapping(value={"/user"})
    @NotNull
    public User getUser() {
        return this.settingsService.getUser();
    }

    @PutMapping(value={"/user/preferredTranslationLanguage"})
    @NotNull
    public User updateTranslationLanguage(@RequestParam(name="translationLanguage", required=false) @Nullable TranslationLanguage translationLanguage, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.settingsService.updatePreferredTranslationLanguage(authContext.getProfileId(), translationLanguage);
    }
}

