/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.item;

import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;

@ParametersAreNonnullByDefault
@Mapper
public interface ItemMapper {
    public static final String ITEM_BO_MAP = "ITEM_BO_MAP";

    @Insert(value={"INSERT INTO item(id)", "VALUES (#{itemId})"})
    public void create(@Param(value="itemId") ItemId var1);

    @Select(value={"<script>", "SELECT id FROM item", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=ItemId.class)
    public void getExistingItemIds(ResultHandler<ItemId> var1, @Param(value="ids") List<ItemId> var2);

    @Update(value={"UPDATE item", "SET name = #{name}", "WHERE id = #{id}"})
    public void updateName(@Param(value="id") ItemId var1, @Param(value="name") @Nullable String var2);

    @Update(value={"UPDATE item", "SET tenant_id = #{tenantId}", "WHERE id = #{id} AND tenant_id IS NULL"})
    public void setTenantIdIfNotExists(@Param(value="id") ItemId var1, @Param(value="tenantId") @Nullable TenantId var2);

    @Select(value={"<script>", "SELECT * FROM item", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=ItemBO.class)
    @Results(id="ITEM_BO_MAP")
    @ConstructorArgs(value={@Arg(column="id", id=true, javaType=ItemId.class), @Arg(column="name", javaType=String.class), @Arg(column="deleted", javaType=boolean.class), @Arg(column="tenant_id", javaType=TenantId.class)})
    public void getItems(ResultHandler<ItemBO> var1, @Param(value="ids") List<ItemId> var2);

    @Update(value={"<script>", "UPDATE item", "SET deleted = 't'", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void markAsDeleted(@Param(value="ids") List<ItemId> var1);

    @Update(value={"UPDATE item SET", "deleted = 'f',", "name = #{_name},", "tenant_id = #{_tenantId}", "WHERE id = #{_itemId}"})
    public void updateItem(ItemCreateModel var1);

    @Select(value={"SELECT item_id", "FROM change", "GROUP BY item_id"})
    @ResultType(value=ItemId.class)
    public void forAllItemsWithDocuments(ResultHandler<ItemId> var1);

    @Select(value={"SELECT item_id", "FROM change", "WHERE item_id LIKE #{type} || ',%'", "GROUP BY item_id", "HAVING COUNT(1) >= #{numberOfChanges}"})
    @ResultType(value=ItemId.class)
    public void forEachItemOfTypeWithAtLeastNChanges(@Param(value="type") String var1, @Param(value="numberOfChanges") int var2, ResultHandler<ItemId> var3);

    @Select(value={"SELECT * FROM item WHERE id LIKE 'SHARE,%'"})
    @ResultMap(value={"ITEM_BO_MAP"})
    public void forAllShareItems(ResultHandler<ItemBO> var1);

    @Select(value={"SELECT id FROM item WHERE tenant_id = #{tenantId} and id LIKE 'SHARE,%' and deleted = 'f'"})
    public Set<ItemId> getAllShareIds(TenantId var1);

    @Select(value={"SELECT * FROM item WHERE tenant_id = #{tenantId} and id LIKE 'SHARE,%' and deleted = 'f'"})
    @ResultType(value=ItemBO.class)
    @ConstructorArgs(value={@Arg(column="id", id=true, javaType=ItemId.class), @Arg(column="name", javaType=String.class), @Arg(column="deleted", javaType=boolean.class), @Arg(column="tenant_id", javaType=TenantId.class)})
    public Set<ItemBO> getAllSharesForTenant(TenantId var1);

    @Select(value={"SELECT id", "FROM item", "WHERE mtime < #{before}", "   AND deleted = 't'"})
    @Nonnull
    public Set<ItemId> getDeletedItems(@Param(value="before") Instant var1);

    @Select(value={"<script>", "SELECT id", "FROM item", "WHERE deleted = 't'", "   AND id IN (<foreach collection='items' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=ItemId.class)
    public void filterDeleted(ResultHandler<ItemId> var1, @Param(value="items") List<ItemId> var2);

    @Delete(value={"<script>", "DELETE FROM item", "WHERE id IN (<foreach collection='items' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteItems(@Param(value="items") List<ItemId> var1);
}

