/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import de.justsoftware.drive.common.authorization.model.Role;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ItemActionCondition {
    private static final String OR_SEPARATOR = " or ";

    private ItemActionCondition() {
    }

    @Nonnull
    static FluentIterable<Role> parseRoles(String condition) {
        return FluentIterable.from((Iterable)Splitter.on((String)OR_SEPARATOR).split((CharSequence)condition)).transform(Role::valueOf);
    }

    @Nonnull
    static String joinToCondition(Collection<Role> roles) {
        return FluentIterable.from(roles).transform(Role::getRoleString).join(Joiner.on((String)OR_SEPARATOR).skipNulls());
    }
}

